/*
 * Decompiled with CFR 0.152.
 */
package ij.io;

import ij.gui.OvalRoi;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class RoiDecoder {
    private final int polygon = 0;
    private final int rect = 1;
    private final int oval = 2;
    private final int line = 3;
    private final int freeLine = 4;
    private final int segLine = 5;
    private final int noRoi = 6;
    private final int freehand = 7;
    private final int traced = 8;
    private byte[] data;
    private String path;

    public RoiDecoder(String string) {
        this.path = string;
    }

    public Roi getRoi() throws IOException {
        File file = new File(this.path);
        int n = (int)file.length();
        if (n > 5000) {
            throw new IOException("This is not an ImageJ ROI");
        }
        FileInputStream fileInputStream = new FileInputStream(this.path);
        this.data = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            n2 += fileInputStream.read(this.data, n2, n - n2);
        }
        if (this.getByte(0) != 73 || this.getByte(1) != 111) {
            throw new IOException("This is not an ImageJ ROI");
        }
        int n3 = this.getByte(6);
        int n4 = this.getShort(8);
        int n5 = this.getShort(10);
        int n6 = this.getShort(12);
        int n7 = this.getShort(14);
        int n8 = n7 - n5;
        int n9 = n6 - n4;
        int n10 = this.getShort(16);
        Roi roi = null;
        switch (n3) {
            case 1: {
                roi = new Roi(n5, n4, n8, n9, null);
                break;
            }
            case 2: {
                roi = new OvalRoi(n5, n4, n8, n9, null);
                break;
            }
            case 3: {
                this.getFloat(18);
                this.getFloat(22);
                this.getFloat(26);
                this.getFloat(30);
                break;
            }
            case 0: 
            case 7: 
            case 8: {
                if (n10 == 0) break;
                int[] nArray = new int[n10];
                int[] nArray2 = new int[n10];
                int n11 = 64;
                int n12 = n11 + 2 * n10;
                int n13 = 0;
                while (n13 < n10) {
                    int n14;
                    int n15 = this.getShort(n11 + n13 * 2);
                    if (n15 < 0) {
                        n15 = 0;
                    }
                    if ((n14 = this.getShort(n12 + n13 * 2)) < 0) {
                        n14 = 0;
                    }
                    nArray[n13] = n5 + n15;
                    nArray2[n13] = n4 + n14;
                    ++n13;
                }
                n13 = n3 == 0 ? 2 : (n3 == 7 ? 3 : 4);
                roi = new PolygonRoi(nArray, nArray2, n10, null, n13);
                break;
            }
        }
        return roi;
    }

    int getByte(int n) {
        return this.data[n] & 0xFF;
    }

    int getShort(int n) {
        int n2 = this.data[n] & 0xFF;
        int n3 = this.data[n + 1] & 0xFF;
        return (short)((n2 << 8) + n3);
    }

    int getInt(int n) {
        int n2 = this.data[n] & 0xFF;
        int n3 = this.data[n + 1] & 0xFF;
        int n4 = this.data[n + 2] & 0xFF;
        int n5 = this.data[n + 3] & 0xFF;
        return (n2 << 24) + (n3 << 16) + (n4 << 8) + n5;
    }

    float getFloat(int n) {
        return Float.intBitsToFloat(this.getInt(n));
    }
}

