/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.io.OpenDialog;
import ij.measure.Calibration;
import ij.plugin.FitsDecoder;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.io.IOException;

public class FITS
extends ImagePlus
implements PlugIn {
    public void run(String arg) {
        OpenDialog od = new OpenDialog("Open FITS...", arg);
        String directory = od.getDirectory();
        String fileName = od.getFileName();
        if (fileName == null) {
            return;
        }
        IJ.showStatus("Opening: " + directory + fileName);
        FitsDecoder fd = new FitsDecoder(directory, fileName);
        FileInfo fi = null;
        try {
            fi = fd.getInfo();
        }
        catch (IOException iOException) {}
        if (fi != null && fi.width > 0 && fi.height > 0 && fi.offset > 0) {
            FileOpener fo = new FileOpener(fi);
            ImagePlus imp = fo.open(false);
            ImageProcessor ip = imp.getProcessor();
            this.setProcessor(fileName, ip);
            Calibration cal = imp.getCalibration();
            if (fi.fileType == 1 && fd.bscale == 1.0 && fd.bzero == 32768.0) {
                cal.setFunction(20, null, "Gray Value");
            }
            this.setCalibration(cal);
            this.setProperty("Info", fd.getHeaderInfo());
            if (arg.equals("")) {
                this.show();
            }
        } else {
            IJ.error("This does not appear to be a FITS file.");
        }
        IJ.showStatus("");
    }
}

