/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import java.awt.Checkbox;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.TextEvent;

class FolderOpenerDialog
extends GenericDialog {
    ImagePlus imp;
    int fileCount;
    boolean eightBits;
    boolean halfSize;
    String saveFilter = "";
    String[] list;

    public FolderOpenerDialog(String title, ImagePlus imp, String[] list) {
        super(title);
        this.imp = imp;
        this.list = list;
        this.fileCount = list.length;
    }

    protected void setup() {
        this.setStackInfo();
    }

    public void itemStateChanged(ItemEvent e) {
        this.setStackInfo();
    }

    public void textValueChanged(TextEvent e) {
        this.setStackInfo();
    }

    void setStackInfo() {
        TextField tf;
        String filter;
        int width = this.imp.getWidth();
        int height = this.imp.getHeight();
        int bytesPerPixel = 1;
        this.eightBits = ((Checkbox)this.checkbox.elementAt(0)).getState();
        this.halfSize = ((Checkbox)this.checkbox.elementAt(1)).getState();
        int n = this.getNumber(this.numberField.elementAt(0));
        int start = this.getNumber(this.numberField.elementAt(1));
        if (n < 1) {
            n = this.fileCount;
        }
        if (start < 1 || start > this.fileCount) {
            start = 1;
        }
        if (start + n - 1 > this.fileCount) {
            n = this.fileCount - start + 1;
        }
        if (!(filter = (tf = (TextField)this.stringField.elementAt(0)).getText()).equals("") && !filter.equals("*")) {
            int n2 = n;
            n = 0;
            int i = start - 1;
            while (i < start - 1 + n2) {
                if (this.list[i].indexOf(filter) >= 0) {
                    ++n;
                }
                ++i;
            }
            this.saveFilter = filter;
        }
        switch (this.imp.getType()) {
            case 1: {
                bytesPerPixel = 2;
                break;
            }
            case 2: 
            case 4: {
                bytesPerPixel = 4;
                break;
            }
        }
        if (this.eightBits) {
            bytesPerPixel = 1;
        }
        if (this.halfSize) {
            width /= 2;
            height /= 2;
        }
        double size = (double)(width * height * n * bytesPerPixel) / 1048576.0;
        ((Label)this.theLabel).setText(String.valueOf(width) + " x " + height + " x " + n + " (" + IJ.d2s(size, 1) + "MB)");
    }

    public int getNumber(Object field) {
        Double d;
        TextField tf = (TextField)field;
        String theText = tf.getText();
        try {
            d = new Double(theText);
        }
        catch (NumberFormatException numberFormatException) {
            d = null;
        }
        if (d != null) {
            return (int)d.doubleValue();
        }
        return 0;
    }
}

