/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Font;

public class MemoryMonitor
implements PlugIn {
    int width = 200;
    int height = 75;
    long fps;
    long startTime;
    long elapsedTime;
    ImageProcessor ip;
    int frames;
    ImageCanvas ic;
    int[] mem;
    int index;
    int value;
    int max = 14794752;

    void showAbout() {
        IJ.showMessage("About MemoryMonitor...", "This plugin continuously plots ImageJ's memory\nutilization. It could also be used as a starting\npoint for a video acquisition plugin. Hold down the\nalt/option key when selecting the \"Monitor Memory\"\ncommand and the plugin will use a 640x480 window\nand display the frame rate. Click on the status bar in the\nImageJ window to force the JVM to do garbage collection.");
    }

    public void run(String string) {
        if (string.equals("about")) {
            this.showAbout();
            return;
        }
        if (IJ.altKeyDown()) {
            this.width = 640;
            this.height = 480;
        }
        this.ip = new ByteProcessor(this.width, this.height, new byte[this.width * this.height], null);
        this.ip.setColor(Color.white);
        this.ip.fill();
        this.ip.setColor(Color.black);
        this.ip.setFont(new Font("SansSerif", 0, 12));
        this.ip.snapshot();
        ImagePlus imagePlus = new ImagePlus("Memory", this.ip);
        imagePlus.show();
        imagePlus.lock();
        ImageWindow imageWindow = imagePlus.getWindow();
        this.ic = imageWindow.getCanvas();
        this.mem = new int[this.width + 1];
        Thread.currentThread().setPriority(1);
        this.startTime = System.currentTimeMillis();
        imageWindow.running = true;
        while (imageWindow.running) {
            this.updatePixels();
            this.showValue();
            imagePlus.updateAndDraw();
            if (this.width == 640) {
                Thread.yield();
            } else {
                IJ.wait(100);
            }
            ++this.frames;
        }
        imagePlus.unlock();
    }

    void showValue() {
        String string = String.valueOf(this.value / 1024) + "K";
        if (this.width == 640) {
            this.elapsedTime = System.currentTimeMillis() - this.startTime;
            if (this.elapsedTime > 0L) {
                this.ic.getMagnification();
                this.fps = (long)(this.frames * 10000) / this.elapsedTime;
                string = String.valueOf(string) + ", " + this.fps / 10L + "." + this.fps % 10L + " fps";
            }
        }
        this.ip.moveTo(2, 15);
        this.ip.drawString(string);
    }

    int memoryInUse() {
        long l = Runtime.getRuntime().freeMemory();
        long l2 = Runtime.getRuntime().totalMemory();
        return (int)(l2 - l);
    }

    void updatePixels() {
        int n = this.memoryInUse();
        if (this.frames % 10 == 0) {
            this.value = n;
        }
        if ((double)n > 0.9 * (double)this.max) {
            this.max *= 2;
        }
        this.mem[this.index++] = n;
        if (this.index == this.mem.length) {
            this.index = 0;
        }
        this.ip.reset();
        int n2 = this.index + 1;
        if (n2 == this.mem.length) {
            n2 = 0;
        }
        double d = (double)this.height / (double)this.max;
        this.ip.moveTo(0, this.height - (int)((double)this.mem[n2] * d));
        int n3 = 1;
        while (n3 < this.width) {
            if (++n2 == this.mem.length) {
                n2 = 0;
            }
            this.ip.lineTo(n3, this.height - (int)((double)this.mem[n2] * d));
            ++n3;
        }
    }
}

