/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.WindowManager;
import ij.gui.NewImage;
import ij.plugin.PlugIn;
import java.util.Vector;

public class MemoryTest
implements PlugIn {
    public void run(String string) {
        boolean bl = IJ.showMessageWithCancel("Memory Test", "The MemoryTest plugin opens as many\n1024x1024x8-bit images as possible and then\ncalculates how much memory was used for each\nimage. This is a demanding test that may require\nImageJ to be restarted, may crash your browser, \nor may even crash your machine.");
        if (!bl) {
            return;
        }
        int n = 1024;
        int n2 = 0x100000;
        int n3 = 0;
        int n4 = 0;
        IJ.write("");
        IJ.write("Opening " + n + "x" + n + " 8-bit image windows...");
        this.collectGarbage();
        int[] nArray = new int[2000];
        long l = System.currentTimeMillis();
        try {
            while (true) {
                NewImage.open(String.valueOf(n4 + 1), n, n, 1, 0, 0);
                long l2 = System.currentTimeMillis();
                nArray[n4] = (int)(l2 - l);
                l = l2;
                ++n4;
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            IJ.write("Closing windows...");
            WindowManager.closeAllWindows();
            this.collectGarbage();
            IJ.wait(100);
            Vector<byte[]> vector = new Vector<byte[]>();
            IJ.write("Probing memory...");
            try {
                while (true) {
                    System.gc();
                    byte[] byArray = new byte[n2];
                    vector.addElement(byArray);
                    IJ.showStatus(String.valueOf(++n3 * n2 / 0x100000) + "MB");
                    IJ.wait(50);
                }
            }
            catch (OutOfMemoryError outOfMemoryError2) {
                vector = null;
                this.collectGarbage();
                IJ.write(String.valueOf(n2 * n3 / 0x100000) + "MB is available");
                IJ.write(String.valueOf(n4) + " images were opened");
                if (n4 > 0) {
                    IJ.write("~" + n2 * n3 / (n4 * 1024) + "K was required for each image");
                }
                IJ.write("");
                IJ.showStatus("");
                return;
            }
        }
    }

    void collectGarbage() {
        int n = 0;
        while (n < 10) {
            System.gc();
            ++n;
        }
    }
}

