/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.io.OpenDialog;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamTokenizer;

public class PGM_Reader
extends ImagePlus
implements PlugIn {
    private int width;
    private int height;
    private boolean rawBits;

    public void run(String string) {
        ImageProcessor imageProcessor;
        OpenDialog openDialog = new OpenDialog("PGM Reader...", string);
        String string2 = openDialog.getDirectory();
        String string3 = openDialog.getFileName();
        if (string3 == null) {
            return;
        }
        String string4 = String.valueOf(string2) + string3;
        IJ.showStatus("Opening: " + string4);
        try {
            imageProcessor = this.openFile(string4);
        }
        catch (Exception exception) {
            IJ.showMessage("PGM Reader", exception.getMessage());
            return;
        }
        this.setProcessor(string3, imageProcessor);
        if (string.equals("")) {
            this.show();
        }
    }

    public ImageProcessor openFile(String string) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
        StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedInputStream);
        streamTokenizer.resetSyntax();
        streamTokenizer.wordChars(33, 255);
        streamTokenizer.whitespaceChars(0, 32);
        streamTokenizer.parseNumbers();
        streamTokenizer.eolIsSignificant(true);
        streamTokenizer.commentChar(35);
        this.openHeader(streamTokenizer);
        byte[] byArray = new byte[this.width * this.height];
        ByteProcessor byteProcessor = new ByteProcessor(this.width, this.height, byArray, null);
        if (this.rawBits) {
            this.openRawImage(bufferedInputStream, this.width * this.height, byArray);
        } else {
            this.openAsciiImage(streamTokenizer, this.width * this.height, byArray);
        }
        return byteProcessor;
    }

    public void openHeader(StreamTokenizer streamTokenizer) throws IOException {
        String string = this.getWord(streamTokenizer);
        if (string.equals("P5")) {
            this.rawBits = true;
        } else if (!string.equals("P2")) {
            throw new IOException("PGM files must start with \"P2\" or \"P5\"");
        }
        this.width = this.getInt(streamTokenizer);
        this.height = this.getInt(streamTokenizer);
        int n = this.getInt(streamTokenizer);
        if (this.width == -1 || this.height == -1 || n == -1) {
            throw new IOException("Error opening PGM header..");
        }
        if (n > 255) {
            throw new IOException("The maximum gray vale is larger than 255.");
        }
    }

    public void openAsciiImage(StreamTokenizer streamTokenizer, int n, byte[] byArray) throws IOException {
        int n2 = 0;
        int n3 = n / 20;
        while (streamTokenizer.nextToken() != -1) {
            if (streamTokenizer.ttype != -2) continue;
            byArray[n2++] = (byte)((int)streamTokenizer.nval & 0xFF);
            if (n2 % n3 != 0) continue;
            IJ.showProgress(0.5 + (double)n2 / (double)n / 2.0);
        }
        IJ.showProgress(1.0);
    }

    public void openRawImage(InputStream inputStream, int n, byte[] byArray) throws IOException {
        int n2 = 0;
        while (n2 < n && n2 >= 0) {
            n2 = inputStream.read(byArray, n2, n - n2);
        }
    }

    String getWord(StreamTokenizer streamTokenizer) throws IOException {
        while (streamTokenizer.nextToken() != -1) {
            if (streamTokenizer.ttype != -3) continue;
            return streamTokenizer.sval;
        }
        return null;
    }

    int getInt(StreamTokenizer streamTokenizer) throws IOException {
        while (streamTokenizer.nextToken() != -1) {
            if (streamTokenizer.ttype != -2) continue;
            return (int)streamTokenizer.nval;
        }
        return -1;
    }
}

