/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.Roi;
import ij.io.OpenDialog;
import ij.io.RoiDecoder;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Rectangle;
import java.io.IOException;

public class RoiReader
implements PlugIn {
    final int polygon = 0;
    final int rect = 1;
    final int oval = 2;
    final int line = 3;
    final int freeLine = 4;
    final int segLine = 5;
    final int noRoi = 6;
    final int freehand = 7;
    final int traced = 8;
    byte[] data;

    public void run(String string) {
        OpenDialog openDialog = new OpenDialog("Open ROI...", string);
        String string2 = openDialog.getDirectory();
        String string3 = openDialog.getFileName();
        if (string3 == null) {
            return;
        }
        try {
            this.openRoi(string2, string3);
        }
        catch (IOException iOException) {
            String string4 = iOException.getMessage();
            if (string4 == null || string4.equals("")) {
                string4 = String.valueOf(String.valueOf(iOException));
            }
            IJ.showMessage("ROI Reader", string4);
        }
    }

    public void openRoi(String string, String string2) throws IOException {
        String string3 = String.valueOf(string) + string2;
        RoiDecoder roiDecoder = new RoiDecoder(string3);
        Roi roi = roiDecoder.getRoi();
        Rectangle rectangle = roi.getBoundingRect();
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null || imagePlus.getWidth() < rectangle.x + rectangle.width || imagePlus.getHeight() < rectangle.y + rectangle.height) {
            ByteProcessor byteProcessor = new ByteProcessor(rectangle.x + rectangle.width + 10, rectangle.y + rectangle.height + 10);
            ((ImageProcessor)byteProcessor).setColor(Color.white);
            byteProcessor.fill();
            imagePlus = new ImagePlus(string2, byteProcessor);
            imagePlus.show();
        }
        imagePlus.setRoi(roi);
    }
}

