/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.MessageDialog;
import ij.plugin.PlugIn;
import java.awt.Frame;

public class SimpleCommands
implements PlugIn {
    public void run(String string) {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (string.equals("about")) {
            this.showAboutBox();
            return;
        }
        if (imagePlus == null) {
            IJ.noImage();
            return;
        }
        if (string.equals("unlock")) {
            this.unlock(imagePlus);
        } else if (string.equals("rename")) {
            this.rename(imagePlus);
        }
    }

    void unlock(ImagePlus imagePlus) {
        boolean bl = imagePlus.lockSilently();
        if (bl) {
            IJ.showMessage("Unlocker", "\"" + imagePlus.getTitle() + "\" is not locked.");
        } else {
            IJ.showMessage("Unlocker", "\"" + imagePlus.getTitle() + "\" is now unlocked.");
        }
        imagePlus.unlock();
    }

    void rename(ImagePlus imagePlus) {
        GenericDialog genericDialog = new GenericDialog("Rename");
        genericDialog.addStringField("Title:", imagePlus.getTitle(), 30);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        imagePlus.setTitle(genericDialog.getNextString());
    }

    void showAboutBox() {
        new MessageDialog((Frame)IJ.getInstance(), "About ImageJ...", "         ImageJ 1.27g\n \nWayne Rasband (wayne@codon.nih.gov)\nNational Institutes of Health, USA\nhttp://rsb.info.nih.gov/ij/\n \nImageJ is in the public domain.");
    }
}

