/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Line;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.StackProcessor;
import java.awt.Rectangle;
import java.awt.image.ColorModel;

public class Slicer
implements PlugIn {
    private double xinc;
    private double yinc;
    private double xstart;
    private double ystart;
    private double xend;
    private double yend;
    private double dx;
    private double dy;
    private int number;
    private double zscale;
    private int swidth = 1;
    private static boolean interpolate = true;
    private ColorModel cmod;
    private int width;
    private int height;
    private ImagePlus imp;
    static /* synthetic */ Class class$ij$plugin$Slicer;

    public void run(String string) {
        this.imp = WindowManager.getCurrentImage();
        if (this.imp == null) {
            IJ.noImage();
            return;
        }
        if (this.imp.getStackSize() < 2) {
            IJ.error("Stack required");
            return;
        }
        Roi roi = this.imp.getRoi();
        if (roi == null || roi.getType() != 5 && roi.getType() != 0) {
            IJ.error("Straight line or rectangular selection required");
            return;
        }
        if (roi.getType() == 0) {
            this.swidth = roi.getBoundingRect().height;
        }
        Calibration calibration = this.imp.getCalibration();
        String string2 = calibration.getUnits();
        GenericDialog genericDialog = new GenericDialog("Slice Parameters", IJ.getInstance());
        genericDialog.addNumericField("Z-Spacing (" + string2 + "):", calibration.pixelDepth, 1);
        genericDialog.addNumericField("Slice Width (pixels):", this.swidth, 0);
        genericDialog.addCheckbox("Interpolate", interpolate);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        calibration.pixelDepth = genericDialog.getNextNumber();
        if (calibration.pixelWidth == 0.0) {
            calibration.pixelWidth = 1.0;
        }
        this.zscale = calibration.pixelDepth / calibration.pixelWidth;
        this.swidth = (int)genericDialog.getNextNumber();
        interpolate = genericDialog.getNextBoolean();
        long l = System.currentTimeMillis();
        if (!this.imp.lock()) {
            return;
        }
        ImagePlus imagePlus = this.sliceImage(this.imp, roi);
        if (this.imp.getType() != 4) {
            ImageProcessor imageProcessor = this.imp.getProcessor();
            double d = imageProcessor.getMin();
            double d2 = imageProcessor.getMax();
            imageProcessor = imagePlus.getProcessor();
            imageProcessor.setMinAndMax(d, d2);
        }
        this.imp.unlock();
        imagePlus.setCalibration(calibration);
        imagePlus.getCalibration().pixelDepth = calibration.pixelWidth;
        long l2 = System.currentTimeMillis();
        double d = (double)(l2 - l) / 1000.0;
        imagePlus.show("Slicer: " + IJ.d2s(d, 2) + " seconds");
        IJ.register(class$ij$plugin$Slicer != null ? class$ij$plugin$Slicer : (class$ij$plugin$Slicer = Slicer.class$("ij.plugin.Slicer")));
    }

    public void setZScaling(double d) {
        this.zscale = d;
    }

    public void setSliceWidth(int n) {
        this.swidth = n;
    }

    public ImagePlus sliceImage(ImagePlus imagePlus, Roi roi) {
        this.adjustParameters(imagePlus);
        this.initParameters(imagePlus);
        ImageStack imageStack = imagePlus.getStack();
        ImageStack imageStack2 = this.stackSlice(imageStack, roi);
        if (this.zscale != 1.0) {
            imageStack2 = this.applyZScaling(imageStack2);
        }
        return new ImagePlus("Slice", imageStack2);
    }

    private ImageStack stackSlice(ImageStack imageStack, Roi roi) {
        this.setLineParams(roi);
        double d = Math.sqrt(this.dx * this.dx + this.dy * this.dy);
        double d2 = -this.dy / d;
        double d3 = this.dx / d;
        ImageStack imageStack2 = new ImageStack(this.number, imageStack.getSize(), this.cmod);
        int n = 0;
        while (n < this.swidth) {
            ImageProcessor imageProcessor = this.processorSlice(imageStack, roi);
            int n2 = this.imp.getType();
            switch (n2) {
                case 0: {
                    imageProcessor = imageProcessor.convertToByte(false);
                    break;
                }
                case 1: {
                    imageProcessor = imageProcessor.convertToShort(false);
                    break;
                }
            }
            imageStack2.addSlice("", imageProcessor);
            this.xstart += d2;
            this.ystart += d3;
            this.xend += d2;
            this.yend += d3;
            if (n % 3 == 0) {
                IJ.showProgress((double)n / (double)this.swidth);
            }
            ++n;
        }
        IJ.showProgress(1.0);
        return imageStack2;
    }

    private ImageProcessor processorSlice(ImageStack imageStack, Roi roi) {
        ImageProcessor imageProcessor = imageStack.getProcessor(1);
        int n = this.number;
        int n2 = imageStack.getSize();
        ImageProcessor imageProcessor2 = this.imp.getType() == 4 ? imageProcessor.createProcessor(n, n2) : new FloatProcessor(n, n2, new float[n * n2], this.cmod);
        ImageProcessor imageProcessor3 = imageProcessor.createProcessor(imageProcessor.getWidth(), imageProcessor.getHeight());
        imageProcessor3.setInterpolate(interpolate);
        int n3 = imageStack.getSize() - 1;
        int n4 = 1;
        while (n4 <= imageStack.getSize()) {
            imageProcessor3.setPixels(imageStack.getPixels(n4));
            this.line2Image(imageProcessor3, imageProcessor2, n3);
            ++n4;
            --n3;
        }
        imageProcessor3 = null;
        return imageProcessor2;
    }

    private ImageStack applyZScaling(ImageStack imageStack) {
        if (this.zscale > 25.0) {
            this.zscale = 25.0;
        }
        if (this.zscale < 0.05) {
            this.zscale = 0.05;
        }
        ImageProcessor imageProcessor = imageStack.getProcessor(1);
        StackProcessor stackProcessor = new StackProcessor(imageStack, imageProcessor);
        imageProcessor.setInterpolate(interpolate);
        return stackProcessor.resize(imageStack.getWidth(), (int)(this.zscale * (double)imageStack.getHeight()));
    }

    private void line2Image(ImageProcessor imageProcessor, ImageProcessor imageProcessor2, int n) {
        boolean bl;
        double d = this.xstart;
        double d2 = this.ystart;
        boolean bl2 = bl = interpolate && (this.xinc != 1.0 || this.yinc != 0.0);
        if (imageProcessor2 instanceof FloatProcessor) {
            int n2 = 0;
            while (n2 < this.number) {
                double d3 = bl ? imageProcessor.getInterpolatedPixel(d, d2) : (double)imageProcessor.getPixelValue((int)(d + 0.5), (int)(d2 + 0.5));
                d += this.xinc;
                d2 += this.yinc;
                imageProcessor2.putPixelValue(n2, n, d3);
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < this.number) {
                int n4 = imageProcessor.getPixel((int)(d + 0.5), (int)(d2 + 0.5));
                d += this.xinc;
                d2 += this.yinc;
                imageProcessor2.putPixel(n3, n, n4);
                ++n3;
            }
        }
    }

    private void setLineParams(Roi roi) {
        if (roi.getType() == 0) {
            Rectangle rectangle = roi.getBoundingRect();
            this.dx = rectangle.width;
            this.dy = 0.0;
            this.number = (int)this.dx;
            this.xinc = 1.0;
            this.yinc = 0.0;
            this.xstart = rectangle.x;
            this.ystart = rectangle.y;
            this.xend = this.xstart + (double)rectangle.width;
            this.yend = this.ystart;
        } else {
            Line line = (Line)roi;
            this.dx = line.x2 - line.x1;
            this.dy = line.y2 - line.y1;
            this.number = (int)((double)Math.round(Math.sqrt(this.dx * this.dx + this.dy * this.dy)) + 0.5);
            this.xinc = this.dx / (double)this.number;
            this.yinc = this.dy / (double)this.number;
            this.xstart = line.x1;
            this.ystart = line.y1;
            this.xend = line.x2;
            this.yend = line.y2;
        }
    }

    private void adjustParameters(ImagePlus imagePlus) {
        if (this.zscale < 0.0) {
            this.zscale = 1.0;
        }
        int n = imagePlus.getWidth();
        int n2 = imagePlus.getHeight();
        int n3 = (int)Math.sqrt(n * n + n2 * n2);
        if (this.swidth < 1 || this.swidth > n3) {
            this.swidth = 1;
        }
    }

    private void initParameters(ImagePlus imagePlus) {
        this.cmod = imagePlus.getProcessor().getColorModel();
        this.width = imagePlus.getWidth();
        this.height = imagePlus.getHeight();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

