/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.plugin.filter.RollingBall;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;

public class BackgroundSubtracter
implements PlugInFilter {
    private static int radius = 50;
    private static boolean whiteBackground = true;
    private ImagePlus imp;
    private boolean canceled;
    private int slice;
    private boolean invert;
    static /* synthetic */ Class class$ij$plugin$filter$BackgroundSubtracter;

    public int setup(String string, ImagePlus imagePlus) {
        IJ.register(class$ij$plugin$filter$BackgroundSubtracter != null ? class$ij$plugin$filter$BackgroundSubtracter : (class$ij$plugin$filter$BackgroundSubtracter = BackgroundSubtracter.class$("ij.plugin.filter.BackgroundSubtracter")));
        this.imp = imagePlus;
        if (imagePlus != null) {
            this.showDialog();
            if (this.canceled) {
                return 4096;
            }
        }
        IJ.register(class$ij$plugin$filter$BackgroundSubtracter != null ? class$ij$plugin$filter$BackgroundSubtracter : (class$ij$plugin$filter$BackgroundSubtracter = BackgroundSubtracter.class$("ij.plugin.filter.BackgroundSubtracter")));
        return IJ.setupDialog(imagePlus, 17);
    }

    public void run(ImageProcessor imageProcessor) {
        if (this.canceled) {
            return;
        }
        ++this.slice;
        if (this.slice > 1) {
            IJ.showStatus("Subtract Background: " + this.slice + "/" + this.imp.getStackSize());
        }
        if (imageProcessor instanceof ColorProcessor) {
            this.subtractRGBBackround((ColorProcessor)imageProcessor, radius);
        } else {
            this.subtractBackround(imageProcessor, radius);
        }
    }

    public void showDialog() {
        GenericDialog genericDialog = new GenericDialog("Subtract Background");
        genericDialog.addNumericField("Rolling Ball Radius:", radius, 0);
        genericDialog.addCheckbox("White Background", whiteBackground);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            this.canceled = true;
        } else {
            radius = (int)genericDialog.getNextNumber();
            whiteBackground = genericDialog.getNextBoolean();
        }
        boolean bl = this.imp.isInvertedLut();
        this.invert = bl && !whiteBackground || !bl && whiteBackground;
    }

    public void subtractRGBBackround(ColorProcessor colorProcessor, int n) {
        int n2 = colorProcessor.getWidth();
        int n3 = colorProcessor.getHeight();
        byte[] byArray = new byte[n2 * n3];
        byte[] byArray2 = new byte[n2 * n3];
        byte[] byArray3 = new byte[n2 * n3];
        colorProcessor.getHSB(byArray, byArray2, byArray3);
        ByteProcessor byteProcessor = new ByteProcessor(n2, n3, byArray3, null);
        this.subtractBackround(byteProcessor, radius);
        colorProcessor.setHSB(byArray, byArray2, (byte[])byteProcessor.getPixels());
    }

    public void subtractBackround(ImageProcessor imageProcessor, int n) {
        if (this.imp != null) {
            this.imp.killRoi();
        } else {
            imageProcessor.setRoi(null);
        }
        imageProcessor.setProgressBar(null);
        IJ.showProgress(0.0);
        if (this.invert) {
            imageProcessor.invert();
        }
        RollingBall rollingBall = new RollingBall(n);
        ImageProcessor imageProcessor2 = this.shrinkImage(imageProcessor, rollingBall.shrinkfactor);
        if (this.slice == 1) {
            IJ.showStatus("Rolling ball (" + rollingBall.shrinkfactor + ")...");
        }
        ImageProcessor imageProcessor3 = this.rollBall(rollingBall, imageProcessor, imageProcessor2);
        this.interpolateBackground(imageProcessor3, rollingBall);
        this.extrapolateBackground(imageProcessor3, rollingBall);
        IJ.showProgress(0.9);
        if (IJ.altKeyDown()) {
            new ImagePlus("background", imageProcessor3).show();
        }
        imageProcessor.copyBits(imageProcessor3, 0, 0, 4);
        if (this.invert) {
            imageProcessor.invert();
        }
        IJ.showProgress(1.0);
    }

    ImageProcessor rollBall(RollingBall rollingBall, ImageProcessor imageProcessor, ImageProcessor imageProcessor2) {
        byte[] byArray = (byte[])imageProcessor2.getPixels();
        byte[] byArray2 = rollingBall.data;
        int n = imageProcessor.getWidth();
        int n2 = imageProcessor.getHeight();
        int n3 = imageProcessor2.getWidth();
        imageProcessor2.getHeight();
        ByteProcessor byteProcessor = new ByteProcessor(n, n2);
        byte[] byArray3 = (byte[])((ImageProcessor)byteProcessor).getPixels();
        int n4 = rollingBall.shrinkfactor;
        int n5 = 0;
        int n6 = n / n4 - 1;
        int n7 = 0;
        int n8 = n2 / n4 - 1;
        int n9 = 1;
        int n10 = n6 - n5 - 1;
        int n11 = 1;
        int n12 = n8 - n7 - 1;
        int n13 = n3;
        int n14 = rollingBall.patchwidth;
        int n15 = n14 / 2;
        int n16 = n4 * n;
        int n17 = 0;
        int n18 = n11;
        while (n18 <= n12 + n14) {
            int n19 = n9;
            while (n19 <= n10 + n14) {
                int n20;
                int n21;
                int n22 = 255;
                int n23 = 0;
                int n24 = n18 - n14;
                int n25 = n24 * n13 + n19 - n14;
                while (n24 <= n18) {
                    n21 = n19 - n14;
                    while (n21 <= n19) {
                        int n26;
                        int n27;
                        if (n21 >= n9 && n21 <= n10 && n24 >= n11 && n24 <= n12 && (n27 = (byArray[n26 = n25] & 0xFF) - (n17 + (byArray2[n20 = n23] & 0xFF))) < n22) {
                            n22 = n27;
                        }
                        ++n23;
                        ++n21;
                        ++n25;
                    }
                    ++n24;
                    n25 = n25 - n14 - 1 + n13;
                }
                if (n22 != 0) {
                    n17 += n22;
                }
                int n28 = n22 < 0 ? n15 : 0;
                int n29 = n18 - n14;
                n24 = 0;
                n23 = 0;
                int n30 = (n29 - n11 + 1) * n16;
                while (n24 <= n14) {
                    int n31 = n19 - n14 + n28;
                    n21 = n28;
                    n23 += n28;
                    int n32 = n30 + (n31 - n9 + 1) * n4;
                    while (n21 <= n14) {
                        if (n31 >= n9 && n31 <= n10 && n29 >= n11 && n29 <= n12) {
                            n20 = n23;
                            int n33 = n17 + (byArray2[n20] & 0xFF);
                            if (n33 > (byArray3[n20 = n32] & 0xFF)) {
                                byArray3[n20] = (byte)n33;
                            }
                        }
                        ++n23;
                        ++n31;
                        ++n21;
                        n32 += n4;
                    }
                    ++n29;
                    ++n24;
                    n30 += n16;
                }
                ++n19;
            }
            if (n18 % 20 == 0) {
                IJ.showProgress(0.2 + 0.6 * (double)n18 / (double)(n12 + n14));
            }
            ++n18;
        }
        return byteProcessor;
    }

    ImageProcessor shrinkImage(ImageProcessor imageProcessor, int n) {
        int n2 = imageProcessor.getWidth();
        int n3 = imageProcessor.getHeight();
        int n4 = n2 / n;
        int n5 = n3 / n;
        ImageProcessor imageProcessor2 = imageProcessor.duplicate();
        imageProcessor2.smooth();
        IJ.showProgress(0.1);
        ByteProcessor byteProcessor = new ByteProcessor(n4, n5);
        byte[] byArray = (byte[])imageProcessor2.getPixels();
        byte[] byArray2 = (byte[])((ImageProcessor)byteProcessor).getPixels();
        int n6 = 0;
        while (n6 < n4 * n5) {
            int n7 = n * (n6 % n4);
            int n8 = n * (n6 / n4);
            int n9 = 255;
            int n10 = n2 - n;
            int n11 = n8 * n2 + n7;
            int n12 = 1;
            while (n12 <= n) {
                int n13 = 1;
                while (n13 <= n) {
                    int n14;
                    if ((n14 = byArray[n11++] & 0xFF) < n9) {
                        n9 = n14;
                    }
                    ++n13;
                }
                n11 += n10;
                ++n12;
            }
            byArray2[n6] = (byte)n9;
            ++n6;
        }
        return byteProcessor;
    }

    void interpolateBackground(ImageProcessor imageProcessor, RollingBall rollingBall) {
        int n = imageProcessor.getWidth();
        int n2 = imageProcessor.getHeight();
        int n3 = rollingBall.shrinkfactor;
        int n4 = 0;
        int n5 = n / n3 - 1;
        int n6 = 0;
        int n7 = n2 / n3 - 1;
        byte[] byArray = (byte[])imageProcessor.getPixels();
        int n8 = 0;
        int n9 = 1;
        while (n9 <= n7 - n6 - 1) {
            int n10 = 0;
            n8 += n3;
            int n11 = 1;
            while (n11 <= n5 - n4) {
                int n12;
                int n13 = n8 * n + (n10 += n3);
                int n14 = n13 - n3;
                int n15 = byArray[n13] & 0xFF;
                int n16 = byArray[n14] & 0xFF;
                int n17 = 1;
                while (n17 <= n3 - 1) {
                    n12 = n13 - n17;
                    byArray[n12] = (byte)(n16 + (n3 - n17) * (n15 - n16) / n3);
                    ++n17;
                }
                int n18 = 0;
                while (n18 <= n3 - 1) {
                    n14 = (n8 - n3) * n + n10 - n18;
                    n13 = n8 * n + n10 - n18;
                    n16 = byArray[n14] & 0xFF;
                    n15 = byArray[n13] & 0xFF;
                    int n19 = 0;
                    int n20 = 1;
                    while (n20 <= n3 - 1) {
                        n12 = n13 + (n19 -= n);
                        byArray[n12] = (byte)(n16 + (n3 - n20) * (n15 - n16) / n3);
                        ++n20;
                    }
                    ++n18;
                }
                ++n11;
            }
            ++n9;
        }
    }

    void extrapolateBackground(ImageProcessor imageProcessor, RollingBall rollingBall) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10 = imageProcessor.getWidth();
        int n11 = imageProcessor.getHeight();
        int n12 = rollingBall.shrinkfactor;
        int n13 = 0;
        int n14 = n10 / n12 - 1;
        int n15 = 0;
        int n16 = n11 / n12 - 1;
        byte[] byArray = (byte[])imageProcessor.getPixels();
        int n17 = n12;
        while (n17 <= n12 * (n14 - n13) - 1) {
            n9 = n12 * n10 + n17;
            n8 = (n12 + 1) * n10 + n17;
            n7 = byArray[n9] & 0xFF;
            n6 = byArray[n8] & 0xFF;
            n5 = n6 - n7;
            n4 = n9;
            n3 = n7;
            n2 = 1;
            while (n2 <= n12) {
                byArray[n4 -= n10] = (n3 -= n5) < 0 ? 0 : (n3 > 255 ? -1 : (byte)n3);
                ++n2;
            }
            n9 = (n12 * (n16 - n15 - 1) - 1) * n10 + n17;
            n8 = n12 * (n16 - n15 - 1) * n10 + n17;
            n7 = byArray[n9] & 0xFF;
            n6 = byArray[n8] & 0xFF;
            n5 = n6 - n7;
            n4 = n8;
            n3 = n6;
            n = 1;
            while (n <= n11 - 1 - n12 * (n16 - n15 - 1)) {
                byArray[n4 += n10] = (n3 += n5) < 0 ? 0 : (n3 > 255 ? -1 : (byte)n3);
                ++n;
            }
            ++n17;
        }
        n2 = 0;
        while (n2 < n11) {
            n9 = n2 * n10 + n12;
            n8 = n9 + 1;
            n7 = byArray[n9] & 0xFF;
            n6 = byArray[n8] & 0xFF;
            n5 = n6 - n7;
            n4 = n9;
            n3 = n7;
            n = 1;
            while (n <= n12) {
                byArray[--n4] = (n3 -= n5) < 0 ? 0 : (n3 > 255 ? -1 : (byte)n3);
                ++n;
            }
            n8 = n2 * n10 + n12 * (n14 - n13 - 1) - 1;
            n9 = n8 - 1;
            n7 = byArray[n9] & 0xFF;
            n6 = byArray[n8] & 0xFF;
            n5 = n6 - n7;
            n4 = n8;
            n3 = n6;
            int n18 = 1;
            while (n18 <= n10 - 1 - n12 * (n14 - n13 - 1) + 1) {
                byArray[++n4] = (n3 += n5) < 0 ? 0 : (n3 > 255 ? -1 : (byte)n3);
                ++n18;
            }
            ++n2;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

