/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.util.StringTokenizer;

public class Convolver
implements PlugInFilter {
    static final int BYTE = 0;
    static final int SHORT = 1;
    static final int FLOAT = 2;
    static final int RGB = 3;
    ImagePlus imp;
    int kw;
    int kh;
    int slice = 1;
    boolean canceled;
    float[] kernel;
    ImageWindow win;
    static String kernelText = ".0625  .125  .0625\n.125    .25    .125\n.0625  .125  .0625";
    static boolean normalize = true;
    static /* synthetic */ Class class$ij$plugin$filter$Convolver;

    public int setup(String string, ImagePlus imagePlus) {
        IJ.register(class$ij$plugin$filter$Convolver != null ? class$ij$plugin$filter$Convolver : (class$ij$plugin$filter$Convolver = Convolver.class$("ij.plugin.filter.Convolver")));
        this.imp = imagePlus;
        this.canceled = false;
        if (imagePlus == null) {
            IJ.noImage();
            return 4096;
        }
        this.kernel = this.getKernel();
        if (this.kernel == null) {
            return 4096;
        }
        if ((this.kw & 1) == 0) {
            IJ.showMessage("Convolver", "The kernel must be square and have an\nodd width. This kernel is " + this.kw + "x" + this.kh + ".");
            return 4096;
        }
        int n = IJ.setupDialog(imagePlus, 31);
        if ((n & 0x1000) != 0) {
            return 4096;
        }
        this.win = imagePlus.getWindow();
        this.win.running = true;
        IJ.showStatus("Convolve: " + this.kw + "x" + this.kh + " kernel");
        imagePlus.startTiming();
        return n;
    }

    public void run(ImageProcessor imageProcessor) {
        if (this.canceled) {
            return;
        }
        if (!this.win.running) {
            this.canceled = true;
            return;
        }
        this.convolve(imageProcessor, this.kernel, this.kw, this.kh);
        if (this.slice > 1) {
            IJ.showStatus("Convolve: " + this.slice + "/" + this.imp.getStackSize());
        }
        if (this.slice == this.imp.getStackSize()) {
            imageProcessor.resetMinAndMax();
        }
        ++this.slice;
    }

    float[] getKernel() {
        GenericDialog genericDialog = new GenericDialog("Convolver...", IJ.getInstance());
        genericDialog.addTextAreas(kernelText, null, 10, 30);
        genericDialog.addCheckbox("Normalize Kernel", normalize);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            this.canceled = true;
            return null;
        }
        kernelText = genericDialog.getNextText();
        normalize = genericDialog.getNextBoolean();
        StringTokenizer stringTokenizer = new StringTokenizer(kernelText);
        int n = stringTokenizer.countTokens();
        this.kh = this.kw = (int)Math.sqrt(n);
        n = this.kw * this.kh;
        float[] fArray = new float[n];
        int n2 = 0;
        while (n2 < n) {
            fArray[n2] = (float)this.getNum(stringTokenizer);
            ++n2;
        }
        return fArray;
    }

    double getNum(StringTokenizer stringTokenizer) {
        Double d;
        String string = stringTokenizer.nextToken();
        try {
            d = new Double(string);
        }
        catch (NumberFormatException numberFormatException) {
            d = null;
        }
        if (d != null) {
            return d;
        }
        return 0.0;
    }

    public void convolve(ImageProcessor imageProcessor, float[] fArray, int n, int n2) {
        int n3 = imageProcessor instanceof ByteProcessor ? 0 : (imageProcessor instanceof ShortProcessor ? 1 : (imageProcessor instanceof FloatProcessor ? 2 : 3));
        if (n3 == 3) {
            this.convolveRGB(imageProcessor, fArray, n, n2);
            return;
        }
        imageProcessor.setCalibrationTable(null);
        ImageProcessor imageProcessor2 = imageProcessor.convertToFloat();
        this.convolveFloat(imageProcessor2, fArray, n, n2);
        switch (n3) {
            case 0: {
                imageProcessor2 = imageProcessor2.convertToByte(false);
                byte[] byArray = (byte[])imageProcessor.getPixels();
                byte[] byArray2 = (byte[])imageProcessor2.getPixels();
                System.arraycopy(byArray2, 0, byArray, 0, byArray.length);
                break;
            }
            case 1: {
                imageProcessor2 = imageProcessor2.convertToShort(false);
                short[] sArray = (short[])imageProcessor.getPixels();
                short[] sArray2 = (short[])imageProcessor2.getPixels();
                System.arraycopy(sArray2, 0, sArray, 0, sArray.length);
                break;
            }
        }
    }

    public void convolveRGB(ImageProcessor imageProcessor, float[] fArray, int n, int n2) {
        int n3 = imageProcessor.getWidth();
        int n4 = imageProcessor.getHeight();
        int n5 = n3 * n4;
        if (this.slice == 1) {
            IJ.showStatus("Convolve (red)");
        }
        byte[] byArray = new byte[n5];
        byte[] byArray2 = new byte[n5];
        byte[] byArray3 = new byte[n5];
        ((ColorProcessor)imageProcessor).getRGB(byArray, byArray2, byArray3);
        ByteProcessor byteProcessor = new ByteProcessor(n3, n4, byArray, null);
        ByteProcessor byteProcessor2 = new ByteProcessor(n3, n4, byArray2, null);
        ByteProcessor byteProcessor3 = new ByteProcessor(n3, n4, byArray3, null);
        ImageProcessor imageProcessor2 = byteProcessor.convertToFloat();
        this.convolveFloat(imageProcessor2, fArray, n, n2);
        ImageProcessor imageProcessor3 = imageProcessor2.convertToByte(false);
        if (this.slice == 1) {
            IJ.showStatus("Convolve (green)");
        }
        imageProcessor2 = byteProcessor2.convertToFloat();
        this.convolveFloat(imageProcessor2, fArray, n, n2);
        ImageProcessor imageProcessor4 = imageProcessor2.convertToByte(false);
        imageProcessor2 = byteProcessor3.convertToFloat();
        if (this.slice == 1) {
            IJ.showStatus("Convolve (blue)");
        }
        this.convolveFloat(imageProcessor2, fArray, n, n2);
        ImageProcessor imageProcessor5 = imageProcessor2.convertToByte(false);
        ((ColorProcessor)imageProcessor).setRGB((byte[])imageProcessor3.getPixels(), (byte[])imageProcessor4.getPixels(), (byte[])imageProcessor5.getPixels());
    }

    public void convolveFloat(ImageProcessor imageProcessor, float[] fArray, int n, int n2) {
        int n3 = imageProcessor.getWidth();
        int n4 = imageProcessor.getHeight();
        int n5 = n / 2;
        int n6 = n2 / 2;
        float[] fArray2 = (float[])imageProcessor.getPixels();
        float[] fArray3 = (float[])imageProcessor.getPixelsCopy();
        int n7 = 0;
        while (n7 < n3 * n4) {
            fArray2[n7] = 0.0f;
            ++n7;
        }
        double d = 1.0;
        if (normalize) {
            double d2 = 0.0;
            int n8 = 0;
            while (n8 < fArray.length) {
                d2 += (double)fArray[n8];
                ++n8;
            }
            if (d2 != 0.0) {
                d = (float)(1.0 / d2);
            }
        }
        int n9 = Math.max(n4 / 25, 1);
        int n10 = n3 - n5;
        int n11 = n4 - n6;
        int n12 = 0;
        while (n12 < n4) {
            if (n12 % n9 == 0) {
                IJ.showProgress((double)n12 / (double)n4);
            }
            int n13 = 0;
            while (n13 < n3) {
                double d3 = 0.0;
                int n14 = 0;
                boolean bl = n12 < n6 || n12 >= n11 || n13 < n5 || n13 >= n10;
                int n15 = -n6;
                while (n15 <= n6) {
                    int n16 = n13 + (n12 + n15) * n3;
                    int n17 = -n5;
                    while (n17 <= n5) {
                        d3 = bl ? (d3 += (double)(this.getPixel(n13 + n17, n12 + n15, fArray3, n3, n4) * fArray[n14++])) : (d3 += (double)(fArray3[n16 + n17] * fArray[n14++]));
                        ++n17;
                    }
                    ++n15;
                }
                fArray2[n13 + n12 * n3] = (float)(d3 * d);
                ++n13;
            }
            ++n12;
        }
        IJ.showProgress(1.0);
    }

    private float getPixel(int n, int n2, float[] fArray, int n3, int n4) {
        if (n <= 0) {
            n = 0;
        }
        if (n >= n3) {
            n = n3 - 1;
        }
        if (n2 <= 0) {
            n2 = 0;
        }
        if (n2 >= n4) {
            n2 = n4 - 1;
        }
        return fArray[n + n2 * n3];
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

