/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.ImagePlus;
import ij.measure.Calibration;
import ij.plugin.filter.ImagePropertiesDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;

public class ImageProperties
implements PlugInFilter {
    ImagePlus imp;
    static final int NANOMETER = 0;
    static final int MICROMETER = 1;
    static final int MILLIMETER = 2;
    static final int CENTIMETER = 3;
    static final int METER = 4;
    static final int KILOMETER = 5;
    static final int INCH = 6;
    static final int FOOT = 7;
    static final int MILE = 8;
    static final int PIXEL = 9;
    static final int OTHER_UNIT = 10;
    int oldUnitIndex;
    double oldUnitsPerCm;
    double oldScale;

    public int setup(String string, ImagePlus imagePlus) {
        this.imp = imagePlus;
        return 159;
    }

    public void run(ImageProcessor imageProcessor) {
        this.showDialog(this.imp);
    }

    void showDialog(ImagePlus imagePlus) {
        Calibration calibration = imagePlus.getCalibration();
        this.oldUnitIndex = this.getUnitIndex(calibration.getUnit());
        this.oldUnitsPerCm = this.getUnitsPerCm(this.oldUnitIndex);
        ImagePropertiesDialog imagePropertiesDialog = new ImagePropertiesDialog(imagePlus.getTitle(), this);
        imagePropertiesDialog.addStringField("Unit of Measure:", calibration.getUnit());
        this.oldScale = calibration.pixelWidth != 0.0 ? 1.0 / calibration.pixelWidth : 0.0;
        imagePropertiesDialog.addNumericField("Pixels/Unit:", this.oldScale, (double)((int)this.oldScale) == this.oldScale ? 0 : 2);
        int n = imagePlus.getStackSize();
        if (n > 1) {
            imagePropertiesDialog.addMessage("");
            imagePropertiesDialog.addNumericField("Slice Spacing:", calibration.pixelDepth, 2);
            double d = calibration.frameInterval > 0.0 ? 1.0 / calibration.frameInterval : 0.0;
            imagePropertiesDialog.addNumericField("Frames per Second:", d, (double)((int)d) == d ? 0 : 2);
        }
        imagePropertiesDialog.showDialog();
        if (imagePropertiesDialog.wasCanceled()) {
            return;
        }
        String string = imagePropertiesDialog.getNextString();
        double d = imagePropertiesDialog.getNextNumber();
        if (string.equals("") || string.equalsIgnoreCase("pixel") || string.equalsIgnoreCase("none") || d == 0.0) {
            calibration.setUnit(null);
            calibration.pixelWidth = 1.0;
            calibration.pixelHeight = 1.0;
        } else {
            calibration.setUnit(string);
            calibration.pixelWidth = 1.0 / d;
            calibration.pixelHeight = 1.0 / d;
        }
        if (n > 1) {
            double d2 = imagePropertiesDialog.getNextNumber();
            double d3 = imagePropertiesDialog.getNextNumber();
            calibration.pixelDepth = d2;
            calibration.frameInterval = d3 != 0.0 ? 1.0 / d3 : 0.0;
        }
        imagePlus.repaintWindow();
    }

    double getNewScale(String string) {
        if (this.oldUnitsPerCm == 0.0) {
            return 0.0;
        }
        double d = 0.0;
        int n = this.getUnitIndex(string);
        if (n != this.oldUnitIndex) {
            double d2 = this.getUnitsPerCm(n);
            if (this.oldUnitsPerCm != 0.0 && d2 != 0.0) {
                d = this.oldScale * (this.oldUnitsPerCm / d2);
            }
        }
        return d;
    }

    int getUnitIndex(String string) {
        if ((string = string.toLowerCase()).equals("cm") || string.startsWith("cent")) {
            return 3;
        }
        if (string.equals("mm") || string.startsWith("milli")) {
            return 2;
        }
        if (string.startsWith("inch")) {
            return 6;
        }
        if (string.equals("um") || string.startsWith("micro")) {
            return 1;
        }
        if (string.equals("nm") || string.startsWith("nano")) {
            return 0;
        }
        if (string.startsWith("meter")) {
            return 4;
        }
        if (string.equals("km") || string.startsWith("kilo")) {
            return 5;
        }
        if (string.equals("ft") || string.equals("foot") || string.equals("feet")) {
            return 7;
        }
        if (string.equals("mi") || string.startsWith("mile")) {
            return 2;
        }
        return 10;
    }

    double getUnitsPerCm(int n) {
        switch (n) {
            case 0: {
                return 1.0E7;
            }
            case 1: {
                return 10000.0;
            }
            case 2: {
                return 10.0;
            }
            case 3: {
                return 1.0;
            }
            case 4: {
                return 0.01;
            }
            case 5: {
                return 1.0E-5;
            }
            case 6: {
                return 0.3937;
            }
            case 7: {
                return 0.0328083;
            }
            case 8: {
                return 6.213E-6;
            }
        }
        return 0.0;
    }
}

