/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Roi;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.text.TextWindow;
import java.awt.Font;
import java.awt.Graphics;

public class Waves
implements PlugInFilter {
    String arg;
    double amplitude = 5.0;
    double frequency = 25.0;
    int[] waveTable;
    ImagePlus imp;
    ImageWindow win;
    ImageCanvas ic;
    byte[] pixels;
    byte[] pixels2;
    int[] rgbPixels;
    int[] rgbPixels2;
    int width;
    int height;
    int index;
    int increment;
    long fps;
    long startTime;
    long elapsedTime;
    Graphics g;
    int frames;
    Roi roi;

    void showAbout() {
        IJ.showMessage("About Waves...", "\"Waves.java\" is a sample plugin filter that illustrates\nhow to continuously animate both 8-bit and RGB images until\nthe user clicks on the image or presses escape.");
    }

    void showRates() {
        TextWindow textWindow = new TextWindow("waves Benchmark", "", 450, 500);
        textWindow.setFont(new Font("Monospaced", 0, 12));
        textWindow.append("\"Waves\" frame rates using the 512x512 Mandrill image");
        textWindow.append("on a P2/400 running Windows 95 with 16-bit graphics.");
        textWindow.append("");
        textWindow.append("              JDK 1.1.7  JDK 1.2   JDK 1.3");
        textWindow.append("              ---------  -------   -----");
        textWindow.append("RGB              19.4     11.7      8.0");
        textWindow.append("RGB(1)           20.1      5.1");
        textWindow.append("RGB(2)           18.8      9.1");
        textWindow.append("RGB-D            14.4      2.9");
        textWindow.append("RGB-D(1)         15.4      2.9");
        textWindow.append("RGB-D(2)         14.6      2.8");
        textWindow.append("");
        textWindow.append("8-bit color      25.7      25.5    15.9");
        textWindow.append("8-bit color(1)   27.0       6.2");
        textWindow.append("8-bit color(2)   24.6      18.3");
        textWindow.append("");
        textWindow.append("8-bit grays      25.6      17.2    15.1");
        textWindow.append("8-bit grays(1)   26.3      8.4");
        textWindow.append("8-bit grays(2)   24.4      13.8");
        textWindow.append("");
        textWindow.append("(1) Image partially covered by ImageJ window");
        textWindow.append("(2) Image zoomed 2:1 and displayed in 512x512 window");
        textWindow.append("RGB-D = RGB image using the default direct color model");
    }

    public int setup(String string, ImagePlus imagePlus) {
        if (string.equals("about")) {
            this.showAbout();
            return 4096;
        }
        if (string.equals("show")) {
            this.showRates();
            return 4096;
        }
        this.imp = imagePlus;
        return 147;
    }

    public void run(ImageProcessor imageProcessor) {
        this.width = imageProcessor.getWidth();
        this.increment = 3;
        if (this.width % this.increment == 0) {
            this.increment = 5;
            if (this.width % this.increment == 0) {
                this.increment = 7;
                if (this.width % this.increment == 0) {
                    IJ.error("Width cannot be a multiple of 3, 5 or 7");
                    return;
                }
            }
        }
        this.height = imageProcessor.getHeight();
        if (imageProcessor.getPixels() instanceof byte[]) {
            this.pixels = (byte[])imageProcessor.getPixels();
            this.pixels2 = (byte[])imageProcessor.getPixelsCopy();
        } else {
            this.rgbPixels = (int[])imageProcessor.getPixels();
            this.rgbPixels2 = (int[])imageProcessor.getPixelsCopy();
        }
        this.waveTable = new int[this.width];
        int n = 0;
        while (n < this.width) {
            this.waveTable[n] = (int)((Math.sin((double)n / this.frequency) + 1.0) * this.amplitude);
            ++n;
        }
        this.win = this.imp.getWindow();
        this.ic = this.win.getCanvas();
        this.imp.killRoi();
        this.g = this.ic.getGraphics();
        Thread.currentThread().setPriority(1);
        this.startTime = System.currentTimeMillis();
        this.win.running = true;
        while (this.win.running) {
            if (this.pixels != null) {
                this.updateByteImage();
            } else {
                this.updateRGBImage();
            }
            this.imp.updateAndDraw();
            this.showFrameRate();
            Thread.yield();
        }
        imageProcessor.reset();
        this.imp.updateAndDraw();
    }

    void showFrameRate() {
        ++this.frames;
        this.elapsedTime = System.currentTimeMillis() - this.startTime;
        if (this.elapsedTime > 0L) {
            int n = this.ic.getSize().height;
            this.fps = (long)(this.frames * 10000) / this.elapsedTime;
            this.g.clearRect(0, n - 15, 50, 15);
            this.g.drawString(String.valueOf(this.fps / 10L) + "." + this.fps % 10L + " fps", 2, n - 2);
        }
    }

    void updateByteImage() {
        int n = this.index;
        int n2 = this.increment;
        int n3 = this.height;
        while (--n3 >= 0) {
            int n4 = n3 * this.width;
            int n5 = this.width;
            while (--n5 >= 0) {
                int n6;
                if ((n += n2) >= this.width) {
                    n = 0;
                }
                if ((n6 = n5 + this.waveTable[n]) >= this.width) {
                    n6 = this.width - 1;
                }
                this.pixels[n4 + n5] = this.pixels2[n4 + n6];
            }
        }
        this.index = n;
    }

    void updateRGBImage() {
        int n = this.index;
        int n2 = this.increment;
        int n3 = 0;
        while (n3 < this.height) {
            int n4 = n3 * this.width;
            int n5 = 0;
            while (n5 < this.width) {
                int n6;
                if ((n += n2) >= this.width) {
                    n = 0;
                }
                if ((n6 = n5 + this.waveTable[n]) >= this.width) {
                    n6 = this.width - 1;
                }
                this.rgbPixels[n4 + n5] = this.rgbPixels2[n4 + n6];
                ++n5;
            }
            ++n3;
        }
        this.index = n;
    }
}

