/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.io.SaveDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;

public class XYCoordinates
implements PlugInFilter {
    ImagePlus imp;

    public int setup(String string, ImagePlus imagePlus) {
        this.imp = imagePlus;
        return 31;
    }

    public void run(ImageProcessor imageProcessor) {
        Object object;
        int n = this.imp.getWidth();
        int n2 = this.imp.getHeight();
        float f = imageProcessor.getPixelValue(0, 0);
        this.imp.killRoi();
        boolean bl = IJ.showMessageWithCancel("XY_Coordinates", "This plugin writes to a text file the XY coordinates and\npixel value of all non-background pixels. Backround\nis assumed to be the value of the pixel in the\nupper left corner of the image.\n \n    Width: " + n + "\n" + "    Height: " + n2 + "\n" + "    Background value: " + f + "\n");
        if (!bl) {
            return;
        }
        SaveDialog saveDialog = new SaveDialog("Save Coordinates as Text...", this.imp.getTitle(), ".txt");
        String string = saveDialog.getFileName();
        if (string == null) {
            return;
        }
        String string2 = saveDialog.getDirectory();
        PrintWriter printWriter = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(String.valueOf(string2) + string);
            object = new BufferedOutputStream(fileOutputStream);
            printWriter = new PrintWriter((OutputStream)object);
        }
        catch (IOException iOException) {
            IJ.write(String.valueOf(String.valueOf(iOException)));
            return;
        }
        IJ.showStatus("Saving coordinates...");
        int n3 = 0;
        object = System.getProperty("line.separator");
        int n4 = this.imp.getType();
        int n5 = n2 - 1;
        while (n5 >= 0) {
            int n6 = 0;
            while (n6 < n) {
                float f2 = imageProcessor.getPixelValue(n6, n5);
                if (f2 != f) {
                    if (n4 == 2) {
                        printWriter.print(String.valueOf(n6) + " " + (n2 - 1 - n5) + " " + f2 + (String)object);
                    } else if (n4 == 4) {
                        int n7 = imageProcessor.getPixel(n6, n5);
                        int n8 = (n7 & 0xFF0000) >> 16;
                        int n9 = (n7 & 0xFF00) >> 8;
                        int n10 = n7 & 0xFF;
                        printWriter.print(String.valueOf(n6) + " " + (n2 - 1 - n5) + " " + n8 + " " + n9 + " " + n10 + (String)object);
                    } else {
                        printWriter.print(String.valueOf(n6) + " " + (n2 - 1 - n5) + " " + (int)f2 + (String)object);
                    }
                    ++n3;
                }
                ++n6;
            }
            if (n5 % 10 == 0) {
                IJ.showProgress((double)(n2 - n5) / (double)n2);
            }
            --n5;
        }
        IJ.showProgress(1.0);
        printWriter.close();
        IJ.write(String.valueOf(this.imp.getTitle()) + ": " + n3 + " pixels (" + IJ.d2s((double)n3 * 100.0 / (double)(n * n2)) + "%)\n");
    }
}

