/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.PlotWindow;
import ij.io.OpenDialog;
import ij.measure.CurveFitter;
import ij.plugin.PlugIn;
import ij.plugin.frame.PlugInFrame;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.util.Tools;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Font;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.StringTokenizer;

public class Fitter
extends PlugInFrame
implements PlugIn,
ItemListener,
ActionListener {
    Choice fit;
    Button doIt;
    Button open;
    Button apply;
    Checkbox settings;
    String fitTypeStr = CurveFitter.fitList[0];
    TextArea textArea;
    double[] dx;
    double[] dy;
    double[] x;
    double[] y;
    static CurveFitter cf;
    static int fitType;
    static /* synthetic */ Class class$ij$plugin$frame$Fitter;

    public Fitter() {
        super("Curve Fitter");
        double[] dArray = new double[6];
        dArray[1] = 1.0;
        dArray[2] = 2.0;
        dArray[3] = 3.0;
        dArray[4] = 4.0;
        dArray[5] = 5.0;
        this.dx = dArray;
        double[] dArray2 = new double[6];
        dArray2[1] = 0.9;
        dArray2[2] = 4.5;
        dArray2[3] = 8.0;
        dArray2[4] = 18.0;
        dArray2[5] = 24.0;
        this.dy = dArray2;
        WindowManager.addWindow(this);
        Panel panel = new Panel();
        this.fit = new Choice();
        int n = 0;
        while (n < CurveFitter.fitList.length) {
            this.fit.addItem(CurveFitter.fitList[n]);
            ++n;
        }
        this.fit.addItemListener(this);
        panel.add(this.fit);
        this.doIt = new Button(" Fit ");
        this.doIt.addActionListener(this);
        panel.add(this.doIt);
        this.open = new Button("Open");
        this.open.addActionListener(this);
        panel.add(this.open);
        this.apply = new Button("Apply");
        this.apply.addActionListener(this);
        panel.add(this.apply);
        this.settings = new Checkbox("Show settings", false);
        panel.add(this.settings);
        this.add("North", panel);
        String string = "";
        int n2 = 0;
        while (n2 < this.dx.length) {
            string = String.valueOf(string) + IJ.d2s(this.dx[n2], 2) + "  " + IJ.d2s(this.dy[n2], 2) + "\n";
            ++n2;
        }
        this.textArea = new TextArea("", 15, 30, 1);
        this.textArea.setFont(new Font("Monospaced", 0, 12));
        this.textArea.append(string);
        this.add("Center", this.textArea);
        this.pack();
        GUI.center(this);
        ((Component)this).setVisible(true);
        IJ.register(class$ij$plugin$frame$Fitter != null ? class$ij$plugin$frame$Fitter : (class$ij$plugin$frame$Fitter = Fitter.class$("ij.plugin.frame.Fitter")));
    }

    public void doFit(int n) {
        fitType = n;
        if (!this.getData()) {
            return;
        }
        double[] dArray = Tools.getMinMax(this.x);
        double d = dArray[0];
        double d2 = dArray[1];
        dArray = Tools.getMinMax(this.y);
        double d3 = dArray[0];
        double d4 = dArray[1];
        cf = new CurveFitter(this.x, this.y);
        cf.doFit(n, this.settings.getState());
        IJ.write(cf.getResultString());
        float[] fArray = new float[100];
        float[] fArray2 = new float[100];
        double d5 = (d2 - d) / 99.0;
        double d6 = d;
        int n2 = 0;
        while (n2 < 100) {
            fArray[n2] = (float)d6;
            d6 += d5;
            ++n2;
        }
        int n3 = 0;
        while (n3 < 100) {
            fArray2[n3] = (float)CurveFitter.f(n, cf.getParams(), fArray[n3]);
            ++n3;
        }
        dArray = Tools.getMinMax(fArray2);
        d3 = Math.min(d3, dArray[0]);
        d4 = Math.max(d4, dArray[1]);
        PlotWindow plotWindow = new PlotWindow(CurveFitter.fList[n], "X", "Y", fArray, fArray2);
        plotWindow.setLimits(d, d2, d3, d4);
        plotWindow.addPoints(this.x, this.y, 0);
        plotWindow.draw();
    }

    double sqr(double d) {
        return d * d;
    }

    boolean getData() {
        this.textArea.selectAll();
        String string = this.textArea.getText();
        this.textArea.select(0, 0);
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = stringTokenizer.countTokens();
        if (n < 4 || n % 2 != 0) {
            return false;
        }
        int n2 = n / 2;
        this.x = new double[n2];
        this.y = new double[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.x[n3] = this.getNum(stringTokenizer);
            this.y[n3] = this.getNum(stringTokenizer);
            ++n3;
        }
        return true;
    }

    void applyFunction() {
        if (cf == null) {
            IJ.error("No function available");
            return;
        }
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        if (imagePlus == null) {
            IJ.noImage();
            return;
        }
        if (imagePlus.getTitle().startsWith("y=")) {
            IJ.error("First select the image to be transformed");
            return;
        }
        double[] dArray = cf.getParams();
        int n = imagePlus.getWidth();
        int n2 = imagePlus.getHeight();
        int n3 = n * n2;
        float[] fArray = new float[n3];
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        int n4 = 0;
        while (n4 < n2) {
            int n5 = 0;
            while (n5 < n) {
                float f = imageProcessor.getPixelValue(n5, n4);
                fArray[n4 * n + n5] = (float)CurveFitter.f(fitType, dArray, f);
                ++n5;
            }
            ++n4;
        }
        FloatProcessor floatProcessor = new FloatProcessor(n, n2, fArray, imageProcessor.getColorModel());
        new ImagePlus(String.valueOf(imagePlus.getTitle()) + "-transformed", floatProcessor).show();
    }

    double getNum(StringTokenizer stringTokenizer) {
        Double d;
        String string = stringTokenizer.nextToken();
        try {
            d = new Double(string);
        }
        catch (NumberFormatException numberFormatException) {
            d = null;
        }
        if (d != null) {
            return d;
        }
        return 0.0;
    }

    void open() {
        OpenDialog openDialog = new OpenDialog("Open Text File...", "");
        String string = openDialog.getDirectory();
        String string2 = openDialog.getFileName();
        if (string2 == null) {
            return;
        }
        this.textArea.selectAll();
        this.textArea.setText("");
        try {
            String string3;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(String.valueOf(string) + string2));
            while ((string3 = bufferedReader.readLine()) != null && string3.length() <= 50) {
                this.textArea.append(String.valueOf(string3) + "\n");
            }
        }
        catch (Exception exception) {
            IJ.error(exception.getMessage());
            return;
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.fitTypeStr = this.fit.getSelectedItem();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.doIt) {
            this.doFit(this.fit.getSelectedIndex());
        } else if (actionEvent.getSource() == this.apply) {
            this.applyFunction();
        } else {
            this.open();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

