/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.twain;

import SK.gnome.twain.TwainEx;
import ij.IJ;
import ij.ImagePlus;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.plugin.twain.TwainConsumer;
import java.awt.image.ImageConsumer;

public class Twain
implements PlugIn {
    String unit;
    double xResolution;
    double yResolution;

    public void run(String string) {
        block6: {
            if (string.equals("select")) {
                this.selectSource();
                return;
            }
            if (string.equals("") && !this.selectSource()) {
                return;
            }
            try {
                this.check(TwainEx.register((int)1, (int)2, (String)"Gnome", (String)"Twain", (String)"JavaTwain32"), "register");
                this.check(TwainEx.openSource(), "openSource");
                TwainEx.setTransferCount((int)1);
                this.check(TwainEx.prepareTransfer(), "prepareTransfer");
                TwainConsumer twainConsumer = new TwainConsumer();
                this.check(TwainEx.acquireImage((ImageConsumer)twainConsumer), "acquireImage");
                this.check(TwainEx.stopTransfer(), "stopTransfer");
                this.getUnits();
                this.check(TwainEx.closeSource(), "closeSource");
                this.check(TwainEx.unregister(), "unregister");
                ImagePlus imagePlus = new ImagePlus("Scan", twainConsumer.getProcessor());
                if (this.xResolution != 0.0 && this.yResolution != 0.0) {
                    Calibration calibration = new Calibration(imagePlus);
                    calibration.pixelWidth = 1.0 / this.xResolution;
                    calibration.pixelHeight = 1.0 / this.yResolution;
                    calibration.setUnit(this.unit);
                    imagePlus.setCalibration(calibration);
                }
                imagePlus.show();
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                this.needsGnome(noClassDefFoundError);
            }
            catch (Exception exception) {
                TwainEx.unload();
                String string2 = exception.toString();
                if (string2.indexOf("acquireImage") >= 0) break block6;
                IJ.write(string2);
            }
        }
    }

    void check(boolean bl, String string) throws Exception {
        int n = TwainEx.getState();
        short s = TwainEx.getResultCode();
        short s2 = TwainEx.getConditionCode();
        String string2 = "";
        if (IJ.debugMode || !bl) {
            string2 = "state=" + n + ", result=" + s + ", condition=" + s2;
        }
        if (bl) {
            if (IJ.debugMode) {
                IJ.write("Twain: " + string + " (" + string2 + ")");
            }
        } else {
            throw new Exception("TWAIN \"" + string + "\" failed\n    " + string2);
        }
    }

    void getUnits() {
        short s = TwainEx.getCurrentUnits();
        this.unit = s == 0 ? "inch" : (s == 1 ? "cm" : "");
        this.xResolution = TwainEx.getXResolution();
        this.yResolution = TwainEx.getYResolution();
    }

    void needsGnome(Throwable throwable) {
        if (!IJ.isMacintosh()) {
            IJ.error("The Twain plugin requires the Java Twain Package from\nhttp://www.gnome.sk/. The files 'twain.jar' and 'JavaTwain32.dll'\nfrom this package must be placed in the ImageJ folder.\n \n" + throwable);
        }
    }

    public boolean selectSource() {
        try {
            this.check(TwainEx.register((int)1, (int)1, (String)"Gnome", (String)"Twain", (String)"Twain"), "register");
            this.check(TwainEx.selectSource(), "selectSource");
            this.check(TwainEx.unregister(), "unregister");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            this.needsGnome(noClassDefFoundError);
            return false;
        }
        catch (Exception exception) {
            TwainEx.unload();
            String string = exception.toString();
            if (string.indexOf("selectSource") < 0) {
                IJ.write(string);
            }
            return false;
        }
        return true;
    }
}

