/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.LookUpTable;
import ij.measure.Calibration;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.process.MedianCut;
import java.awt.Image;
import java.awt.image.ColorModel;

public class ImageConverter {
    private ImagePlus imp;
    private int type;
    private static boolean doScaling = true;

    public ImageConverter(ImagePlus imagePlus) {
        this.imp = imagePlus;
        this.type = imagePlus.getType();
    }

    public synchronized void convertToGray8() {
        if (this.imp.getStackSize() > 1) {
            throw new IllegalArgumentException("Unsupported conversion");
        }
        if (this.type == 1 || this.type == 2) {
            ImageProcessor imageProcessor = this.imp.getProcessor();
            this.imp.setProcessor(null, imageProcessor.convertToByte(doScaling));
            this.imp.getCalibration().disableDensityCalibration();
        } else {
            ImageProcessor imageProcessor = this.imp.getType() == 4 ? this.imp.getProcessor() : new ColorProcessor(this.imp.getImage());
            this.imp.setProcessor(null, imageProcessor.convertToByte(doScaling));
        }
    }

    public void convertToGray16() {
        if (this.type != 0 && this.type != 2) {
            throw new IllegalArgumentException("Unsupported conversion");
        }
        ImageProcessor imageProcessor = this.imp.getProcessor();
        this.imp.trimProcessor();
        this.imp.setProcessor(null, imageProcessor.convertToShort(doScaling));
        this.imp.getCalibration().disableDensityCalibration();
    }

    public void convertToGray32() {
        if (this.type != 0 && this.type != 1) {
            throw new IllegalArgumentException("Unsupported conversion");
        }
        ImageProcessor imageProcessor = this.imp.getProcessor();
        this.imp.trimProcessor();
        Calibration calibration = this.imp.getCalibration();
        imageProcessor.setCalibrationTable(calibration.getCTable());
        this.imp.setProcessor(null, imageProcessor.convertToFloat());
        calibration.disableDensityCalibration();
    }

    public void convertToRGB() {
        ImageProcessor imageProcessor = this.imp.getProcessor();
        this.imp.setProcessor(null, imageProcessor.convertToRGB());
        this.imp.getCalibration().disableDensityCalibration();
    }

    public void convertToRGBStack() {
        if (this.type != 4) {
            throw new IllegalArgumentException("Image must be RGB");
        }
        ColorProcessor colorProcessor = this.imp.getType() == 4 ? (ColorProcessor)this.imp.getProcessor() : new ColorProcessor(this.imp.getImage());
        int n = this.imp.getWidth();
        int n2 = this.imp.getHeight();
        byte[] byArray = new byte[n * n2];
        byte[] byArray2 = new byte[n * n2];
        byte[] byArray3 = new byte[n * n2];
        colorProcessor.getRGB(byArray, byArray2, byArray3);
        this.imp.trimProcessor();
        ColorModel colorModel = LookUpTable.createGrayscaleColorModel(false);
        ImageStack imageStack = new ImageStack(n, n2, colorModel);
        imageStack.addSlice("Red", byArray);
        imageStack.addSlice("Green", byArray2);
        imageStack.addSlice("Blue", byArray3);
        this.imp.setStack(null, imageStack);
    }

    public void convertToHSB() {
        if (this.type != 4) {
            throw new IllegalArgumentException("Image must be RGB");
        }
        ColorProcessor colorProcessor = this.imp.getType() == 4 ? (ColorProcessor)this.imp.getProcessor() : new ColorProcessor(this.imp.getImage());
        int n = this.imp.getWidth();
        int n2 = this.imp.getHeight();
        byte[] byArray = new byte[n * n2];
        byte[] byArray2 = new byte[n * n2];
        byte[] byArray3 = new byte[n * n2];
        colorProcessor.getHSB(byArray, byArray2, byArray3);
        this.imp.trimProcessor();
        ColorModel colorModel = LookUpTable.createGrayscaleColorModel(false);
        ImageStack imageStack = new ImageStack(n, n2, colorModel);
        imageStack.addSlice("Hue", byArray);
        imageStack.addSlice("Saturation", byArray2);
        imageStack.addSlice("Brightness", byArray3);
        this.imp.setStack(null, imageStack);
    }

    public void convertRGBStackToRGB() {
        int n = this.imp.getStackSize();
        if (n < 2 || n > 4 || this.type != 0) {
            throw new IllegalArgumentException("2 or 3 slice 8-bit stack required");
        }
        int n2 = this.imp.getWidth();
        int n3 = this.imp.getHeight();
        ImageStack imageStack = this.imp.getStack();
        byte[] byArray = (byte[])imageStack.getPixels(1);
        byte[] byArray2 = (byte[])imageStack.getPixels(2);
        byte[] byArray3 = n > 2 ? (byte[])imageStack.getPixels(3) : new byte[n2 * n3];
        this.imp.trimProcessor();
        ColorProcessor colorProcessor = new ColorProcessor(n2, n3);
        colorProcessor.setRGB(byArray, byArray2, byArray3);
        if (this.imp.isInvertedLut()) {
            colorProcessor.invert();
        }
        this.imp.setImage(colorProcessor.createImage());
        this.imp.killStack();
    }

    public void convertHSBToRGB() {
        if (this.imp.getStackSize() != 3) {
            throw new IllegalArgumentException("3-slice 8-bit stack required");
        }
        ImageStack imageStack = this.imp.getStack();
        byte[] byArray = (byte[])imageStack.getPixels(1);
        byte[] byArray2 = (byte[])imageStack.getPixels(2);
        byte[] byArray3 = (byte[])imageStack.getPixels(3);
        int n = this.imp.getWidth();
        int n2 = this.imp.getHeight();
        this.imp.trimProcessor();
        ColorProcessor colorProcessor = new ColorProcessor(n, n2);
        colorProcessor.setHSB(byArray, byArray2, byArray3);
        this.imp.setImage(colorProcessor.createImage());
        this.imp.killStack();
    }

    public void convertRGBtoIndexedColor(int n) {
        if (this.type != 4) {
            throw new IllegalArgumentException("Image must be RGB");
        }
        if (n < 2) {
            n = 2;
        }
        if (n > 256) {
            n = 256;
        }
        IJ.showProgress(0.1);
        IJ.showStatus("Grabbing pixels");
        int n2 = this.imp.getWidth();
        int n3 = this.imp.getHeight();
        ImageProcessor imageProcessor = this.imp.getProcessor();
        imageProcessor.snapshot();
        int[] nArray = (int[])imageProcessor.getPixels();
        this.imp.trimProcessor();
        System.currentTimeMillis();
        MedianCut medianCut = new MedianCut(nArray, n2, n3);
        Image image = medianCut.convert(n);
        this.imp.setImage(image);
        IJ.showProgress(1.0);
    }

    public static void setDoScaling(boolean bl) {
        doScaling = bl;
    }

    public static boolean getDoScaling() {
        return doScaling;
    }
}

