/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.gui.ProgressBar;
import ij.process.ColorProcessor;
import ij.process.TypeConverter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;

public abstract class ImageProcessor {
    public static final int BLACK = -16777216;
    public static final double NO_THRESHOLD = -808080.0;
    public static final int RED_LUT = 0;
    public static final int BLACK_AND_WHITE_LUT = 1;
    public static final int NO_LUT_UPDATE = 2;
    static final int INVERT = 0;
    static final int FILL = 1;
    static final int ADD = 2;
    static final int MULT = 3;
    static final int AND = 4;
    static final int OR = 5;
    static final int XOR = 6;
    static final int GAMMA = 7;
    static final int LOG = 8;
    static final int MINIMUM = 9;
    static final int MAXIMUM = 10;
    static final int SQR = 11;
    static final int SQRT = 12;
    static final int BLUR_MORE = 0;
    static final int FIND_EDGES = 1;
    static final int MEDIAN_FILTER = 2;
    static final int MIN = 3;
    static final int MAX = 4;
    static final double rWeight = 0.299;
    static final double gWeight = 0.587;
    static final double bWeight = 0.114;
    static final String WRONG_LENGTH = "(width*height) != pixels.length";
    int fgColor = 0;
    protected int lineWidth = 1;
    protected int cx;
    protected int cy;
    protected Font font;
    protected FontMetrics fontMetrics;
    static Frame frame;
    ProgressBar progressBar;
    boolean pixelsModified;
    protected int width;
    protected int snapshotWidth;
    protected int height;
    protected int snapshotHeight;
    protected int roiX;
    protected int roiY;
    protected int roiWidth;
    protected int roiHeight;
    protected int xMin;
    protected int xMax;
    protected int yMin;
    protected int yMax;
    boolean newSnapshot = false;
    int[] mask = null;
    protected ColorModel baseCM;
    protected ColorModel cm;
    protected byte[] rLUT1;
    protected byte[] gLUT1;
    protected byte[] bLUT1;
    protected byte[] rLUT2;
    protected byte[] gLUT2;
    protected byte[] bLUT2;
    protected boolean interpolate;
    protected double minThreshold = -808080.0;
    protected double maxThreshold = -808080.0;
    protected int histogramSize = 256;
    protected float[] cTable;
    protected boolean lutAnimation;
    protected MemoryImageSource source;
    protected Image img;
    protected boolean newPixels;
    protected boolean inversionTested = false;
    protected boolean invertedLut;

    protected void showProgress(double percentDone) {
        if (this.progressBar != null) {
            this.progressBar.show(percentDone);
        }
    }

    protected void hideProgress() {
        this.showProgress(1.0);
        this.newSnapshot = false;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public ColorModel getColorModel() {
        if (this.baseCM != null) {
            return this.baseCM;
        }
        return this.cm;
    }

    public void setColorModel(ColorModel cm) {
        if (!(this instanceof ColorProcessor) && !(cm instanceof IndexColorModel)) {
            throw new IllegalArgumentException("Must be IndexColorModel");
        }
        this.cm = cm;
        this.baseCM = null;
        this.rLUT2 = null;
        this.rLUT1 = null;
        this.newPixels = true;
        this.inversionTested = false;
        this.minThreshold = -808080.0;
    }

    protected void makeDefaultColorModel() {
        byte[] rLUT = new byte[256];
        byte[] gLUT = new byte[256];
        byte[] bLUT = new byte[256];
        int i = 0;
        while (i < 256) {
            rLUT[i] = (byte)i;
            gLUT[i] = (byte)i;
            bLUT[i] = (byte)i;
            ++i;
        }
        this.cm = new IndexColorModel(8, 256, rLUT, gLUT, bLUT);
    }

    public void invertLut() {
        if (this.cm == null) {
            this.makeDefaultColorModel();
        }
        IndexColorModel icm = (IndexColorModel)this.cm;
        int mapSize = icm.getMapSize();
        byte[] reds = new byte[mapSize];
        byte[] greens = new byte[mapSize];
        byte[] blues = new byte[mapSize];
        byte[] reds2 = new byte[mapSize];
        byte[] greens2 = new byte[mapSize];
        byte[] blues2 = new byte[mapSize];
        icm.getReds(reds);
        icm.getGreens(greens);
        icm.getBlues(blues);
        int i = 0;
        while (i < mapSize) {
            reds2[i] = (byte)(reds[mapSize - i - 1] & 0xFF);
            greens2[i] = (byte)(greens[mapSize - i - 1] & 0xFF);
            blues2[i] = (byte)(blues[mapSize - i - 1] & 0xFF);
            ++i;
        }
        this.cm = new IndexColorModel(8, mapSize, reds2, greens2, blues2);
        this.newPixels = true;
        this.baseCM = null;
        this.rLUT2 = null;
        this.rLUT1 = null;
        this.inversionTested = false;
    }

    public int getBestIndex(Color c) {
        if (this.cm == null) {
            this.makeDefaultColorModel();
        }
        IndexColorModel icm = (IndexColorModel)this.cm;
        int mapSize = icm.getMapSize();
        byte[] rLUT = new byte[mapSize];
        byte[] gLUT = new byte[mapSize];
        byte[] bLUT = new byte[mapSize];
        icm.getReds(rLUT);
        icm.getGreens(gLUT);
        icm.getBlues(bLUT);
        int minDistance = Integer.MAX_VALUE;
        int minIndex = 0;
        int r1 = c.getRed();
        int g1 = c.getGreen();
        int b1 = c.getBlue();
        int i = 0;
        while (i < mapSize) {
            int r2 = rLUT[i] & 0xFF;
            int g2 = gLUT[i] & 0xFF;
            int b2 = bLUT[i] & 0xFF;
            int distance = (r2 - r1) * (r2 - r1) + (g2 - g1) * (g2 - g1) + (b2 - b1) * (b2 - b1);
            if (distance < minDistance) {
                minDistance = distance;
                minIndex = i;
            }
            if ((double)minDistance == 0.0) break;
            ++i;
        }
        return minIndex;
    }

    public boolean isInvertedLut() {
        if (this.inversionTested) {
            return this.invertedLut;
        }
        this.inversionTested = true;
        if (this.cm == null || !(this.cm instanceof IndexColorModel)) {
            this.invertedLut = false;
            return false;
        }
        IndexColorModel icm = (IndexColorModel)this.cm;
        this.invertedLut = true;
        int i = 1;
        while (i < 255) {
            int v2;
            int v1 = icm.getRed(i - 1) + icm.getGreen(i - 1) + icm.getBlue(i - 1);
            if (v1 < (v2 = icm.getRed(i) + icm.getGreen(i) + icm.getBlue(i))) {
                this.invertedLut = false;
                break;
            }
            ++i;
        }
        return this.invertedLut;
    }

    public abstract void setColor(Color var1);

    public void setColor(int value) {
        this.fgColor = value;
    }

    public abstract void setValue(double var1);

    public abstract double getMin();

    public abstract double getMax();

    public abstract void setMinAndMax(double var1, double var3);

    public void resetMinAndMax() {
    }

    public void setThreshold(double minThreshold, double maxThreshold, int lutUpdate) {
        if (this instanceof ColorProcessor) {
            return;
        }
        this.minThreshold = minThreshold;
        this.maxThreshold = maxThreshold;
        if (minThreshold == -808080.0) {
            this.resetThreshold();
            return;
        }
        if (lutUpdate == 2) {
            return;
        }
        if (this.rLUT1 == null) {
            if (this.cm == null) {
                this.makeDefaultColorModel();
            }
            this.baseCM = this.cm;
            IndexColorModel m = (IndexColorModel)this.cm;
            this.rLUT1 = new byte[256];
            this.gLUT1 = new byte[256];
            this.bLUT1 = new byte[256];
            m.getReds(this.rLUT1);
            m.getGreens(this.gLUT1);
            m.getBlues(this.bLUT1);
            this.rLUT2 = new byte[256];
            this.gLUT2 = new byte[256];
            this.bLUT2 = new byte[256];
        }
        int t1 = (int)minThreshold;
        int t2 = (int)maxThreshold;
        if (lutUpdate == 0) {
            int i = 0;
            while (i < 256) {
                if (i >= t1 && i <= t2) {
                    this.rLUT2[i] = -1;
                    this.gLUT2[i] = 0;
                    this.bLUT2[i] = 0;
                } else {
                    this.rLUT2[i] = this.rLUT1[i];
                    this.gLUT2[i] = this.gLUT1[i];
                    this.bLUT2[i] = this.bLUT1[i];
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < 256) {
                if (i >= t1 && i <= t2) {
                    this.rLUT2[i] = 0;
                    this.gLUT2[i] = 0;
                    this.bLUT2[i] = 0;
                } else {
                    this.rLUT2[i] = -1;
                    this.gLUT2[i] = -1;
                    this.bLUT2[i] = -1;
                }
                ++i;
            }
        }
        this.cm = new IndexColorModel(8, 256, this.rLUT2, this.gLUT2, this.bLUT2);
        this.newPixels = true;
    }

    public void resetThreshold() {
        this.minThreshold = -808080.0;
        if (this.baseCM != null) {
            this.cm = this.baseCM;
            this.baseCM = null;
        }
        this.rLUT2 = null;
        this.rLUT1 = null;
        this.inversionTested = false;
        this.newPixels = true;
    }

    public double getMinThreshold() {
        return this.minThreshold;
    }

    public double getMaxThreshold() {
        return this.maxThreshold;
    }

    public void setRoi(Rectangle roi) {
        if (roi == null) {
            this.setRoi(0, 0, this.width, this.height);
        } else {
            this.setRoi(roi.x, roi.y, roi.width, roi.height);
        }
    }

    public void setRoi(int x, int y, int rwidth, int rheight) {
        int oldWidth = this.roiWidth;
        int oldHeight = this.roiHeight;
        this.roiX = Math.max(0, x);
        this.roiWidth = Math.min(this.width, x + rwidth) - this.roiX;
        this.roiY = Math.max(0, y);
        this.roiHeight = Math.min(this.height, y + rheight) - this.roiY;
        this.xMin = Math.max(this.roiX, 1);
        this.xMax = Math.min(this.roiX + this.roiWidth - 1, this.width - 2);
        this.yMin = Math.max(this.roiY, 1);
        this.yMax = Math.min(this.roiY + this.roiHeight - 1, this.height - 2);
        if (this.roiWidth != oldWidth || this.roiHeight != oldHeight) {
            this.mask = null;
        }
    }

    public Rectangle getRoi() {
        return new Rectangle(this.roiX, this.roiY, this.roiWidth, this.roiHeight);
    }

    public void setMask(int[] mask) {
        this.mask = mask;
    }

    public int[] getMask() {
        return this.mask;
    }

    public void setProgressBar(ProgressBar pb) {
        this.progressBar = pb;
    }

    public void setInterpolate(boolean interpolate) {
        this.interpolate = interpolate;
    }

    public boolean isKillable() {
        return false;
    }

    private void process(int op, double value) {
        double SCALE = 255.0 / Math.log(255.0);
        int[] lut = new int[256];
        int i = 0;
        while (i < 256) {
            int v;
            switch (op) {
                case 0: {
                    v = 255 - i;
                    break;
                }
                case 1: {
                    v = this.fgColor;
                    break;
                }
                case 2: {
                    v = i + (int)value;
                    break;
                }
                case 3: {
                    v = (int)Math.round((double)i * value);
                    break;
                }
                case 4: {
                    v = i & (int)value;
                    break;
                }
                case 5: {
                    v = i | (int)value;
                    break;
                }
                case 6: {
                    v = i ^ (int)value;
                    break;
                }
                case 7: {
                    v = (int)(Math.exp(Math.log((double)i / 255.0) * value) * 255.0);
                    break;
                }
                case 8: {
                    if (i == 0) {
                        v = 0;
                        break;
                    }
                    v = (int)(Math.log(i) * SCALE);
                    break;
                }
                case 11: {
                    v = i * i;
                    break;
                }
                case 12: {
                    v = (int)Math.sqrt(i);
                    break;
                }
                case 9: {
                    if ((double)i < value) {
                        v = (int)value;
                        break;
                    }
                    v = i;
                    break;
                }
                case 10: {
                    if ((double)i > value) {
                        v = (int)value;
                        break;
                    }
                    v = i;
                    break;
                }
                default: {
                    v = i;
                }
            }
            if (v < 0) {
                v = 0;
            }
            if (v > 255) {
                v = 255;
            }
            lut[i] = v;
            ++i;
        }
        this.applyTable(lut);
    }

    public double[] getLine(double x1, double y1, double x2, double y2) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        int n = (int)Math.round(Math.sqrt(dx * dx + dy * dy));
        double xinc = dx / (double)n;
        double yinc = dy / (double)n;
        double[] data = new double[++n];
        double rx = x1;
        double ry = y1;
        if (this.interpolate) {
            int i = 0;
            while (i < n) {
                data[i] = this.cTable != null ? this.getInterpolatedValue(rx, ry) : this.getInterpolatedPixel(rx, ry);
                rx += xinc;
                ry += yinc;
                ++i;
            }
        } else {
            int i = 0;
            while (i < n) {
                data[i] = this.getPixelValue((int)(rx + 0.5), (int)(ry + 0.5));
                rx += xinc;
                ry += yinc;
                ++i;
            }
        }
        return data;
    }

    public void getRow(int x, int y, int[] data, int length) {
        int i = 0;
        while (i < length) {
            data[i] = this.getPixel(x++, y);
            ++i;
        }
    }

    public void getColumn(int x, int y, int[] data, int length) {
        int i = 0;
        while (i < length) {
            data[i] = this.getPixel(x, y++);
            ++i;
        }
    }

    public void putRow(int x, int y, int[] data, int length) {
        int i = 0;
        while (i < length) {
            this.putPixel(x++, y, data[i]);
            ++i;
        }
    }

    public void putColumn(int x, int y, int[] data, int length) {
        int i = 0;
        while (i < length) {
            this.putPixel(x, y++, data[i]);
            ++i;
        }
    }

    public void moveTo(int x, int y) {
        this.cx = x;
        this.cy = y;
    }

    public void setLineWidth(int width) {
        this.lineWidth = width;
        if (this.lineWidth < 1) {
            this.lineWidth = 1;
        }
    }

    public void lineTo(int x2, int y2) {
        int dx = x2 - this.cx;
        int dy = y2 - this.cy;
        int absdx = dx >= 0 ? dx : -dx;
        int absdy = dy >= 0 ? dy : -dy;
        int n = absdy > absdx ? absdy : absdx;
        double xinc = (double)dx / (double)n;
        double yinc = (double)dy / (double)n;
        double x = (double)this.cx + 0.5;
        double y = (double)this.cy + 0.5;
        ++n;
        do {
            if (this.lineWidth == 1) {
                this.drawPixel((int)x, (int)y);
            } else if (this.lineWidth == 2) {
                this.drawDot2((int)x, (int)y);
            } else {
                this.drawDot((int)x, (int)y);
            }
            x += xinc;
            y += yinc;
        } while (--n > 0);
        this.cx = x2;
        this.cy = y2;
    }

    public void drawDot2(int x, int y) {
        this.drawPixel(x, y);
        this.drawPixel(x - 1, y);
        this.drawPixel(x, y - 1);
        this.drawPixel(x - 1, y - 1);
    }

    public void drawDot(int xcenter, int ycenter) {
        int r = this.lineWidth / 2;
        int r2 = r * r + 1;
        int x = -r;
        while (x <= r) {
            int y = -r;
            while (y <= r) {
                if (x * x + y * y <= r2) {
                    this.drawPixel(xcenter + x, ycenter + y);
                }
                ++y;
            }
            ++x;
        }
    }

    public void drawString(String s) {
        if (frame == null) {
            frame = new Frame();
            frame.pack();
            ((Component)frame).setBackground(Color.white);
        }
        if (this.font == null) {
            this.font = new Font("SansSerif", 0, 9);
        }
        if (this.fontMetrics == null) {
            this.fontMetrics = frame.getFontMetrics(this.font);
        }
        int w = this.fontMetrics.stringWidth(s);
        int h = this.fontMetrics.getHeight();
        Image img = frame.createImage(w, h);
        Graphics g = img.getGraphics();
        g.setColor(Color.black);
        FontMetrics metrics = g.getFontMetrics(this.font);
        int fontHeight = metrics.getHeight();
        int descent = metrics.getDescent();
        g.setFont(this.font);
        g.drawString(s, 0, h - descent);
        g.dispose();
        ColorProcessor ip = new ColorProcessor(img);
        this.setRoi(this.cx, this.cy - h, w, h);
        this.fill((int[])((ImageProcessor)ip).getPixels());
        this.setRoi(null);
        this.cy += h;
    }

    public void setFont(Font font) {
        this.font = font;
        this.fontMetrics = null;
    }

    public int getStringWidth(String s) {
        if (this.font == null) {
            this.font = new Font("SansSerif", 0, 9);
        }
        if (this.fontMetrics == null) {
            if (frame == null) {
                frame = new Frame();
                frame.pack();
            }
            this.fontMetrics = frame.getFontMetrics(this.font);
        }
        return this.fontMetrics.stringWidth(s);
    }

    public void smooth() {
        this.filter(0);
    }

    public void sharpen() {
        int[] kernel = new int[]{-1, -1, -1, -1, 12, -1, -1, -1, -1};
        this.convolve3x3(kernel);
    }

    public void findEdges() {
        this.filter(1);
    }

    public abstract void flipVertical();

    public void flipHorizontal() {
        int[] col1 = new int[this.roiHeight];
        int[] col2 = new int[this.roiHeight];
        int x = 0;
        while (x < this.roiWidth / 2) {
            this.getColumn(this.roiX + x, this.roiY, col1, this.roiHeight);
            this.getColumn(this.roiX + this.roiWidth - x - 1, this.roiY, col2, this.roiHeight);
            this.putColumn(this.roiX + x, this.roiY, col2, this.roiHeight);
            this.putColumn(this.roiX + this.roiWidth - x - 1, this.roiY, col1, this.roiHeight);
            ++x;
        }
        this.newSnapshot = false;
    }

    public ImageProcessor rotateRight() {
        int width2 = this.height;
        int height2 = this.width;
        ImageProcessor ip2 = this.createProcessor(width2, height2);
        int[] arow = new int[this.width];
        int row = 0;
        while (row < this.height) {
            this.getRow(0, row, arow, this.width);
            ip2.putColumn(width2 - row - 1, 0, arow, height2);
            ++row;
        }
        return ip2;
    }

    public ImageProcessor rotateLeft() {
        int width2 = this.height;
        int height2 = this.width;
        ImageProcessor ip2 = this.createProcessor(width2, height2);
        int[] arow = new int[this.width];
        int[] arow2 = new int[this.width];
        int row = 0;
        while (row < this.height) {
            this.getRow(0, row, arow, this.width);
            int i = 0;
            while (i < this.width) {
                arow2[i] = arow[this.width - i - 1];
                ++i;
            }
            ip2.putColumn(row, 0, arow2, height2);
            ++row;
        }
        return ip2;
    }

    public void insert(ImageProcessor ip, int xloc, int yloc) {
        this.copyBits(ip, xloc, yloc, 0);
    }

    public String toString() {
        return "width=" + this.width + ", height=" + this.height + ", min=" + this.getMin() + ", max=" + this.getMax() + ", v=" + this.getPixel(0, 0);
    }

    public void fill() {
        this.process(1, 0.0);
    }

    public abstract void fill(int[] var1);

    public void setCalibrationTable(float[] cTable) {
        this.cTable = cTable;
    }

    public void setHistogramSize(int size) {
        this.histogramSize = size;
    }

    public int getHistogramSize() {
        return this.histogramSize;
    }

    public abstract Object getPixels();

    public abstract Object getPixelsCopy();

    public abstract int getPixel(int var1, int var2);

    public abstract int getUncheckedPixel(int var1, int var2);

    public abstract double getInterpolatedPixel(double var1, double var3);

    public double getInterpolatedValue(double x, double y) {
        return this.getInterpolatedPixel(x, y);
    }

    public abstract void putPixel(int var1, int var2, int var3);

    public abstract void putUncheckedPixel(int var1, int var2, int var3);

    public abstract float getPixelValue(int var1, int var2);

    public abstract void putPixelValue(int var1, int var2, double var3);

    public abstract void drawPixel(int var1, int var2);

    public abstract void setPixels(Object var1);

    public abstract void copyBits(ImageProcessor var1, int var2, int var3, int var4);

    public abstract void applyTable(int[] var1);

    public void invert() {
        this.process(0, 0.0);
    }

    public void add(int value) {
        this.process(2, value);
    }

    public void add(double value) {
        this.process(2, value);
    }

    public void multiply(double value) {
        this.process(3, value);
    }

    public void and(int value) {
        this.process(4, value);
    }

    public void or(int value) {
        this.process(5, value);
    }

    public void xor(int value) {
        this.process(6, value);
    }

    public void gamma(double value) {
        this.process(7, value);
    }

    public void log() {
        this.process(8, 0.0);
    }

    public void sqr() {
        this.process(11, 0.0);
    }

    public void sqrt() {
        this.process(12, 0.0);
    }

    public void min(double value) {
        this.process(9, value);
    }

    public void max(double value) {
        this.process(10, value);
    }

    public abstract Image createImage();

    public abstract ImageProcessor createProcessor(int var1, int var2);

    public abstract void snapshot();

    public abstract void reset();

    public abstract void reset(int[] var1);

    public abstract void convolve3x3(int[] var1);

    public abstract void filter(int var1);

    public abstract void medianFilter();

    public abstract void noise(double var1);

    public abstract ImageProcessor crop();

    public ImageProcessor duplicate() {
        Rectangle saveRoi = this.getRoi();
        this.setRoi(null);
        ImageProcessor ip2 = this.crop();
        this.setRoi(saveRoi);
        return ip2;
    }

    public abstract void scale(double var1, double var3);

    public abstract ImageProcessor resize(int var1, int var2);

    public abstract void rotate(double var1);

    public abstract void autoThreshold();

    public abstract int[] getHistogram();

    public abstract void erode();

    public abstract void dilate();

    public void setLutAnimation(boolean lutAnimation) {
        this.lutAnimation = lutAnimation;
        this.newPixels = true;
    }

    void resetPixels(Object pixels) {
        if (pixels == null) {
            if (this.img != null) {
                this.img.flush();
                this.img = null;
            }
            this.source = null;
        }
        this.newPixels = true;
    }

    public ImageProcessor convertToByte(boolean doScaling) {
        TypeConverter tc = new TypeConverter(this, doScaling);
        return tc.convertToByte();
    }

    public ImageProcessor convertToShort(boolean doScaling) {
        TypeConverter tc = new TypeConverter(this, doScaling);
        return tc.convertToShort();
    }

    public ImageProcessor convertToFloat() {
        TypeConverter tc = new TypeConverter(this, false);
        return tc.convertToFloat(this.cTable);
    }

    public ImageProcessor convertToRGB() {
        TypeConverter tc = new TypeConverter(this, true);
        return tc.convertToRGB();
    }
}

