/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.measure.Calibration;
import ij.measure.Measurements;
import ij.process.ByteProcessor;
import ij.process.ByteStatistics;
import ij.process.ColorProcessor;
import ij.process.ColorStatistics;
import ij.process.EllipseFitter;
import ij.process.FloatStatistics;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import ij.process.ShortStatistics;
import java.awt.Rectangle;

public class ImageStatistics
implements Measurements {
    public int[] histogram;
    public int pixelCount;
    public int mode;
    public double dmode;
    public double area;
    public double min;
    public double max;
    public double mean;
    public double stdDev;
    public double xCentroid;
    public double yCentroid;
    public double xCenterOfMass;
    public double yCenterOfMass;
    public double roiX;
    public double roiY;
    public double roiWidth;
    public double roiHeight;
    public double umean;
    public double major;
    public double minor;
    public double angle;
    public double histMin;
    public double histMax;
    public int maxCount;
    public int nBins = 256;
    public double binSize = 1.0;
    protected int width;
    protected int height;
    protected int rx;
    protected int ry;
    protected int rw;
    protected int rh;
    protected double pw;
    protected double ph;
    EllipseFitter ef;

    public static ImageStatistics getStatistics(ImageProcessor ip, int mOptions, Calibration cal) {
        if (ip instanceof ByteProcessor) {
            return new ByteStatistics(ip, mOptions, cal);
        }
        if (ip instanceof ShortProcessor) {
            return new ShortStatistics(ip, mOptions, cal);
        }
        if (ip instanceof ColorProcessor) {
            return new ColorStatistics(ip, mOptions, cal);
        }
        return new FloatStatistics(ip, mOptions, cal);
    }

    void getRawMinAndMax(int minThreshold, int maxThreshold) {
        int min = minThreshold;
        while (this.histogram[min] == 0 && min < 255) {
            ++min;
        }
        this.min = min;
        int max = maxThreshold;
        while (this.histogram[max] == 0 && max > 0) {
            --max;
        }
        this.max = max;
    }

    void getRawStatistics(int minThreshold, int maxThreshold) {
        double sum = 0.0;
        double sum2 = 0.0;
        int i = minThreshold;
        while (i <= maxThreshold) {
            int count = this.histogram[i];
            this.pixelCount += count;
            sum += (double)(i * count);
            double value = i;
            sum2 += value * value * (double)count;
            if (count > this.maxCount) {
                this.maxCount = count;
                this.mode = i;
            }
            ++i;
        }
        this.area = (double)this.pixelCount * this.pw * this.ph;
        this.umean = this.mean = sum / (double)this.pixelCount;
        this.dmode = this.mode;
        this.calculateStdDev(this.pixelCount, sum, sum2);
        this.histMin = 0.0;
        this.histMax = 255.0;
    }

    void calculateStdDev(int n, double sum, double sum2) {
        if (n > 0) {
            this.stdDev = ((double)n * sum2 - sum * sum) / (double)n;
            this.stdDev = this.stdDev > 0.0 ? Math.sqrt(this.stdDev / ((double)n - 1.0)) : 0.0;
        } else {
            this.stdDev = 0.0;
        }
    }

    void setup(ImageProcessor ip, Calibration cal) {
        this.width = ip.getWidth();
        this.height = ip.getHeight();
        Rectangle roi = ip.getRoi();
        if (roi != null) {
            this.rx = roi.x;
            this.ry = roi.y;
            this.rw = roi.width;
            this.rh = roi.height;
        } else {
            this.rx = 0;
            this.ry = 0;
            this.rw = this.width;
            this.rh = this.height;
        }
        if (cal != null) {
            this.pw = cal.pixelWidth;
            this.ph = cal.pixelHeight;
        } else {
            this.pw = 1.0;
            this.ph = 1.0;
        }
        this.roiX = (double)this.rx * this.pw;
        this.roiY = (double)this.ry * this.ph;
        this.roiWidth = (double)this.rw * this.pw;
        this.roiHeight = (double)this.rh * this.ph;
    }

    void getCentroid(ImageProcessor ip) {
        int[] mask = ip.getMask();
        int count = 0;
        int xsum = 0;
        int ysum = 0;
        int y = this.ry;
        int my = 0;
        while (y < this.ry + this.rh) {
            int mi = my * this.rw;
            int x = this.rx;
            while (x < this.rx + this.rw) {
                if (mask == null || mask[mi++] == -16777216) {
                    ++count;
                    xsum += x;
                    ysum += y;
                }
                ++x;
            }
            ++y;
            ++my;
        }
        this.xCentroid = ((double)xsum / (double)count + 0.5) * this.pw;
        this.yCentroid = ((double)ysum / (double)count + 0.5) * this.pw;
    }

    void fitEllipse(ImageProcessor ip) {
        if (this.ef == null) {
            this.ef = new EllipseFitter();
        }
        this.ef.fit(ip, this);
        double psize = this.pw == this.ph ? this.pw : 0.0;
        this.major = this.ef.major * psize;
        this.minor = this.ef.minor * psize;
        this.angle = this.ef.angle;
        this.xCentroid = this.ef.xCenter * this.pw;
        this.yCentroid = this.ef.yCenter * this.ph;
    }

    public void drawEllipse(ImageProcessor ip) {
        if (this.ef != null) {
            this.ef.drawEllipse(ip);
        }
    }
}

