/*
 * Decompiled with CFR 0.152.
 */
package dicomviewer;

import dicomviewer.DicomData;
import dicomviewer.DicomDic;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.StringTokenizer;

public class DicomFile {
    int debug_level = 3;
    boolean isLtlEndian;
    boolean vrType;
    boolean patientPrivacy;
    boolean VReqSQ = false;
    boolean containDic;
    DicomDic dicomDic;
    DicomData dicomData;

    public DicomFile(boolean bl, boolean bl2, boolean bl3, DicomDic dicomDic) {
        this.patientPrivacy = bl3;
        this.isLtlEndian = bl;
        this.vrType = bl2;
        this.dicomDic = dicomDic;
    }

    public DicomFile(boolean bl, boolean bl2, DicomDic dicomDic) {
        this(bl, bl2, false, dicomDic);
    }

    public DicomFile(DicomDic dicomDic) {
        this(true, false, false, dicomDic);
    }

    public DicomData load(String string) {
        Object object;
        Object object2;
        this.dicomData = new DicomData();
        try {
            object2 = new URL(string);
            object = new BufferedInputStream(((URL)object2).openStream());
            DataInputStream dataInputStream = new DataInputStream((InputStream)object);
            byte[] byArray = new byte[2];
            byte[] byArray2 = new byte[4];
            while (dataInputStream.read(byArray) != -1) {
                int n;
                int n2 = this.readInt2(byArray);
                String string2 = Integer.toString((n2 & 0xF000) >> 12, 16);
                string2 = String.valueOf(string2).concat(String.valueOf(Integer.toString((n2 & 0xF00) >> 8, 16)));
                string2 = String.valueOf(string2).concat(String.valueOf(Integer.toString((n2 & 0xF0) >> 4, 16)));
                string2 = String.valueOf(string2).concat(String.valueOf(Integer.toString(n2 & 0xF, 16)));
                dataInputStream.readFully(byArray);
                n2 = this.readInt2(byArray);
                String string3 = Integer.toString((n2 & 0xF000) >> 12, 16);
                string3 = String.valueOf(string3).concat(String.valueOf(Integer.toString((n2 & 0xF00) >> 8, 16)));
                string3 = String.valueOf(string3).concat(String.valueOf(Integer.toString((n2 & 0xF0) >> 4, 16)));
                string3 = String.valueOf(string3).concat(String.valueOf(Integer.toString(n2 & 0xF, 16)));
                String string4 = String.valueOf(String.valueOf(String.valueOf(String.valueOf("(").concat(String.valueOf(string2))).concat(String.valueOf(","))).concat(String.valueOf(string3))).concat(String.valueOf(")"));
                if (this.debug_level > 3) {
                    System.out.println(String.valueOf("currentTag is : ").concat(String.valueOf(string4)));
                }
                this.dicomData.setTag(string4);
                this.containDic = this.dicomDic.isContain(string4);
                if (this.vrType && !this.VReqSQ) {
                    StringBuffer stringBuffer = new StringBuffer(2);
                    dataInputStream.readFully(byArray);
                    int n3 = 0;
                    while (n3 < 2) {
                        stringBuffer.append((char)byArray[n3]);
                        ++n3;
                    }
                    this.dicomData.setVR(string4, stringBuffer.toString());
                    if (stringBuffer.toString().equals("OB") || stringBuffer.toString().equals("OW") || stringBuffer.toString().equals("SQ")) {
                        dataInputStream.skip(2L);
                        dataInputStream.readFully(byArray2);
                        n = this.readInt4(byArray2);
                    } else {
                        dataInputStream.readFully(byArray);
                        n = this.readInt2(byArray);
                    }
                } else {
                    if (this.containDic) {
                        this.dicomData.setVR(string4, this.dicomDic.getVR(string4));
                    } else {
                        this.dicomData.setVR(string4, "na");
                    }
                    dataInputStream.readFully(byArray2);
                    n = this.readInt4(byArray2);
                }
                if (string4.equals("(fffe,e0dd)")) {
                    this.VReqSQ = false;
                }
                String string5 = this.dicomData.getVR(string4);
                if (this.debug_level > 3) {
                    System.out.println(String.valueOf("currentVR is : ").concat(String.valueOf(string5)));
                }
                if (this.debug_level > 3) {
                    System.out.println(String.valueOf("currentLength: ").concat(String.valueOf(n)));
                }
                if (n == -1) {
                    this.VReqSQ = true;
                    n = 0;
                }
                byte[] byArray3 = new byte[n];
                dataInputStream.readFully(byArray3);
                this.dicomData.setValue(string4, byArray3);
                if (this.containDic) {
                    this.dicomData.setName(string4, this.dicomDic.getName(string4));
                    this.dicomData.setVM(string4, this.dicomDic.getVM(string4));
                    this.dicomData.setVersion(string4, this.dicomDic.getVersion(string4));
                } else {
                    this.dicomData.setName(string4, "NotContainedInDICOMDictionary");
                    this.dicomData.setVM(string4, "na");
                    this.dicomData.setVersion(string4, "na");
                }
                if (this.debug_level > 3) {
                    System.out.println(String.valueOf("currentName is : ").concat(String.valueOf(this.dicomData.getName(string4))));
                }
                this.analyzer(string4, string5);
            }
            dataInputStream.close();
            ((BufferedInputStream)object).close();
        }
        catch (EOFException eOFException) {
            System.out.println(String.valueOf("DicomFile.EOFException: ").concat(String.valueOf(eOFException.getMessage())));
        }
        catch (IOException iOException) {
            System.out.println(String.valueOf("DicomFile.IOException: ").concat(String.valueOf(iOException.getMessage())));
        }
        catch (Exception exception) {
            System.out.println(String.valueOf("DicomFile.Exception: ").concat(String.valueOf(exception.getMessage())));
        }
        if (this.patientPrivacy) {
            object2 = this.dicomData.getAnalyzedValue("(0010,0010)");
            object = new StringBuffer((String)object2);
            int n = 0;
            while (n < ((String)object2).length()) {
                if (n % 2 == 1) {
                    ((StringBuffer)object).setCharAt(n, '*');
                }
                ++n;
            }
            this.dicomData.setAnalyzedValue("(0010,0010)", ((StringBuffer)object).toString());
        }
        return this.dicomData;
    }

    private int readInt2(byte[] byArray) {
        int n = this.isLtlEndian ? (0xFF & byArray[1]) << 8 | 0xFF & byArray[0] : (0xFF & byArray[0]) << 8 | 0xFF & byArray[1];
        return n;
    }

    private int readInt4(byte[] byArray) {
        int n = this.isLtlEndian ? (0xFF & byArray[3]) << 24 | (0xFF & byArray[2]) << 16 | (0xFF & byArray[1]) << 8 | 0xFF & byArray[0] : (0xFF & byArray[0]) << 24 | (0xFF & byArray[1]) << 16 | (0xFF & byArray[2]) << 8 | 0xFF & byArray[3];
        return n;
    }

    private void analyzer(String string, String string2) {
        if (string2 == null) {
            this.dicomData.setAnalyzedValue(string, "Not contain VR.");
        } else if (this.dicomData.getValueLength(string) == 0) {
            this.dicomData.setAnalyzedValue(string, "");
        } else if (string2.equals("PN") | string2.equals("LO") | string2.equals("SH") | string2.equals("LT") | string2.equals("ST") | string2.equals("UI") | string2.equals("DS") | string2.equals("CS") | string2.equals("IS") | string2.equals("AS")) {
            int n = 0;
            while (n < this.dicomData.getValueLength(string)) {
                if (this.dicomData.getValue(string)[n] == 0) {
                    this.dicomData.getValue((String)string)[n] = 20;
                }
                ++n;
            }
            this.dicomData.setAnalyzedValue(string, new String(this.dicomData.getValue(string)));
        } else if (string2.equals("SS")) {
            int n = this.isLtlEndian ? (this.dicomData.getValue(string)[1] & 0xFF) << 8 | this.dicomData.getValue(string)[0] & 0xFF : (this.dicomData.getValue(string)[0] & 0xFF) << 8 | this.dicomData.getValue(string)[1] & 0xFF;
            if ((n & 0x8000) == 32768) {
                n |= 0xFFFF0000;
            }
            this.dicomData.setAnalyzedValue(string, Integer.toString(n));
        } else if (string2.equals("US")) {
            int n = this.isLtlEndian ? (this.dicomData.getValue(string)[1] & 0xFF) << 8 | this.dicomData.getValue(string)[0] & 0xFF : (this.dicomData.getValue(string)[0] & 0xFF) << 8 | this.dicomData.getValue(string)[1] & 0xFF;
            this.dicomData.setAnalyzedValue(string, Integer.toString(n));
        } else if (string2.equals("UL")) {
            int n = this.isLtlEndian ? (this.dicomData.getValue(string)[3] & 0xFF) << 24 | (this.dicomData.getValue(string)[2] & 0xFF) << 16 | (this.dicomData.getValue(string)[1] & 0xFF) << 8 | this.dicomData.getValue(string)[0] & 0xFF : (this.dicomData.getValue(string)[0] & 0xFF) << 24 | (this.dicomData.getValue(string)[1] & 0xFF) << 16 | (this.dicomData.getValue(string)[2] & 0xFF) << 8 | this.dicomData.getValue(string)[3] & 0xFF;
            this.dicomData.setAnalyzedValue(string, Integer.toString(n));
        } else if (string2.equals("TM")) {
            this.dicomData.setAnalyzedValue(string, new String(this.dicomData.getValue(string)));
            StringBuffer stringBuffer = new StringBuffer(this.dicomData.getAnalyzedValue(string));
            stringBuffer.insert(2, ":");
            stringBuffer.insert(5, ":");
            this.dicomData.setAnalyzedValue(string, stringBuffer.toString());
        } else if (string2.equals("DA")) {
            this.dicomData.setAnalyzedValue(string, new String(this.dicomData.getValue(string)));
            if (this.dicomData.getValueLength(string) == 8) {
                StringBuffer stringBuffer = new StringBuffer(this.dicomData.getAnalyzedValue(string));
                stringBuffer.insert(4, "-");
                stringBuffer.insert(7, "-");
                this.dicomData.setAnalyzedValue(string, stringBuffer.toString());
            } else if (this.dicomData.getValueLength(string) == 10) {
                StringTokenizer stringTokenizer = new StringTokenizer(this.dicomData.getAnalyzedValue(string), ".");
                String string3 = stringTokenizer.nextToken();
                string3 = String.valueOf(string3).concat(String.valueOf(String.valueOf("-").concat(String.valueOf(stringTokenizer.nextToken()))));
                string3 = String.valueOf(string3).concat(String.valueOf(String.valueOf("-").concat(String.valueOf(stringTokenizer.nextToken()))));
                this.dicomData.setAnalyzedValue(string, string3);
            }
        } else {
            this.dicomData.setAnalyzedValue(string, "Unknown VR");
        }
        if (this.debug_level > 3) {
            System.out.println(String.valueOf("AnalyzedValue :").concat(String.valueOf(this.dicomData.getAnalyzedValue(string))));
        }
    }
}

