/*
 * Decompiled with CFR 0.152.
 */
package dicomviewer;

import dicomviewer.DicomData;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;

public class ImageData {
    int debug_level = 3;
    boolean blackANDwhite = true;
    boolean rgbMode = false;
    boolean inv = false;
    int[] pixel;
    int[] orgPixel;
    int pixLength;
    int pixelMin;
    int pixelMax;
    int width;
    int height;
    int[] histogram = new int[256];
    int histMax;
    int ww;
    int wl;
    int[] defaultPixel;
    int defaultWidth;
    int defaultHeight;
    int defaultWW;
    int defaultWL;
    Image image;
    Toolkit toolkit;
    MemoryImageSource source;

    public void setData(DicomData dicomData) {
        int n;
        if (this.debug_level > 3) {
            System.out.println("Now set width and height....");
        }
        this.width = Integer.parseInt(dicomData.getAnalyzedValue("(0028,0011)"));
        this.height = Integer.parseInt(dicomData.getAnalyzedValue("(0028,0010)"));
        this.defaultWidth = this.width;
        this.defaultHeight = this.height;
        if (this.debug_level > 3) {
            System.out.println(String.valueOf("Image width  : ").concat(String.valueOf(this.width)));
        }
        if (this.debug_level > 3) {
            System.out.println(String.valueOf("Image heigth : ").concat(String.valueOf(this.height)));
        }
        if (this.debug_level > 3) {
            System.out.print("Now set byte[] to int[]....");
        }
        this.orgPixel = new int[this.width * this.height];
        this.pixLength = this.orgPixel.length;
        this.pixel = new int[this.pixLength];
        this.defaultPixel = new int[this.pixLength];
        byte[] byArray = new byte[dicomData.getValue("(7fe0,0010)").length];
        System.arraycopy(dicomData.getValue("(7fe0,0010)"), 0, byArray, 0, byArray.length);
        if (this.debug_level > 3) {
            System.out.println(" OK!");
        }
        if (dicomData.isContain("(0028,0004)") && dicomData.getAnalyzedValue("(0028,0004)").trim().equals("RGB")) {
            this.rgbMode = true;
            n = 0;
            while (n < this.pixLength) {
                this.orgPixel[n] = 0xFF000000 | (0xFF & byArray[3 * n]) << 16 | (0xFF & byArray[3 * n + 1]) << 8 | 0xFF & byArray[3 * n + 2];
                ++n;
            }
        } else {
            int n2;
            if (dicomData.getAnalyzedValue("(0028,0100)").trim().equals("16")) {
                n = 0;
                n2 = 0;
                while (n2 < this.pixLength) {
                    this.orgPixel[n2] = n = (int)((short)((0xFF & byArray[2 * n2 + 1]) << 8 | 0xFF & byArray[2 * n2]));
                    ++n2;
                }
            } else {
                n = 0;
                while (n < this.pixLength) {
                    this.orgPixel[n] = 0xFF & byArray[n];
                    ++n;
                }
            }
            n = Integer.parseInt(dicomData.getAnalyzedValue("(0028,0101)"));
            n2 = Integer.parseInt(dicomData.getAnalyzedValue("(0028,0102)"));
            int n3 = n2 - n + 1;
            if (n3 > 0) {
                int n4 = 0;
                while (n4 < this.pixLength) {
                    this.orgPixel[n4] = this.orgPixel[n4] >> n3;
                    ++n4;
                }
            }
        }
        System.arraycopy(this.orgPixel, 0, this.defaultPixel, 0, this.pixLength);
        byArray = null;
        if (this.debug_level > 3) {
            System.out.print("Now set pixelMin and pixelMax....");
        }
        this.pixelMin = 0;
        this.pixelMax = 0;
        n = 0;
        while (n < this.pixLength) {
            if (this.pixelMin > this.orgPixel[n]) {
                this.pixelMin = this.orgPixel[n];
            }
            if (this.pixelMax < this.orgPixel[n]) {
                this.pixelMax = this.orgPixel[n];
            }
            ++n;
        }
        if (this.debug_level > 3) {
            System.out.println(" OK!");
        }
        if (this.debug_level > 3) {
            System.out.print("Now set WW/WL....");
        }
        if (dicomData.isContain("(0028,1051)")) {
            try {
                this.ww = Integer.parseInt(dicomData.getAnalyzedValue("(0028,1051)").replace('+', ' ').trim());
            }
            catch (NumberFormatException numberFormatException) {
                this.ww = this.pixelMax - this.pixelMin;
            }
        } else {
            this.ww = this.pixelMax - this.pixelMin;
        }
        if (dicomData.isContain("(0028,1050)")) {
            try {
                this.wl = Integer.parseInt(dicomData.getAnalyzedValue("(0028,1050)").replace('+', ' ').trim());
            }
            catch (NumberFormatException numberFormatException) {
                this.wl = (this.ww >> 1) + this.pixelMin;
            }
        } else {
            this.wl = (this.ww >> 1) + this.pixelMin;
        }
        this.defaultWW = this.ww;
        this.defaultWL = this.wl;
        if (this.debug_level > 3) {
            System.out.println(" OK!");
        }
        if (this.debug_level > 3) {
            System.out.println(String.valueOf(String.valueOf(String.valueOf("WW :").concat(String.valueOf(this.ww))).concat(String.valueOf(" WL :"))).concat(String.valueOf(this.wl)));
        }
        int n5 = 0;
        while (n5 < this.pixel.length) {
            this.pixel[n5] = -16777216;
            ++n5;
        }
        this.source = new MemoryImageSource(this.width, this.height, this.pixel, 0, this.width);
        this.source.setAnimated(true);
        this.toolkit = Toolkit.getDefaultToolkit();
        this.image = this.toolkit.createImage(this.source);
    }

    private void contrast() {
        if (!this.rgbMode) {
            int n = this.ww >> 1;
            int n2 = this.wl - n;
            int n3 = this.wl + n;
            if (this.blackANDwhite) {
                double d = 255.0 / (double)this.ww;
                int n4 = 0;
                while (n4 < this.pixLength) {
                    int n5 = this.orgPixel[n4];
                    n5 = n5 <= n2 ? 0 : (n5 >= n3 ? 255 : (int)((double)(n5 - n2) * d));
                    this.pixel[n4] = 0xFF000000 | n5 << 16 | n5 << 8 | n5;
                    if (this.inv) {
                        this.pixel[n4] = ~this.pixel[n4] & 0xFFFFFF | this.pixel[n4] & 0xFF000000;
                    }
                    ++n4;
                }
            } else {
                float f = 0.67f / (float)this.ww;
                int n6 = this.ww + n2;
                int n7 = 0;
                while (n7 < this.pixLength) {
                    int n8 = this.orgPixel[n7];
                    float f2 = n8 <= n2 ? 0.67f : (n8 >= n3 ? 0.0f : (float)(n6 - n8) * f);
                    this.pixel[n7] = this.hue2RGB(f2);
                    if (this.inv) {
                        this.pixel[n7] = ~this.pixel[n7] & 0xFFFFFF | this.pixel[n7] & 0xFF000000;
                    }
                    ++n7;
                }
            }
        } else {
            System.arraycopy(this.orgPixel, 0, this.pixel, 0, this.pixel.length);
        }
    }

    private int hue2RGB(float f) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        float f2 = (f - (float)Math.floor(f)) * 6.0f;
        float f3 = f2 - (float)Math.floor(f2);
        float f4 = 1.0f - f3;
        switch ((int)f2) {
            case 0: {
                n = 255;
                n2 = (int)(f3 * 255.0f + 0.5f);
                n3 = 0;
                break;
            }
            case 1: {
                n = (int)(f4 * 255.0f + 0.5f);
                n2 = 255;
                n3 = 0;
                break;
            }
            case 2: {
                n = 0;
                n2 = 255;
                n3 = (int)(f3 * 255.0f + 0.5f);
                break;
            }
            case 3: {
                n = 0;
                n2 = (int)(f4 * 255.0f + 0.5f);
                n3 = 255;
                break;
            }
            case 4: {
                n = (int)(f3 * 255.0f + 0.5f);
                n2 = 0;
                n3 = 255;
                break;
            }
            case 5: {
                n = 255;
                n2 = 0;
                n3 = (int)(f4 * 255.0f + 0.5f);
            }
        }
        return 0xFF000000 | n << 16 | n2 << 8 | n3 << 0;
    }

    private Image getImage() {
        this.source.newPixels();
        return this.image;
    }

    public Image getDefaultImage() {
        this.contrast();
        return this.getImage();
    }

    public boolean color() {
        return this.rgbMode;
    }

    public Image wwANDwl(int n, int n2) {
        this.ww = n;
        this.wl = n2;
        this.contrast();
        return this.getImage();
    }

    public void setWwWl(int n, int n2) {
        this.ww = n;
        this.wl = n2;
    }

    public Image getImageWWWL2Current(int n, int n2) {
        this.ww = this.defaultWW + n;
        this.wl = this.defaultWL + n2;
        this.contrast();
        return this.getImage();
    }

    public int getWW() {
        return this.ww;
    }

    public int getWL() {
        return this.wl;
    }

    public int getDefaultWW() {
        return this.defaultWW;
    }

    public int getDefaultWL() {
        return this.defaultWL;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getPixelMin() {
        return this.pixelMin;
    }

    public int getPixelMax() {
        return this.pixelMax;
    }

    public void inverse() {
        this.inv = !this.inv;
    }

    public void setInverse(boolean bl) {
        this.inv = bl;
    }

    public void setColor(boolean bl) {
        this.blackANDwhite = !bl;
    }

    public void changeColor() {
        this.blackANDwhite = !this.blackANDwhite;
    }

    public void setDefaultPixel() {
        System.arraycopy(this.defaultPixel, 0, this.orgPixel, 0, this.pixLength);
        this.width = this.defaultWidth;
        this.height = this.defaultHeight;
        this.blackANDwhite = true;
        this.inv = false;
    }

    public void rotateL() {
        int[] nArray = new int[this.orgPixel.length];
        System.arraycopy(this.orgPixel, 0, nArray, 0, nArray.length);
        int n = 0;
        while (n < this.height) {
            int n2 = 0;
            while (n2 < this.width) {
                this.orgPixel[(this.width - n2 - 1) * this.height + n] = nArray[n * this.width + n2];
                ++n2;
            }
            ++n;
        }
        int n3 = this.width;
        this.width = this.height;
        this.height = n3;
    }

    public void rotateR() {
        int[] nArray = new int[this.orgPixel.length];
        System.arraycopy(this.orgPixel, 0, nArray, 0, nArray.length);
        int n = 0;
        while (n < this.height) {
            int n2 = 0;
            while (n2 < this.width) {
                this.orgPixel[n2 * this.height + (this.height - n - 1)] = nArray[n * this.width + n2];
                ++n2;
            }
            ++n;
        }
        int n3 = this.width;
        this.width = this.height;
        this.height = n3;
    }

    public void flipLR() {
        int[] nArray = new int[this.orgPixel.length];
        System.arraycopy(this.orgPixel, 0, nArray, 0, nArray.length);
        int n = 0;
        while (n < this.height) {
            int n2 = n * this.width;
            int n3 = n2 + this.width - 1;
            int n4 = 0;
            while (n4 < this.width) {
                this.orgPixel[n3 - n4] = nArray[n2 + n4];
                ++n4;
            }
            ++n;
        }
    }

    public void flipUD() {
        int[] nArray = new int[this.orgPixel.length];
        System.arraycopy(this.orgPixel, 0, nArray, 0, nArray.length);
        int n = 0;
        while (n < this.height) {
            int n2 = (this.height - n - 1) * this.width;
            int n3 = n * this.width;
            int n4 = 0;
            while (n4 < this.width) {
                this.orgPixel[n2 + n4] = nArray[n3 + n4];
                ++n4;
            }
            ++n;
        }
    }

    private void makeHistogram() {
        int n = 0;
        while (n < 256) {
            this.histogram[n] = 0;
            ++n;
        }
        this.histMax = 0;
        n = 0;
        while (n < this.pixel.length) {
            int n2;
            int n3 = n2 = 0xFF & this.pixel[n];
            this.histogram[n3] = this.histogram[n3] + 1;
            ++n;
        }
        n = 0;
        while (n < 256) {
            if (this.histMax < this.histogram[n]) {
                this.histMax = this.histogram[n];
            }
            ++n;
        }
    }

    public int[] getHistogram() {
        return this.histogram;
    }

    public int getHistMax() {
        return this.histMax;
    }

    public Image reviseHistogram() {
        this.calcRevisedHistogram();
        return this.getImage();
    }

    private void calcRevisedHistogram() {
        double[] dArray = new double[256];
        int n = 0;
        int[] nArray = new int[256];
        this.makeHistogram();
        int n2 = 0;
        while (n2 < this.pixel.length) {
            this.pixel[n2] = 0xFF & this.pixel[n2];
            ++n2;
        }
        double d = 1.0 / (double)(this.height * this.width);
        n2 = 0;
        while (n2 < 256) {
            dArray[n2] = (double)(n += this.histogram[n2]) * d;
            ++n2;
        }
        double d2 = dArray[0];
        double d3 = 255.0 / (1.0 - d2);
        n2 = 0;
        while (n2 < 256) {
            nArray[n2] = (int)((dArray[n2] - d2) * d3);
            ++n2;
        }
        n2 = 0;
        while (n2 < this.pixel.length) {
            this.pixel[n2] = 0xFF000000 | nArray[this.pixel[n2]] << 16 | nArray[this.pixel[n2]] << 8 | nArray[this.pixel[n2]];
            ++n2;
        }
    }
}

