/*
 * Decompiled with CFR 0.152.
 */
package dicomviewer;

import java.applet.AppletContext;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;

public class MyLabel
extends Canvas {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    private String label;
    private int alignment;
    private static final int hgap = 5;
    private static final int vgap = 3;
    AppletContext appletContext;
    Color color = Color.black;

    public MyLabel() {
        this("", 0);
    }

    public MyLabel(String string) {
        this(string, 0);
    }

    public MyLabel(String string, int n) {
        this.label = string;
        this.alignment = n;
        this.addMouseListener(new MyMouseListener());
    }

    public void setText(String string) {
        this.label = string;
        this.repaint();
    }

    public String getText() {
        return this.label;
    }

    public void setAlignment(int n) {
        this.alignment = n;
        this.repaint();
    }

    public int getAlignment() {
        return this.alignment;
    }

    public Dimension preferredSize() {
        Font font = this.getFont();
        int n = this.getFont().getSize();
        int n2 = this.getFontMetrics(this.getFont()).stringWidth(this.label);
        return new Dimension(n2 + 10, n + 6);
    }

    public Dimension minimumSize() {
        Font font = this.getFont();
        int n = this.getFont().getSize();
        int n2 = this.getFontMetrics(this.getFont()).stringWidth(this.label);
        return new Dimension(n2, n);
    }

    public void paint(Graphics graphics) {
        int n;
        Dimension dimension = this.size();
        Font font = graphics.getFont();
        int n2 = graphics.getFontMetrics().stringWidth(this.label);
        int n3 = font.getSize();
        switch (this.alignment) {
            default: {
                n = dimension.width - n2 > 5 ? 5 : 0;
                break;
            }
            case 1: {
                n = (dimension.width - n2) / 2;
                break;
            }
            case 2: {
                n = dimension.width - n2 - (dimension.width - n2 > 5 ? 5 : 0);
            }
        }
        int n4 = (dimension.height + n3) / 2 - graphics.getFontMetrics(font).getMaxDescent();
        graphics.setColor(this.color);
        graphics.drawString(this.label, n, n4);
    }

    public void setAppletContext(AppletContext appletContext) {
        this.appletContext = appletContext;
    }

    class MyMouseListener
    extends MouseAdapter {
        MyMouseListener() {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            MyLabel.this.setCursor(new Cursor(12));
            MyLabel.this.color = Color.blue;
            MyLabel.this.repaint();
        }

        public void mouseExited(MouseEvent mouseEvent) {
            MyLabel.this.setCursor(new Cursor(0));
            MyLabel.this.color = Color.black;
            MyLabel.this.repaint();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            try {
                URL uRL = new URL("http://mars.elcom.nitech.ac.jp/dicom/index-e.html");
                MyLabel.this.appletContext.showDocument(uRL, "_blank");
            }
            catch (Exception exception) {
                System.out.println(String.valueOf("Exception: ").concat(String.valueOf(exception.getMessage())));
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }
}

