/*
 * Decompiled with CFR 0.152.
 */
package dicomviewer;

import dicomviewer.DicomData;
import dicomviewer.hGrid;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Vector;

public class TagInfoFrame
extends Frame {
    DicomData[] dicomData;
    Vector vector8;
    Vector vector10;
    Vector vector18;
    Vector vector20;
    Vector vector28;
    Vector vectorOther;
    List tag_list = new List(5, false);
    hGrid table = new hGrid();
    Panel panel1 = new Panel();
    Label label1 = new Label();
    Choice imgNo_choice = new Choice();

    public TagInfoFrame() {
        super("DICOM Tag Browser");
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setTagInfoFrame(int n) {
        this.dicomData = new DicomData[n];
        int n2 = 0;
        while (n2 < n) {
            this.imgNo_choice.add("0");
            ++n2;
        }
    }

    public void setDicomData(DicomData dicomData, int n, int n2) {
        this.dicomData[n] = dicomData;
        this.imgNo_choice.remove(n);
        this.imgNo_choice.insert(Integer.toString(n2 + 1), n);
    }

    private void jbInit() throws Exception {
        String[] stringArray = new String[]{"Tag", "VR", "Name", "Value"};
        this.table.setHead(stringArray);
        this.tag_list.add("0008 - Identifying");
        this.tag_list.add("0010 - Patient");
        this.tag_list.add("0018 - Acquisition");
        this.tag_list.add("0020 - Relationship");
        this.tag_list.add("0028 - ImagePresentation");
        this.tag_list.add("otherz");
        this.tag_list.select(0);
        this.label1.setText("ImageNo");
        this.add((Component)this.table, "Center");
        this.add((Component)this.panel1, "North");
        this.panel1.add((Component)this.label1, null);
        this.panel1.add((Component)this.imgNo_choice, null);
        this.panel1.add((Component)this.tag_list, null);
        this.tag_list.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                switch (TagInfoFrame.this.tag_list.getSelectedIndex()) {
                    case 0: {
                        TagInfoFrame.this.showTagInfo(TagInfoFrame.this.vector8);
                        break;
                    }
                    case 1: {
                        TagInfoFrame.this.showTagInfo(TagInfoFrame.this.vector10);
                        break;
                    }
                    case 2: {
                        TagInfoFrame.this.showTagInfo(TagInfoFrame.this.vector18);
                        break;
                    }
                    case 3: {
                        TagInfoFrame.this.showTagInfo(TagInfoFrame.this.vector20);
                        break;
                    }
                    case 4: {
                        TagInfoFrame.this.showTagInfo(TagInfoFrame.this.vector28);
                        break;
                    }
                    case 5: {
                        TagInfoFrame.this.showTagInfo(TagInfoFrame.this.vectorOther);
                        break;
                    }
                    default: {
                        TagInfoFrame.this.showTagInfo(TagInfoFrame.this.vector8);
                    }
                }
            }
        });
        this.imgNo_choice.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                TagInfoFrame.this.setVector();
                switch (TagInfoFrame.this.tag_list.getSelectedIndex()) {
                    case 0: {
                        TagInfoFrame.this.showTagInfo(TagInfoFrame.this.vector8);
                        break;
                    }
                    case 1: {
                        TagInfoFrame.this.showTagInfo(TagInfoFrame.this.vector10);
                        break;
                    }
                    case 2: {
                        TagInfoFrame.this.showTagInfo(TagInfoFrame.this.vector18);
                        break;
                    }
                    case 3: {
                        TagInfoFrame.this.showTagInfo(TagInfoFrame.this.vector20);
                        break;
                    }
                    case 4: {
                        TagInfoFrame.this.showTagInfo(TagInfoFrame.this.vector28);
                        break;
                    }
                    case 5: {
                        TagInfoFrame.this.showTagInfo(TagInfoFrame.this.vectorOther);
                        break;
                    }
                    default: {
                        TagInfoFrame.this.showTagInfo(TagInfoFrame.this.vector8);
                    }
                }
            }
        });
    }

    public void setImageNo(int n) {
        this.imgNo_choice.select(Integer.toString(n + 1));
        this.setVector();
        this.tag_list.select(0);
        this.showTagInfo(this.vector8);
    }

    private void setVector() {
        int n = this.imgNo_choice.getSelectedIndex();
        this.vector8 = new Vector();
        this.vector10 = new Vector();
        this.vector18 = new Vector();
        this.vector20 = new Vector();
        this.vector28 = new Vector();
        this.vectorOther = new Vector();
        Enumeration enumeration = this.dicomData[n].keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            String[] stringArray = new String[4];
            stringArray[0] = string;
            stringArray[1] = this.dicomData[n].getVR(string);
            StringBuffer stringBuffer = new StringBuffer(this.dicomData[n].getName(string));
            stringBuffer.setLength(30);
            stringArray[2] = stringBuffer.toString().replace('\u0000', ' ');
            stringArray[3] = this.dicomData[n].getAnalyzedValue(string);
            if (string.substring(1, 5).equals("0008")) {
                this.vector8.addElement(stringArray);
                continue;
            }
            if (string.substring(1, 5).equals("0010")) {
                this.vector10.addElement(stringArray);
                continue;
            }
            if (string.substring(1, 5).equals("0018")) {
                this.vector18.addElement(stringArray);
                continue;
            }
            if (string.substring(1, 5).equals("0020")) {
                this.vector20.addElement(stringArray);
                continue;
            }
            if (string.substring(1, 5).equals("0028")) {
                this.vector28.addElement(stringArray);
                continue;
            }
            this.vectorOther.addElement(stringArray);
        }
    }

    private void showTagInfo(Vector vector) {
        this.table.removeRows();
        int n = 0;
        while (n < vector.size()) {
            this.table.addRow((String[])vector.elementAt(n));
            ++n;
        }
        this.table.sort(0);
    }
}

