/*
 * Decompiled with CFR 0.152.
 */
package dicomviewer;

import dicomviewer.AnimationThread;
import dicomviewer.BorderPanel;
import dicomviewer.DicomData;
import dicomviewer.DicomDic;
import dicomviewer.DicomFile;
import dicomviewer.ImageData;
import dicomviewer.ImageTiledCanvas;
import dicomviewer.InfoPanel;
import dicomviewer.LoaderThread;
import dicomviewer.MyLabel;
import dicomviewer.TagInfoFrame;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class Viewer
extends Applet {
    int debug_level = 3;
    boolean isLtlEndian;
    boolean vrType;
    boolean privacy;
    int NUM;
    String dicURL;
    String[] imgURL;
    DicomFile dicomFile;
    DicomData dicomData;
    ImageData imageData;
    DicomData[] dicomData_tmp;
    ImageData[] imageData_tmp;
    int[] index;
    int TMPSIZE;
    int[] arrayIndex;
    int start;
    int start_old;
    int[] ww;
    int[] wl;
    double zoom = 1.0;
    int canvasSize = 100;
    boolean inv_flag = false;
    boolean rotateL_flag = false;
    boolean rotateR_flag = false;
    boolean flipLR_flag = false;
    boolean flipUD_flag = false;
    boolean reset_flag = false;
    int imageNo;
    boolean synchro_flag = true;
    int imageNo_old;
    LoaderThread loader;
    boolean isThreadStarted;
    boolean requestStop = false;
    ImageTiledCanvas imageTiledCanvas;
    int row = 1;
    int column = 1;
    TagInfoFrame tagInfoFrame;
    int tile_start;
    int width;
    int height;
    AnimationThread animationThread;
    boolean notCine = true;
    MyCheckBoxListener myCheckBoxListener = new MyCheckBoxListener();
    MyKeyListener myKeyListener = new MyKeyListener();
    Font bold = new Font("Dialog", 1, 12);
    Font plain = new Font("Dialog", 0, 12);
    BorderLayout borderLayout1 = new BorderLayout();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
    GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
    ScrollPane scrollPane1 = new ScrollPane();
    Panel panel1 = new Panel();
    Panel controlPanel = new Panel();
    BorderPanel borderPanel1 = new BorderPanel("Mouse Manupilation");
    Panel mousePanel = new Panel();
    InfoPanel infoPanel = new InfoPanel();
    Panel buttonPanel = new Panel();
    Panel copyrightPanel = new Panel();
    Label label1 = new Label();
    Label label2 = new Label("ImageNo");
    MyLabel copyright_L = new MyLabel("Copyright (C) 2000 Nagoya Institute of Technology, Iwata lab. & KtC");
    TextField imageNo_F = new TextField(3);
    Scrollbar imageNo_S = new Scrollbar(0);
    CheckboxGroup checkboxGroup1 = new CheckboxGroup();
    Checkbox wwwlSingle_C = new Checkbox("WL/WW(Single)", false, this.checkboxGroup1);
    Checkbox wwwlALL_C = new Checkbox("WL/WW(All images)", true, this.checkboxGroup1);
    Checkbox move_C = new Checkbox("Move", false, this.checkboxGroup1);
    Checkbox zoom_C = new Checkbox("Zoom", false, this.checkboxGroup1);
    Checkbox loupe_C = new Checkbox("Loupe", false, this.checkboxGroup1);
    Checkbox studyInfo_C = new Checkbox("Annotation", true);
    Button fit_B = new Button("Reset Move/Zoom");
    Button default_B = new Button("Default WL/WW");
    Button less_B = new Button("LessFrame");
    Button more_B = new Button("MoreFrame");
    Button tag_B = new Button("Show Tag Info");
    Button inv_B = new Button("Reverse");
    Button rotateL_B = new Button("Rotate L");
    Button rotateR_B = new Button("Rotate R");
    Button flipLR_B = new Button("Flip RL");
    Button flipUD_B = new Button("Flip UD");
    Button reset_B = new Button("Reset Angle");
    Button cine_B = new Button("Cine Mode");
    Button cineNext1_B = new Button("->");
    Button cinePrev1_B = new Button("<-");
    Button cineNext2_B = new Button(">>");
    Button cinePrev2_B = new Button("<<");

    public String getParameter(String string, String string2) {
        String string3;
        String string4 = string3 = this.getParameter(string) != null ? this.getParameter(string) : string2;
        if (this.debug_level > 3) {
            System.out.println(String.valueOf(String.valueOf(String.valueOf("Parameter ").concat(String.valueOf(string))).concat(String.valueOf(" is "))).concat(String.valueOf(string3)));
        }
        return string3;
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"isLtlEndian", "boolean", "\u0093]\u0091\u0097?\\u0095\u00b6?BLittleEndian\u0082\u00c8\u0082\u00e7true"}, {"vrType", "boolean", "VR\u0082\u00cc\u008e\u00ed\u0097\u015e?B\u0096\u00be\u008e\u00a6\u0093IVR\u0082\u00c8\u0082\u00e7true"}, {"patientPrivacy", "boolean", "\u008a\u00b3\u008e\u00d2\u0083v\u0083\u0089\u0083C\u0083o\u0083V?[\u0095\u00db\u008c\u00ec\u0082\u00cc\u0082\u00bd\u0082\u00df\u008a\u00b3\u008e\u00d2\u0096\u00bc\u0095\u00cf\u008a\u00b7\u0082\u00b7\u0082\u00e9\u0082\u00c6\u0082\u00abtrue"}, {"tmpSize", "int", "\u0083L\u0083\u0083\u0083b\u0083V\u0083\u0085\u0082\u00b3\u0082\u00ea\u0082\u00e9?\u00c5\u0091\u00e5\u0089\u00e6\u0091\u009c\u0096\u0087?\u0094(\u008b\u00f4?\u0094)"}, {"NUM", "int", "\u0089\u00e6\u0091\u009c\u0096\u0087?\u0094"}, {"currentNo", "int", "?\u00c5?\u0089\u0082\u00c9\u008c\u00a9\u0082\u00e9\u0089\u00e6\u0091\u009c\u0094\u00d4?\u0086 (0-?)"}, {"dicURL", "String", "\u008e\u00ab?\u0091URL"}, {"imgURL", "String", "\u0089\u00e6\u0091\u009cURL"}};
        return stringArray;
    }

    public void init() {
        if (this.debug_level > 3) {
            System.out.println("Now Loading Parameter....");
        }
        try {
            this.isLtlEndian = Boolean.valueOf(this.getParameter("isLtlEndian", "true"));
            this.vrType = Boolean.valueOf(this.getParameter("vrType", "false"));
            this.privacy = Boolean.valueOf(this.getParameter("patientPrivacy", "false"));
            this.TMPSIZE = Integer.parseInt(this.getParameter("tmpSize", "10"));
            this.NUM = Integer.parseInt(this.getParameter("NUM", "1"));
            this.imageNo = Integer.parseInt(this.getParameter("currentNo", "0"));
            this.dicURL = this.getParameter("dicURL", "none");
            this.imgURL = new String[this.NUM];
            int n = 0;
            while (n < this.NUM) {
                this.imgURL[n] = this.getParameter(String.valueOf("imgURL").concat(String.valueOf(n)), "");
                ++n;
            }
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.isThreadStarted = false;
        this.setLayout(this.borderLayout1);
        this.controlPanel.setLayout(this.gridBagLayout1);
        this.mousePanel.setLayout(this.gridBagLayout2);
        this.imageNo_F.setText(String.valueOf(this.imageNo + 1));
        this.imageNo_S.setValues(this.imageNo + 1, 0, 1, this.NUM + 1);
        this.less_B.setEnabled(false);
        this.cineNext1_B.setFont(this.bold);
        this.cineNext2_B.setFont(this.plain);
        this.cinePrev1_B.setFont(this.plain);
        this.cinePrev2_B.setFont(this.plain);
        this.cineNext1_B.setEnabled(false);
        this.cineNext2_B.setEnabled(false);
        this.cinePrev1_B.setEnabled(false);
        this.cinePrev2_B.setEnabled(false);
        this.panel1.setLayout(new BorderLayout());
        this.add((Component)this.scrollPane1, "Center");
        this.add((Component)this.panel1, "West");
        this.add((Component)this.copyrightPanel, "South");
        this.copyright_L.setAppletContext(this.getAppletContext());
        this.copyrightPanel.setLayout(new FlowLayout(2, 5, 0));
        this.copyrightPanel.add(this.copyright_L);
        this.buttonPanel.setLayout(new GridLayout(2, 1));
        this.buttonPanel.add(this.studyInfo_C);
        this.buttonPanel.add(this.tag_B);
        this.panel1.add((Component)this.buttonPanel, "South");
        this.panel1.add((Component)this.infoPanel, "Center");
        this.gridBagConstraints2.fill = 1;
        this.add2mousePanel(0, 0, 6, this.wwwlALL_C);
        this.add2mousePanel(0, 1, 6, this.wwwlSingle_C);
        this.add2mousePanel(0, 2, 1, this.label1);
        this.add2mousePanel(1, 2, 5, this.default_B);
        this.add2mousePanel(0, 3, 1, this.label1);
        this.add2mousePanel(1, 3, 5, this.inv_B);
        this.add2mousePanel(0, 4, 6, this.move_C);
        this.add2mousePanel(0, 5, 6, this.zoom_C);
        this.add2mousePanel(0, 6, 1, this.label1);
        this.add2mousePanel(1, 6, 5, this.fit_B);
        this.add2mousePanel(0, 7, 6, this.loupe_C);
        this.borderPanel1.add(this.mousePanel);
        this.panel1.add((Component)this.controlPanel, "North");
        this.gridBagConstraints1.fill = 1;
        this.gridBagConstraints1.gridx = 0;
        this.gridBagConstraints1.gridy = 0;
        this.gridBagConstraints1.gridwidth = 4;
        this.gridBagConstraints1.gridheight = 9;
        this.gridBagConstraints1.insets = new Insets(3, 3, 0, 3);
        this.gridBagLayout1.setConstraints(this.borderPanel1, this.gridBagConstraints1);
        this.controlPanel.add(this.borderPanel1);
        this.gridBagConstraints1.insets = new Insets(0, 0, 0, 0);
        this.gridBagConstraints1.gridheight = 1;
        int n = 9;
        this.add2controlPanel(0, n, 4, this.reset_B);
        this.add2controlPanel(0, ++n, 2, this.rotateL_B);
        this.add2controlPanel(2, n, 2, this.rotateR_B);
        this.add2controlPanel(0, ++n, 2, this.flipLR_B);
        this.add2controlPanel(2, n, 2, this.flipUD_B);
        this.gridBagConstraints1.insets = new Insets(5, 0, 0, 0);
        this.add2controlPanel(0, ++n, 4, this.cine_B);
        this.gridBagConstraints1.insets = new Insets(0, 0, 0, 0);
        this.add2controlPanel(0, ++n, 1, this.cinePrev2_B);
        this.add2controlPanel(1, n, 1, this.cinePrev1_B);
        this.add2controlPanel(2, n, 1, this.cineNext1_B);
        this.add2controlPanel(3, n, 1, this.cineNext2_B);
        this.gridBagConstraints1.insets = new Insets(5, 0, 0, 0);
        this.add2controlPanel(0, ++n, 2, this.label2);
        this.add2controlPanel(2, n, 2, this.imageNo_F);
        this.gridBagConstraints1.insets = new Insets(0, 0, 0, 0);
        this.add2controlPanel(0, ++n, 4, this.imageNo_S);
        this.add2controlPanel(0, ++n, 2, this.less_B);
        this.add2controlPanel(2, n, 2, this.more_B);
        ++n;
        this.scrollPane1.setBackground(Color.black);
        this.tagInfoFrame = new TagInfoFrame();
        this.tagInfoFrame.setSize(500, 400);
        this.tagInfoFrame.setResizable(true);
        this.imageNo_F.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Viewer.this.imageNo_S.setValue((int)Viewer.this.getFieldValue(Viewer.this.imageNo_F));
                Viewer.this.imageNo_old = Viewer.this.imageNo;
                Viewer.this.imageNo = Viewer.this.imageNo_S.getValue() - 1;
                Viewer.this.changeImageNo();
            }
        });
        this.imageNo_F.addKeyListener(this.myKeyListener);
        this.imageNo_S.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                Viewer.this.imageNo_F.setText(String.valueOf(Viewer.this.imageNo_S.getValue()));
                Viewer.this.imageNo_old = Viewer.this.imageNo;
                Viewer.this.imageNo = Viewer.this.imageNo_S.getValue() - 1;
                Viewer.this.changeImageNo();
            }
        });
        this.imageNo_S.addKeyListener(this.myKeyListener);
        this.wwwlSingle_C.addItemListener(this.myCheckBoxListener);
        this.wwwlSingle_C.addKeyListener(this.myKeyListener);
        this.wwwlALL_C.addItemListener(this.myCheckBoxListener);
        this.wwwlALL_C.addKeyListener(this.myKeyListener);
        this.move_C.addItemListener(this.myCheckBoxListener);
        this.move_C.addKeyListener(this.myKeyListener);
        this.zoom_C.addItemListener(this.myCheckBoxListener);
        this.zoom_C.addKeyListener(this.myKeyListener);
        this.loupe_C.addItemListener(this.myCheckBoxListener);
        this.loupe_C.addKeyListener(this.myKeyListener);
        this.studyInfo_C.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                Viewer.this.imageTiledCanvas.setStudyInfo_flag(Viewer.this.studyInfo_C.getState());
            }
        });
        this.studyInfo_C.addKeyListener(this.myKeyListener);
        this.fit_B.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Viewer.this.getCanvasSize();
            }
        });
        this.fit_B.addKeyListener(this.myKeyListener);
        this.default_B.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Viewer.this.defaultWwWl();
            }
        });
        this.default_B.addKeyListener(this.myKeyListener);
        this.more_B.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Viewer.this.moreFrame();
            }
        });
        this.more_B.addKeyListener(this.myKeyListener);
        this.less_B.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Viewer.this.lessFrame();
            }
        });
        this.less_B.addKeyListener(this.myKeyListener);
        this.cine_B.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Viewer.this.cineMode();
            }
        });
        this.cine_B.addKeyListener(this.myKeyListener);
        this.cineNext1_B.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Viewer.this.cineNext1_B.setFont(Viewer.this.bold);
                Viewer.this.cineNext2_B.setFont(Viewer.this.plain);
                Viewer.this.cinePrev1_B.setFont(Viewer.this.plain);
                Viewer.this.cinePrev2_B.setFont(Viewer.this.plain);
                Viewer.this.animationThread.changeInterval(1000);
                Viewer.this.animationThread.changeNext(true);
            }
        });
        this.cineNext1_B.addKeyListener(this.myKeyListener);
        this.cinePrev1_B.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Viewer.this.cineNext1_B.setFont(Viewer.this.plain);
                Viewer.this.cineNext2_B.setFont(Viewer.this.plain);
                Viewer.this.cinePrev1_B.setFont(Viewer.this.bold);
                Viewer.this.cinePrev2_B.setFont(Viewer.this.plain);
                Viewer.this.animationThread.changeInterval(1000);
                Viewer.this.animationThread.changeNext(false);
            }
        });
        this.cinePrev1_B.addKeyListener(this.myKeyListener);
        this.cineNext2_B.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Viewer.this.cineNext1_B.setFont(Viewer.this.plain);
                Viewer.this.cineNext2_B.setFont(Viewer.this.bold);
                Viewer.this.cinePrev1_B.setFont(Viewer.this.plain);
                Viewer.this.cinePrev2_B.setFont(Viewer.this.plain);
                Viewer.this.animationThread.changeInterval(300);
                Viewer.this.animationThread.changeNext(true);
            }
        });
        this.cineNext2_B.addKeyListener(this.myKeyListener);
        this.cinePrev2_B.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Viewer.this.cineNext1_B.setFont(Viewer.this.plain);
                Viewer.this.cineNext2_B.setFont(Viewer.this.plain);
                Viewer.this.cinePrev1_B.setFont(Viewer.this.plain);
                Viewer.this.cinePrev2_B.setFont(Viewer.this.bold);
                Viewer.this.animationThread.changeInterval(300);
                Viewer.this.animationThread.changeNext(false);
            }
        });
        this.cinePrev2_B.addKeyListener(this.myKeyListener);
        this.inv_B.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Viewer.this.inv_flag = true;
                Viewer.this.showTile();
                Viewer.this.inv_flag = false;
            }
        });
        this.inv_B.addKeyListener(this.myKeyListener);
        this.rotateL_B.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Viewer.this.rotateL_flag = true;
                Viewer.this.showTile();
                Viewer.this.rotateL_flag = false;
            }
        });
        this.rotateL_B.addKeyListener(this.myKeyListener);
        this.rotateR_B.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Viewer.this.rotateR_flag = true;
                Viewer.this.showTile();
                Viewer.this.rotateR_flag = false;
            }
        });
        this.rotateR_B.addKeyListener(this.myKeyListener);
        this.flipLR_B.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Viewer.this.flipLR_flag = true;
                Viewer.this.showTile();
                Viewer.this.flipLR_flag = false;
            }
        });
        this.flipLR_B.addKeyListener(this.myKeyListener);
        this.flipUD_B.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Viewer.this.flipUD_flag = true;
                Viewer.this.showTile();
                Viewer.this.flipUD_flag = false;
            }
        });
        this.flipUD_B.addKeyListener(this.myKeyListener);
        this.reset_B.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Viewer.this.reset_flag = true;
                Viewer.this.showTile();
                Viewer.this.reset_flag = false;
            }
        });
        this.reset_B.addKeyListener(this.myKeyListener);
        this.tag_B.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!Viewer.this.tagInfoFrame.isShowing()) {
                    Viewer.this.tag_B.setLabel("Hide  Tag Info");
                    Viewer.this.tagInfoFrame.setImageNo(Viewer.this.imageNo);
                    Viewer.this.tagInfoFrame.setVisible(true);
                } else {
                    Viewer.this.tag_B.setLabel("Show  Tag Info");
                    Viewer.this.tagInfoFrame.setVisible(false);
                }
            }
        });
        this.tag_B.addKeyListener(this.myKeyListener);
        this.tagInfoFrame.addWindowListener(new WindowListener(){

            public void windowClosing(WindowEvent windowEvent) {
                Viewer.this.tag_B.setLabel("Show  Tag Info");
                Viewer.this.tagInfoFrame.setVisible(false);
            }

            public void windowOpened(WindowEvent windowEvent) {
            }

            public void windowClosed(WindowEvent windowEvent) {
            }

            public void windowIconified(WindowEvent windowEvent) {
            }

            public void windowDeiconified(WindowEvent windowEvent) {
            }

            public void windowActivated(WindowEvent windowEvent) {
            }

            public void windowDeactivated(WindowEvent windowEvent) {
            }
        });
        this.scrollPane1.addKeyListener(this.myKeyListener);
        this.panel1.addKeyListener(this.myKeyListener);
        this.controlPanel.addKeyListener(this.myKeyListener);
        this.buttonPanel.addKeyListener(this.myKeyListener);
        this.mousePanel.addKeyListener(this.myKeyListener);
        this.borderPanel1.addKeyListener(this.myKeyListener);
        this.infoPanel.addKeyListener(this.myKeyListener);
        this.copyrightPanel.addKeyListener(this.myKeyListener);
        this.addKeyListener(this.myKeyListener);
        this.requestFocus();
    }

    private void add2controlPanel(int n, int n2, int n3, Component component) {
        this.gridBagConstraints1.gridx = n;
        this.gridBagConstraints1.gridy = n2;
        this.gridBagConstraints1.gridwidth = n3;
        this.gridBagLayout1.setConstraints(component, this.gridBagConstraints1);
        this.controlPanel.add(component);
    }

    private void add2mousePanel(int n, int n2, int n3, Component component) {
        this.gridBagConstraints2.gridx = n;
        this.gridBagConstraints2.gridy = n2;
        this.gridBagConstraints2.gridwidth = n3;
        this.gridBagLayout2.setConstraints(component, this.gridBagConstraints2);
        this.mousePanel.add(component);
    }

    public void start() {
        if (this.isThreadStarted) {
            return;
        }
        this.dicomData = new DicomData();
        this.imageData = new ImageData();
        if (this.NUM > this.TMPSIZE) {
            this.arrayIndex = new int[this.TMPSIZE];
            this.dicomData_tmp = new DicomData[this.TMPSIZE];
            this.imageData_tmp = new ImageData[this.TMPSIZE];
            this.tagInfoFrame.setTagInfoFrame(this.TMPSIZE);
        } else {
            this.arrayIndex = new int[this.NUM];
            this.dicomData_tmp = new DicomData[this.NUM];
            this.imageData_tmp = new ImageData[this.NUM];
            this.tagInfoFrame.setTagInfoFrame(this.NUM);
        }
        this.index = new int[this.NUM];
        this.ww = new int[this.NUM];
        this.wl = new int[this.NUM];
        int n = 0;
        while (n < this.NUM) {
            this.index[n] = -1;
            ++n;
        }
        n = 0;
        while (n < this.arrayIndex.length) {
            this.arrayIndex[n] = -1;
            ++n;
        }
        n = 0;
        while (n < this.NUM) {
            this.ww[n] = 0;
            ++n;
        }
        n = 0;
        while (n < this.NUM) {
            this.wl[n] = 0;
            ++n;
        }
        this.showStatus("Now Loading Dicom Dictionary....");
        DicomDic dicomDic = new DicomDic(this.dicURL);
        this.dicomFile = new DicomFile(this.isLtlEndian, this.vrType, this.privacy, dicomDic);
        dicomDic = null;
        int n2 = this.dicomData_tmp.length;
        this.start = this.imageNo - (n2 >> 1) <= 0 ? 0 : this.imageNo - (n2 >> 1);
        if (this.start + n2 > this.NUM) {
            this.start = this.NUM - n2;
        }
        this.loader = new LoaderThread(this.start, n2, 0, this);
        this.start_old = this.start;
        this.loader.start();
        this.takeData(this.imageNo);
        this.width = this.imageData.getWidth();
        this.height = this.imageData.getHeight();
        int n3 = 0;
        while (n3 < this.NUM) {
            ImageData imageData = this.takeImageData(n3);
            if (this.width < imageData.getWidth()) {
                this.width = imageData.getWidth();
            }
            if (this.height < imageData.getHeight()) {
                this.height = imageData.getHeight();
            }
            ++n3;
        }
        this.imageTiledCanvas = new ImageTiledCanvas(this.width, this.height, this);
        this.imageTiledCanvas.addKeyListener(this.myKeyListener);
        this.showTile();
        this.scrollPane1.add((Component)this.imageTiledCanvas, null);
        if (this.imageData.color()) {
            this.setRGBEnabled(false);
        }
        if (this.NUM == 1) {
            this.wwwlALL_C.setEnabled(false);
            this.cine_B.setEnabled(false);
            this.more_B.setEnabled(false);
            this.checkboxGroup1.setSelectedCheckbox(this.wwwlSingle_C);
            this.synchro_flag = false;
        }
        this.isThreadStarted = true;
    }

    public void stop() {
        if (this.loader != null) {
            if (this.loader.isAlive()) {
                this.changeStopRequest(true);
            }
            while (this.requestStop) {
                try {
                    this.wait(200L);
                    if (this.loader.isAlive()) continue;
                    this.changeStopRequest(false);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.loader = null;
        }
        if (this.animationThread != null) {
            this.animationThread.requestStop();
            this.animationThread = null;
        }
    }

    public void destroy() {
        this.stop();
    }

    public synchronized void postData(int n, int n2, int n3) {
        int n4 = this.dicomData_tmp.length;
        int n5 = 0;
        int n6 = 0;
        DicomData dicomData = new DicomData();
        ImageData imageData = new ImageData();
        this.showStatus(String.valueOf(String.valueOf("Now Loading Dicom File....  (").concat(String.valueOf(n + 1))).concat(String.valueOf(")")));
        dicomData = this.dicomFile.load(this.imgURL[n]);
        this.showStatus(String.valueOf(String.valueOf("Now Creating Dicom Image....  (").concat(String.valueOf(n + 1))).concat(String.valueOf(")")));
        imageData.setData(dicomData);
        int n7 = 0;
        while (n7 < this.arrayIndex.length) {
            if (n2 > this.arrayIndex[n7] || n3 <= this.arrayIndex[n7]) {
                n6 = this.arrayIndex[n7];
                n5 = n7;
            }
            ++n7;
        }
        if (n6 > -1) {
            this.index[n6] = -1;
        }
        this.index[n] = n5;
        this.arrayIndex[n5] = n;
        this.dicomData_tmp[n5] = null;
        this.imageData_tmp[n5] = null;
        this.dicomData_tmp[n5] = dicomData;
        this.imageData_tmp[n5] = imageData;
        this.tagInfoFrame.setDicomData(dicomData, n5, n);
        this.notifyAll();
        dicomData = null;
        imageData = null;
    }

    public synchronized void takeData(int n) {
        while (this.index[n] < 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        int n2 = this.index[n];
        this.dicomData = null;
        this.imageData = null;
        this.dicomData = this.dicomData_tmp[n2];
        this.imageData = this.imageData_tmp[n2];
        this.infoPanel.setDicomData(this.dicomData);
        this.notifyAll();
    }

    public synchronized ImageData takeImageData(int n) {
        while (this.index[n] < 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        int n2 = this.index[n];
        this.notifyAll();
        return this.imageData_tmp[n2];
    }

    public synchronized boolean confirmStopRequest() {
        return this.requestStop;
    }

    public synchronized void changeStopRequest(boolean bl) {
        this.requestStop = bl;
        this.notifyAll();
    }

    public synchronized void startLoaderThread(int n, int n2, int n3) {
        if (this.loader.isAlive()) {
            this.changeStopRequest(true);
        }
        while (this.requestStop) {
            try {
                this.wait(200L);
                if (this.loader.isAlive()) continue;
                this.changeStopRequest(false);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.loader = null;
        this.loader = new LoaderThread(n, n2, n3, this);
        this.loader.start();
        this.notifyAll();
    }

    private double getFieldValue(TextField textField) {
        double d;
        try {
            d = Double.valueOf(textField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            d = 0.0;
        }
        return d;
    }

    public void drag_changeZoom(int n) {
        this.zoom -= 0.005 * (double)n;
        if (this.zoom < 0.25) {
            this.zoom = 0.25;
        } else if (this.zoom > 2.0) {
            this.zoom = 2.0;
        }
        this.imageTiledCanvas.changeZoom(this.zoom);
    }

    private void changeCanvasSize() {
        double d = 100.0 / (double)this.canvasSize;
        this.zoom = d > 2.0 ? 2.0 : (d < 0.25 ? 0.25 : d);
        this.imageTiledCanvas.changeCanvasSize((double)this.canvasSize * 0.01);
        this.imageTiledCanvas.changeZoom(this.zoom);
    }

    private void getCanvasSize() {
        Dimension dimension = this.scrollPane1.getSize();
        int n = (int)((double)dimension.height / (double)(this.height * this.row) * 100.0);
        int n2 = (int)((double)dimension.width / (double)(this.width * this.column) * 100.0);
        int n3 = n < n2 ? n : n2;
        if (n3 > 100) {
            n3 = 100;
        }
        this.canvasSize = n3;
        this.changeCanvasSize();
    }

    public void drag_changeWwWl(int n, int n2) {
        int n3 = this.imageData.getWW() + n;
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 > this.imageData.getPixelMax() - this.imageData.getPixelMin()) {
            n3 = this.imageData.getPixelMax() - this.imageData.getPixelMin();
        }
        int n4 = this.imageData.getWL() + n2;
        if (n4 < this.imageData.getPixelMin()) {
            n4 = this.imageData.getPixelMin();
        } else if (n4 > this.imageData.getPixelMax()) {
            n4 = this.imageData.getPixelMax();
        }
        this.imageTiledCanvas.setWW_WL(n3, n4, this.imageNo - this.tile_start);
        this.imageTiledCanvas.changeImage(this.imageData.wwANDwl(n3, n4), this.imageNo - this.tile_start);
    }

    public void dragDone_changeWwWl(int n, int n2, int n3, int n4) {
        if (!this.synchro_flag) {
            int n5 = this.imageData.getWW() + n;
            if (n5 < 0) {
                n5 = 0;
            } else if (n5 > this.imageData.getPixelMax() - this.imageData.getPixelMin()) {
                n5 = this.imageData.getPixelMax() - this.imageData.getPixelMin();
            }
            int n6 = this.imageData.getWL() + n3;
            if (n6 < this.imageData.getPixelMin()) {
                n6 = this.imageData.getPixelMin();
            } else if (n6 > this.imageData.getPixelMax()) {
                n6 = this.imageData.getPixelMax();
            }
            this.imageTiledCanvas.setWW_WL(n5, n6, this.imageNo - this.tile_start);
            this.imageTiledCanvas.changeImage(this.imageData.wwANDwl(n5, n6), this.imageNo - this.tile_start);
            int n7 = this.imageNo;
            this.ww[n7] = this.ww[n7] + n2;
            int n8 = this.imageNo;
            this.wl[n8] = this.wl[n8] + n4;
        } else {
            int n9 = 0;
            int n10 = this.row * this.column;
            int n11 = this.tile_start;
            while (n11 < this.tile_start + n10) {
                int n12;
                int n13;
                if (n9 >= this.dicomData_tmp.length) break;
                ImageData imageData = this.takeImageData(n11);
                if (n11 == this.imageNo) {
                    n13 = imageData.getWW() + n;
                    if (n13 < 0) {
                        n13 = 0;
                    } else if (n13 > imageData.getPixelMax() - imageData.getPixelMin()) {
                        n13 = imageData.getPixelMax() - imageData.getPixelMin();
                    }
                    n12 = imageData.getWL() + n3;
                    if (n12 < imageData.getPixelMin()) {
                        n12 = imageData.getPixelMin();
                    } else if (n12 > imageData.getPixelMax()) {
                        n12 = imageData.getPixelMax();
                    }
                } else {
                    n13 = imageData.getWW() + n2;
                    if (n13 < 0) {
                        n13 = 0;
                    } else if (n13 > imageData.getPixelMax() - imageData.getPixelMin()) {
                        n13 = imageData.getPixelMax() - imageData.getPixelMin();
                    }
                    n12 = imageData.getWL() + n4;
                    if (n12 < imageData.getPixelMin()) {
                        n12 = imageData.getPixelMin();
                    } else if (n12 > imageData.getPixelMax()) {
                        n12 = imageData.getPixelMax();
                    }
                }
                this.imageTiledCanvas.setWW_WL(n13, n12, n9);
                this.imageTiledCanvas.setImage(imageData.wwANDwl(n13, n12), n9);
                ++n9;
                ++n11;
            }
            n11 = n9;
            while (n11 < n10) {
                this.imageTiledCanvas.setImage(null, n11);
                ++n11;
            }
            n11 = 0;
            while (n11 < this.NUM) {
                int n14 = n11++;
                this.ww[n14] = this.ww[n14] + n2;
            }
            n11 = 0;
            while (n11 < this.NUM) {
                int n15 = n11++;
                this.wl[n15] = this.wl[n15] + n4;
            }
        }
    }

    private void defaultWwWl() {
        if (!this.synchro_flag) {
            int n = this.imageData.getDefaultWW();
            int n2 = this.imageData.getDefaultWL();
            this.imageTiledCanvas.setWW_WL(n, n2, this.imageNo - this.tile_start);
            this.imageTiledCanvas.changeImage(this.imageData.wwANDwl(n, n2), this.imageNo - this.tile_start);
            this.ww[this.imageNo] = 0;
            this.wl[this.imageNo] = 0;
        } else {
            int n = 0;
            int n3 = this.row * this.column;
            int n4 = this.tile_start;
            while (n4 < this.tile_start + n3) {
                if (n >= this.dicomData_tmp.length) break;
                ImageData imageData = this.takeImageData(n4);
                int n5 = imageData.getDefaultWW();
                int n6 = imageData.getDefaultWL();
                this.imageTiledCanvas.setWW_WL(n5, n6, n);
                this.imageTiledCanvas.setImage(imageData.wwANDwl(n5, n6), n);
                ++n;
                ++n4;
            }
            n4 = n;
            while (n4 < n3) {
                this.imageTiledCanvas.setImage(null, n4);
                ++n4;
            }
            n4 = 0;
            while (n4 < this.NUM) {
                this.ww[n4] = 0;
                ++n4;
            }
            n4 = 0;
            while (n4 < this.NUM) {
                this.wl[n4] = 0;
                ++n4;
            }
        }
    }

    private void cineMode() {
        if (this.animationThread == null) {
            this.notCine = false;
            this.cine_B.setLabel("Stop");
            this.cineNext1_B.setFont(this.bold);
            this.cineNext2_B.setFont(this.plain);
            this.cinePrev1_B.setFont(this.plain);
            this.cinePrev2_B.setFont(this.plain);
            this.cineNext1_B.setEnabled(true);
            this.cinePrev1_B.setEnabled(true);
            this.cineNext2_B.setEnabled(true);
            this.cinePrev2_B.setEnabled(true);
            this.animationThread = new AnimationThread(this);
            this.animationThread.start();
        } else {
            this.notCine = true;
            this.cine_B.setLabel("Cine Mode");
            this.cineNext1_B.setEnabled(false);
            this.cineNext2_B.setEnabled(false);
            this.cinePrev1_B.setEnabled(false);
            this.cinePrev2_B.setEnabled(false);
            this.animationThread.requestStop();
            this.animationThread = null;
        }
    }

    public void changeImageNo() {
        int n = this.dicomData_tmp.length;
        this.start = this.imageNo - (n >> 1) <= 0 ? 0 : this.imageNo - (n >> 1);
        if (this.start + n > this.NUM) {
            this.start = this.NUM - n;
        }
        this.startLoaderThread(this.start, n, this.start_old);
        this.start_old = this.start;
        this.showTile();
    }

    private void moreFrame() {
        double d;
        double d2;
        double d3 = (double)this.canvasSize * 0.01;
        Dimension dimension = this.scrollPane1.getSize();
        if (!this.less_B.isEnabled()) {
            this.less_B.setEnabled(true);
        }
        if ((d2 = (double)dimension.height - (double)this.height * d3 * (double)this.row) > (d = (double)dimension.width - (double)this.width * d3 * (double)this.column)) {
            ++this.row;
        } else {
            ++this.column;
        }
        if (this.row > 9) {
            this.row = 9;
        }
        if (this.column > 9) {
            this.column = 9;
        }
        this.getCanvasSize();
        if (this.row * this.column >= this.arrayIndex.length) {
            this.more_B.setEnabled(false);
        }
        this.showTile();
        this.scrollPane1.setVisible(false);
        this.scrollPane1.setBackground(Color.black);
        this.scrollPane1.setVisible(true);
    }

    private void lessFrame() {
        double d;
        double d2;
        double d3 = (double)this.canvasSize * 0.01;
        Dimension dimension = this.scrollPane1.getSize();
        if (!this.more_B.isEnabled()) {
            this.more_B.setEnabled(true);
        }
        if ((d2 = (double)dimension.height - (double)this.height * d3 * (double)this.row) < (d = (double)dimension.width - (double)this.width * d3 * (double)this.column)) {
            if (this.row == 1) {
                --this.column;
            } else {
                --this.row;
            }
        } else if (this.column == 1) {
            --this.row;
        } else {
            --this.column;
        }
        if (this.row < 1) {
            this.row = 1;
        }
        if (this.column < 1) {
            this.column = 1;
        }
        this.getCanvasSize();
        if (this.row * this.column == 1) {
            this.less_B.setEnabled(false);
        }
        this.showTile();
        this.scrollPane1.setVisible(false);
        this.scrollPane1.setBackground(Color.black);
        this.scrollPane1.setVisible(true);
    }

    public void changeActive(int n) {
        int n2 = this.index[n];
        if (n2 == -1) {
            return;
        }
        this.dicomData = null;
        this.imageData = null;
        this.dicomData = this.dicomData_tmp[n2];
        this.imageData = this.imageData_tmp[n2];
        this.infoPanel.setDicomData(this.dicomData);
        this.imageNo = n;
        this.imageNo_F.setText(String.valueOf(n + 1));
        this.imageNo_S.setValue(n + 1);
        if (this.imageData.color()) {
            this.setRGBEnabled(false);
        } else {
            this.setRGBEnabled(true);
        }
    }

    private void showTile() {
        int n = this.row * this.column;
        int n2 = this.dicomData_tmp.length;
        this.imageTiledCanvas.setTileType(this.row, this.column);
        int n3 = 0;
        this.tile_start = this.imageNo - (n >> 1) <= 0 ? 0 : this.imageNo - (n >> 1);
        if (this.tile_start + n > this.start + n2) {
            this.tile_start = this.start + n2 - n;
        }
        if (this.tile_start < this.start) {
            this.tile_start = this.start;
        }
        this.imageTiledCanvas.setStartNo(this.tile_start);
        int n4 = this.tile_start;
        while (n4 < this.tile_start + n) {
            if (n3 >= n2) break;
            if (this.debug_level > 3) {
                System.out.println(String.valueOf("Load imageData ").concat(String.valueOf(n3)));
            }
            ImageData imageData = this.takeImageData(n4);
            if (this.inv_flag) {
                imageData.inverse();
            }
            if (this.rotateL_flag) {
                imageData.rotateL();
            }
            if (this.rotateR_flag) {
                imageData.rotateR();
            }
            if (this.flipLR_flag) {
                imageData.flipLR();
            }
            if (this.flipUD_flag) {
                imageData.flipUD();
            }
            if (this.reset_flag) {
                imageData.setDefaultPixel();
            }
            if (n4 == this.imageNo) {
                this.imageTiledCanvas.setActiveNo(n3);
            }
            this.imageTiledCanvas.setImage(imageData.getImageWWWL2Current(this.ww[n4], this.wl[n4]), n3);
            this.imageTiledCanvas.setWW_WL(imageData.getWW(), imageData.getWL(), n3);
            this.imageTiledCanvas.setStudyInfo(this.dicomData_tmp[this.index[n4]], n3);
            ++n3;
            ++n4;
        }
        n4 = n3;
        while (n4 < n) {
            this.imageTiledCanvas.setImage(null, n4);
            this.imageTiledCanvas.setStudyInfo(null, n4);
            ++n4;
        }
        this.takeData(this.imageNo);
        if (this.imageData.color()) {
            this.setRGBEnabled(false);
        } else {
            this.setRGBEnabled(true);
        }
    }

    private void setRGBEnabled(boolean bl) {
        this.default_B.setEnabled(bl);
        this.inv_B.setEnabled(bl);
        this.wwwlSingle_C.setEnabled(bl);
        if (this.NUM == 1) {
            this.wwwlALL_C.setEnabled(false);
        } else {
            this.wwwlALL_C.setEnabled(bl);
        }
        if (!bl && (this.wwwlSingle_C.getState() || this.wwwlALL_C.getState())) {
            this.move_C.setState(true);
            this.imageTiledCanvas.setMoveState(true);
        }
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public String getAppletInfo() {
        return "Applet Information";
    }

    private void changeSelectCheckBox(Checkbox checkbox) {
        this.checkboxGroup1.setSelectedCheckbox(checkbox);
        if (checkbox == this.wwwlSingle_C) {
            this.synchro_flag = false;
        } else if (checkbox == this.wwwlALL_C) {
            this.synchro_flag = true;
        }
        this.imageTiledCanvas.setMoveState(this.move_C.getState());
        this.imageTiledCanvas.setZoomState(this.zoom_C.getState());
        this.imageTiledCanvas.setLoupeState(this.loupe_C.getState());
    }

    private void key_changeZoom(double d) {
        double d2 = 100.0 / (double)this.canvasSize;
        if (d2 > 2.0) {
            d2 = 2.0;
        } else if (d2 < 0.25) {
            d2 = 0.25;
        }
        this.zoom = d2 * d;
        if (this.zoom < 0.25) {
            this.zoom = 0.25;
        } else if (this.zoom > 2.0) {
            this.zoom = 2.0;
        }
        this.imageTiledCanvas.changeZoom(this.zoom);
    }

    private void key_changeWwWl(double d, double d2) {
        if (!this.synchro_flag) {
            int n = this.imageData.getPixelMax() - this.imageData.getPixelMin();
            int n2 = this.imageData.getDefaultWW() + this.ww[this.imageNo] + (int)((double)n * d);
            if (n2 < 0) {
                n2 = 0;
            } else if (n2 > n) {
                n2 = n;
            }
            int n3 = this.imageData.getDefaultWL() + this.wl[this.imageNo] + (int)((double)n2 * d2);
            if (n3 < this.imageData.getPixelMin()) {
                n3 = this.imageData.getPixelMin();
            } else if (n3 > this.imageData.getPixelMax()) {
                n3 = this.imageData.getPixelMax();
            }
            this.imageTiledCanvas.setWW_WL(n2, n3, this.imageNo - this.tile_start);
            this.imageTiledCanvas.changeImage(this.imageData.wwANDwl(n2, n3), this.imageNo - this.tile_start);
        } else {
            int n = 0;
            int n4 = this.row * this.column;
            int n5 = this.tile_start;
            while (n5 < this.tile_start + n4) {
                if (n >= this.dicomData_tmp.length) break;
                ImageData imageData = this.takeImageData(n5);
                int n6 = imageData.getPixelMax() - imageData.getPixelMin();
                int n7 = imageData.getDefaultWW() + this.ww[n5] + (int)((double)n6 * d);
                if (n7 < 0) {
                    n7 = 0;
                } else if (n7 > n6) {
                    n7 = n6;
                }
                int n8 = imageData.getDefaultWL() + this.wl[n5] + (int)((double)n7 * d2);
                if (n8 < imageData.getPixelMin()) {
                    n8 = imageData.getPixelMin();
                } else if (n8 > imageData.getPixelMax()) {
                    n8 = imageData.getPixelMax();
                }
                this.imageTiledCanvas.setWW_WL(n7, n8, n);
                this.imageTiledCanvas.setImage(imageData.wwANDwl(n7, n8), n);
                ++n;
                ++n5;
            }
            n5 = n;
            while (n5 < n4) {
                this.imageTiledCanvas.setImage(null, n5);
                ++n5;
            }
        }
    }

    class MyKeyListener
    implements KeyListener {
        boolean isWW = false;

        MyKeyListener() {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            if (keyEvent.isControlDown()) {
                if (n == 87) {
                    this.isWW = false;
                    if (keyEvent.isShiftDown()) {
                        Viewer.this.changeSelectCheckBox(Viewer.this.wwwlSingle_C);
                    } else {
                        Viewer.this.changeSelectCheckBox(Viewer.this.wwwlALL_C);
                    }
                } else if (n == 81) {
                    this.isWW = true;
                    if (keyEvent.isShiftDown()) {
                        Viewer.this.changeSelectCheckBox(Viewer.this.wwwlSingle_C);
                    } else {
                        Viewer.this.changeSelectCheckBox(Viewer.this.wwwlALL_C);
                    }
                } else if (n == 79) {
                    Viewer.this.changeSelectCheckBox(Viewer.this.move_C);
                } else if (n == 90) {
                    Viewer.this.changeSelectCheckBox(Viewer.this.zoom_C);
                } else if (n == 85) {
                    Viewer.this.changeSelectCheckBox(Viewer.this.loupe_C);
                } else if (n == 68) {
                    Viewer.this.defaultWwWl();
                } else if (n == 73) {
                    if (keyEvent.isShiftDown()) {
                        Viewer.this.studyInfo_C.setState(!Viewer.this.studyInfo_C.getState());
                        Viewer.this.imageTiledCanvas.setStudyInfo_flag(Viewer.this.studyInfo_C.getState());
                    } else if (Viewer.this.notCine) {
                        Viewer.this.inv_flag = true;
                        Viewer.this.showTile();
                        Viewer.this.inv_flag = false;
                    } else {
                        Viewer.this.cineNext1_B.setFont(Viewer.this.plain);
                        Viewer.this.cineNext2_B.setFont(Viewer.this.plain);
                        Viewer.this.cinePrev1_B.setFont(Viewer.this.bold);
                        Viewer.this.cinePrev2_B.setFont(Viewer.this.plain);
                        Viewer.this.animationThread.changeInterval(1000);
                        Viewer.this.animationThread.changeNext(false);
                    }
                } else if (n == 84) {
                    if (keyEvent.isShiftDown()) {
                        if (!Viewer.this.tagInfoFrame.isShowing()) {
                            Viewer.this.tag_B.setLabel("Hide  Tag Info");
                            Viewer.this.tagInfoFrame.setImageNo(Viewer.this.imageNo);
                            Viewer.this.tagInfoFrame.setVisible(true);
                        } else {
                            Viewer.this.tag_B.setLabel("Show  Tag Info");
                            Viewer.this.tagInfoFrame.setVisible(false);
                        }
                    } else if (Viewer.this.notCine) {
                        Viewer.this.getCanvasSize();
                    } else {
                        Viewer.this.cineNext1_B.setFont(Viewer.this.bold);
                        Viewer.this.cineNext2_B.setFont(Viewer.this.plain);
                        Viewer.this.cinePrev1_B.setFont(Viewer.this.plain);
                        Viewer.this.cinePrev2_B.setFont(Viewer.this.plain);
                        Viewer.this.animationThread.changeInterval(1000);
                        Viewer.this.animationThread.changeNext(true);
                    }
                } else if (n == 82) {
                    if (keyEvent.isShiftDown()) {
                        Viewer.this.rotateR_flag = true;
                        Viewer.this.showTile();
                        Viewer.this.rotateR_flag = false;
                    } else if (Viewer.this.notCine) {
                        Viewer.this.rotateL_flag = true;
                        Viewer.this.showTile();
                        Viewer.this.rotateL_flag = false;
                    } else {
                        Viewer.this.cineNext1_B.setFont(Viewer.this.plain);
                        Viewer.this.cineNext2_B.setFont(Viewer.this.plain);
                        Viewer.this.cinePrev1_B.setFont(Viewer.this.plain);
                        Viewer.this.cinePrev2_B.setFont(Viewer.this.bold);
                        Viewer.this.animationThread.changeInterval(300);
                        Viewer.this.animationThread.changeNext(false);
                    }
                } else if (n == 70) {
                    if (keyEvent.isShiftDown()) {
                        Viewer.this.flipLR_flag = true;
                        Viewer.this.showTile();
                        Viewer.this.flipLR_flag = false;
                    } else if (Viewer.this.notCine) {
                        Viewer.this.flipUD_flag = true;
                        Viewer.this.showTile();
                        Viewer.this.flipUD_flag = false;
                    } else {
                        Viewer.this.cineNext1_B.setFont(Viewer.this.plain);
                        Viewer.this.cineNext2_B.setFont(Viewer.this.bold);
                        Viewer.this.cinePrev1_B.setFont(Viewer.this.plain);
                        Viewer.this.cinePrev2_B.setFont(Viewer.this.plain);
                        Viewer.this.animationThread.changeInterval(300);
                        Viewer.this.animationThread.changeNext(true);
                    }
                } else if (n == 67) {
                    if (keyEvent.isShiftDown()) {
                        Viewer.this.cineMode();
                    } else if (Viewer.this.notCine) {
                        Viewer.this.reset_flag = true;
                        Viewer.this.showTile();
                        Viewer.this.reset_flag = false;
                    } else {
                        Viewer.this.cineMode();
                    }
                } else if (n == 77) {
                    if (Viewer.this.more_B.isEnabled()) {
                        Viewer.this.moreFrame();
                    }
                } else if (n == 76) {
                    if (Viewer.this.less_B.isEnabled()) {
                        Viewer.this.lessFrame();
                    }
                } else if (n == 49) {
                    if (Viewer.this.zoom_C.getState()) {
                        if (keyEvent.isShiftDown()) {
                            Viewer.this.key_changeZoom(1.0);
                        } else {
                            Viewer.this.key_changeZoom(1.0);
                        }
                    } else {
                        if (!Viewer.this.wwwlSingle_C.getState() && !Viewer.this.wwwlALL_C.getState()) {
                            Viewer.this.changeSelectCheckBox(Viewer.this.wwwlALL_C);
                        }
                        if (this.isWW) {
                            if (keyEvent.isShiftDown()) {
                                Viewer.this.key_changeWwWl(0.0, 0.0);
                            } else {
                                Viewer.this.key_changeWwWl(0.0, 0.0);
                            }
                        } else if (keyEvent.isShiftDown()) {
                            Viewer.this.key_changeWwWl(0.0, 0.0);
                        } else {
                            Viewer.this.key_changeWwWl(0.0, 0.0);
                        }
                    }
                } else if (n == 50) {
                    if (Viewer.this.zoom_C.getState()) {
                        if (keyEvent.isShiftDown()) {
                            Viewer.this.key_changeZoom(0.9);
                        } else {
                            Viewer.this.key_changeZoom(1.2);
                        }
                    } else {
                        if (!Viewer.this.wwwlSingle_C.getState() && !Viewer.this.wwwlALL_C.getState()) {
                            Viewer.this.changeSelectCheckBox(Viewer.this.wwwlALL_C);
                        }
                        if (this.isWW) {
                            if (keyEvent.isShiftDown()) {
                                Viewer.this.key_changeWwWl(-0.01, 0.0);
                            } else {
                                Viewer.this.key_changeWwWl(0.01, 0.0);
                            }
                        } else if (keyEvent.isShiftDown()) {
                            Viewer.this.key_changeWwWl(0.0, -0.01);
                        } else {
                            Viewer.this.key_changeWwWl(0.0, 0.01);
                        }
                    }
                } else if (n == 51) {
                    if (Viewer.this.zoom_C.getState()) {
                        if (keyEvent.isShiftDown()) {
                            Viewer.this.key_changeZoom(0.8);
                        } else {
                            Viewer.this.key_changeZoom(1.4);
                        }
                    } else {
                        if (!Viewer.this.wwwlSingle_C.getState() && !Viewer.this.wwwlALL_C.getState()) {
                            Viewer.this.changeSelectCheckBox(Viewer.this.wwwlALL_C);
                        }
                        if (this.isWW) {
                            if (keyEvent.isShiftDown()) {
                                Viewer.this.key_changeWwWl(-0.02, 0.0);
                            } else {
                                Viewer.this.key_changeWwWl(0.02, 0.0);
                            }
                        } else if (keyEvent.isShiftDown()) {
                            Viewer.this.key_changeWwWl(0.0, -0.02);
                        } else {
                            Viewer.this.key_changeWwWl(0.0, 0.02);
                        }
                    }
                } else if (n == 52) {
                    if (Viewer.this.zoom_C.getState()) {
                        if (keyEvent.isShiftDown()) {
                            Viewer.this.key_changeZoom(0.7);
                        } else {
                            Viewer.this.key_changeZoom(1.6);
                        }
                    } else {
                        if (!Viewer.this.wwwlSingle_C.getState() && !Viewer.this.wwwlALL_C.getState()) {
                            Viewer.this.changeSelectCheckBox(Viewer.this.wwwlALL_C);
                        }
                        if (this.isWW) {
                            if (keyEvent.isShiftDown()) {
                                Viewer.this.key_changeWwWl(-0.03, 0.0);
                            } else {
                                Viewer.this.key_changeWwWl(0.03, 0.0);
                            }
                        } else if (keyEvent.isShiftDown()) {
                            Viewer.this.key_changeWwWl(0.0, -0.03);
                        } else {
                            Viewer.this.key_changeWwWl(0.0, 0.03);
                        }
                    }
                } else if (n == 53) {
                    if (Viewer.this.zoom_C.getState()) {
                        if (keyEvent.isShiftDown()) {
                            Viewer.this.key_changeZoom(0.6);
                        } else {
                            Viewer.this.key_changeZoom(1.8);
                        }
                    } else {
                        if (!Viewer.this.wwwlSingle_C.getState() && !Viewer.this.wwwlALL_C.getState()) {
                            Viewer.this.changeSelectCheckBox(Viewer.this.wwwlALL_C);
                        }
                        if (this.isWW) {
                            if (keyEvent.isShiftDown()) {
                                Viewer.this.key_changeWwWl(-0.05, 0.0);
                            } else {
                                Viewer.this.key_changeWwWl(0.05, 0.0);
                            }
                        } else if (keyEvent.isShiftDown()) {
                            Viewer.this.key_changeWwWl(0.0, -0.05);
                        } else {
                            Viewer.this.key_changeWwWl(0.0, 0.05);
                        }
                    }
                } else if (n == 54) {
                    if (Viewer.this.zoom_C.getState()) {
                        if (keyEvent.isShiftDown()) {
                            Viewer.this.key_changeZoom(0.5);
                        } else {
                            Viewer.this.key_changeZoom(2.0);
                        }
                    } else {
                        if (!Viewer.this.wwwlSingle_C.getState() && !Viewer.this.wwwlALL_C.getState()) {
                            Viewer.this.changeSelectCheckBox(Viewer.this.wwwlALL_C);
                        }
                        if (this.isWW) {
                            if (keyEvent.isShiftDown()) {
                                Viewer.this.key_changeWwWl(-0.1, 0.0);
                            } else {
                                Viewer.this.key_changeWwWl(0.1, 0.0);
                            }
                        } else if (keyEvent.isShiftDown()) {
                            Viewer.this.key_changeWwWl(0.0, -0.1);
                        } else {
                            Viewer.this.key_changeWwWl(0.0, 0.1);
                        }
                    }
                } else if (n == 55) {
                    if (Viewer.this.zoom_C.getState()) {
                        if (keyEvent.isShiftDown()) {
                            Viewer.this.key_changeZoom(0.4);
                        } else {
                            Viewer.this.key_changeZoom(2.2);
                        }
                    } else {
                        if (!Viewer.this.wwwlSingle_C.getState() && !Viewer.this.wwwlALL_C.getState()) {
                            Viewer.this.changeSelectCheckBox(Viewer.this.wwwlALL_C);
                        }
                        if (this.isWW) {
                            if (keyEvent.isShiftDown()) {
                                Viewer.this.key_changeWwWl(-0.2, 0.0);
                            } else {
                                Viewer.this.key_changeWwWl(0.2, 0.0);
                            }
                        } else if (keyEvent.isShiftDown()) {
                            Viewer.this.key_changeWwWl(0.0, -0.2);
                        } else {
                            Viewer.this.key_changeWwWl(0.0, 0.2);
                        }
                    }
                } else if (n == 56) {
                    if (Viewer.this.zoom_C.getState()) {
                        if (keyEvent.isShiftDown()) {
                            Viewer.this.key_changeZoom(0.3);
                        } else {
                            Viewer.this.key_changeZoom(2.4);
                        }
                    } else {
                        if (!Viewer.this.wwwlSingle_C.getState() && !Viewer.this.wwwlALL_C.getState()) {
                            Viewer.this.changeSelectCheckBox(Viewer.this.wwwlALL_C);
                        }
                        if (this.isWW) {
                            if (keyEvent.isShiftDown()) {
                                Viewer.this.key_changeWwWl(-0.4, 0.0);
                            } else {
                                Viewer.this.key_changeWwWl(0.4, 0.0);
                            }
                        } else if (keyEvent.isShiftDown()) {
                            Viewer.this.key_changeWwWl(0.0, -0.4);
                        } else {
                            Viewer.this.key_changeWwWl(0.0, 0.4);
                        }
                    }
                } else if (n == 57) {
                    if (Viewer.this.imageNo > 0) {
                        Viewer.this.imageNo_old = Viewer.this.imageNo--;
                        Viewer.this.imageNo_S.setValue(Viewer.this.imageNo + 1);
                        Viewer.this.imageNo_F.setText(String.valueOf(Viewer.this.imageNo + 1));
                        Viewer.this.changeImageNo();
                    }
                } else if (n == 48 && Viewer.this.imageNo < Viewer.this.NUM - 1) {
                    Viewer.this.imageNo_old = Viewer.this.imageNo++;
                    Viewer.this.imageNo_S.setValue(Viewer.this.imageNo + 1);
                    Viewer.this.imageNo_F.setText(String.valueOf(Viewer.this.imageNo + 1));
                    Viewer.this.changeImageNo();
                }
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
        }
    }

    class MyCheckBoxListener
    implements ItemListener {
        MyCheckBoxListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (Viewer.this.wwwlSingle_C.getState()) {
                Viewer.this.synchro_flag = false;
            } else if (Viewer.this.wwwlALL_C.getState()) {
                Viewer.this.synchro_flag = true;
            }
            Viewer.this.imageTiledCanvas.setMoveState(Viewer.this.move_C.getState());
            Viewer.this.imageTiledCanvas.setZoomState(Viewer.this.zoom_C.getState());
            Viewer.this.imageTiledCanvas.setLoupeState(Viewer.this.loupe_C.getState());
        }
    }
}

