/*
 * Decompiled with CFR 0.152.
 */
package dicomviewer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.util.Vector;

public class hGrid
extends Panel {
    Dimension dMinimum;
    Font fFont = new Font("Dialog", 0, 12);
    FontMetrics fMetrics;
    Graphics gImage;
    Image iImage;
    int iWidth;
    int iHeight;
    int iRowHeadWidth = 0;
    int iRowHeight;
    int iFirstRow;
    int iGridWidth;
    int iGridHeight;
    int iX;
    int iY;
    String[] sColHead;
    Vector vData;
    Vector vRowHead;
    int[] iColWidth;
    int iColCount;
    int iRowCount;
    Scrollbar sbHoriz;
    Scrollbar sbVert;
    int iSbWidth;
    int iSbHeight;
    boolean bDrag;
    int iXDrag;
    int iColDrag;
    TextField tEdit;
    boolean bEditing;
    int iSelectRow = -1;
    int iSelectColumn;
    Component cCallback;
    int iEditX;
    int iEditY;
    int iEditWidth;

    public hGrid() {
        this.setLayout(null);
        this.sbHoriz = new Scrollbar(0);
        this.add(this.sbHoriz);
        this.sbVert = new Scrollbar(1);
        this.add(this.sbVert);
        this.tEdit = new TextField();
        this.add(this.tEdit);
    }

    public void setMinimumSize(Dimension dimension) {
        this.dMinimum = dimension;
    }

    public void setCallback(Component component) {
        this.cCallback = component;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.iSbHeight = this.sbHoriz.getPreferredSize().height;
        this.iSbWidth = this.sbVert.getPreferredSize().width;
        this.iHeight = n4 - this.iSbHeight;
        this.iWidth = n3 - this.iSbWidth;
        this.sbHoriz.setBounds(0, this.iHeight, this.iWidth, this.iSbHeight);
        this.sbVert.setBounds(this.iWidth, 0, this.iSbWidth, this.iHeight);
        this.adjustScroll();
        this.iImage = null;
        this.showText();
        this.repaint();
    }

    public void setHead(String[] stringArray) {
        this.vData = new Vector();
        this.vRowHead = new Vector();
        this.iColCount = stringArray.length;
        this.sColHead = new String[this.iColCount];
        this.iColWidth = new int[this.iColCount];
        int n = 0;
        while (n < this.iColCount) {
            this.sColHead[n] = stringArray[n];
            this.iColWidth[n] = 100;
            ++n;
        }
        this.iRowCount = 0;
    }

    public void addRow(String string, String[] stringArray) {
        this.vRowHead.addElement(string);
        if (stringArray.length != this.iColCount) {
            return;
        }
        String[] stringArray2 = new String[this.iColCount];
        int n = 0;
        while (n < this.iColCount) {
            stringArray2[n] = stringArray[n];
            ++n;
        }
        this.vData.addElement(stringArray2);
        ++this.iRowCount;
        this.adjustScroll();
        this.repaint();
    }

    public void addRow(String[] stringArray) {
        this.addRow("", stringArray);
    }

    public void removeRows() {
        if (!this.vData.isEmpty()) {
            this.vData.removeAllElements();
            this.iRowCount = 0;
            this.adjustScroll();
            this.repaint();
        }
    }

    private void adjustScroll() {
        if (this.iRowHeight == 0) {
            return;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.iColCount) {
            n += this.iColWidth[n2];
            ++n2;
        }
        this.iGridWidth = n;
        this.iGridHeight = this.iRowHeight * (this.iRowCount + 1);
        this.sbHoriz.setValues(this.iX, this.iWidth, 0, this.iGridWidth + this.iRowHeadWidth);
        n2 = this.iY / this.iRowHeight;
        int n3 = this.iHeight / this.iRowHeight;
        this.sbVert.setValues(n2, n3, 0, this.iRowCount + 1);
        this.iX = this.sbHoriz.getValue();
        this.iY = this.iRowHeight * this.sbVert.getValue();
    }

    public boolean handleEvent(Event event) {
        switch (event.id) {
            case 601: 
            case 602: 
            case 603: 
            case 604: 
            case 605: {
                this.iX = this.sbHoriz.getValue();
                this.iY = this.iRowHeight * this.sbVert.getValue();
                this.repaint();
                return true;
            }
        }
        return super.handleEvent(event);
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        if (graphics == null) {
            return;
        }
        if (this.iWidth <= 0 || this.iHeight <= 0) {
            return;
        }
        graphics.setColor(Color.lightGray);
        graphics.fillRect(this.iWidth, this.iHeight, this.iSbWidth, this.iSbHeight);
        if (this.iImage == null) {
            this.iImage = this.createImage(this.iWidth, this.iHeight);
            this.gImage = this.iImage.getGraphics();
            if (this.fMetrics == null) {
                this.fMetrics = this.gImage.getFontMetrics();
            }
        }
        this.gImage.setFont(this.fFont);
        if (this.iRowHeight == 0) {
            this.iRowHeight = this.fMetrics.getHeight() + 2;
            n2 = 0;
            while (n2 < this.iColCount) {
                this.calcAutoWidth(n2);
                ++n2;
            }
            this.adjustScroll();
        }
        this.gImage.setColor(Color.white);
        this.gImage.fillRect(0, 0, this.iWidth, this.iHeight);
        this.gImage.setColor(Color.darkGray);
        this.gImage.drawLine(0, this.iRowHeight, this.iWidth, this.iRowHeight);
        n2 = -this.iX + this.iRowHeadWidth;
        int n3 = 0;
        while (n3 < this.iColCount) {
            n = this.iColWidth[n3];
            this.gImage.setColor(Color.lightGray);
            this.gImage.fillRect(n2 + 1, 0, n - 2, this.iRowHeight);
            this.gImage.setColor(Color.black);
            this.gImage.drawString(this.sColHead[n3], n2 + 2, this.iRowHeight - 5);
            this.gImage.setColor(Color.darkGray);
            this.gImage.drawLine(n2 + n - 1, 0, n2 + n - 1, this.iRowHeight - 1);
            this.gImage.setColor(Color.white);
            this.gImage.drawLine(n2 + n, 0, n2 + n, this.iRowHeight - 1);
            n2 += n;
            ++n3;
        }
        this.gImage.setColor(Color.lightGray);
        this.gImage.fillRect(0, 0, this.iRowHeadWidth + 1, this.iRowHeight);
        this.gImage.fillRect(n2 + 1, 0, this.iWidth - n2, this.iRowHeight);
        this.gImage.drawLine(0, 0, 0, this.iRowHeight - 1);
        n3 = this.iRowHeight + 1 - this.iY;
        n = 0;
        while (n3 < this.iRowHeight + 1) {
            ++n;
            n3 += this.iRowHeight;
        }
        this.iFirstRow = n;
        n3 = this.iRowHeight + 1;
        while (n3 < this.iHeight && n < this.iRowCount) {
            n2 = -this.iX + this.iRowHeadWidth;
            int n4 = 0;
            while (n4 < this.iColCount) {
                int n5 = this.iColWidth[n4];
                Color color = Color.white;
                Color color2 = Color.black;
                if (this.iSelectRow == n) {
                    color = Color.black;
                    color2 = Color.white;
                }
                this.gImage.setColor(color);
                this.gImage.fillRect(n2, n3, n5 - 1, this.iRowHeight - 1);
                this.gImage.setColor(color2);
                this.gImage.drawString(this.getDisplay(n4, n), n2 + 2, n3 + this.iRowHeight - 5);
                this.gImage.setColor(Color.lightGray);
                this.gImage.drawLine(n2 + n5 - 1, n3, n2 + n5 - 1, n3 + this.iRowHeight - 1);
                this.gImage.drawLine(n2, n3 + this.iRowHeight - 1, n2 + n5 - 1, n3 + this.iRowHeight - 1);
                n2 += n5;
                ++n4;
            }
            this.gImage.setColor(Color.white);
            this.gImage.fillRect(n2, n3, this.iWidth - n2, this.iRowHeight - 1);
            if (this.iRowHeadWidth != 0) {
                this.gImage.setColor(Color.lightGray);
                this.gImage.fillRect(0, n3, this.iRowHeadWidth, this.iRowHeight - 1);
                this.gImage.setColor(Color.black);
                String string = (String)this.vRowHead.elementAt(n);
                this.gImage.drawString(string, 2, n3 + this.iRowHeight - 5);
                this.gImage.setColor(Color.darkGray);
                this.gImage.drawLine(0, n3 + this.iRowHeight - 1, this.iRowHeadWidth - 1, n3 + this.iRowHeight - 1);
                this.gImage.drawLine(this.iRowHeadWidth - 1, n3, this.iRowHeadWidth - 1, n3 + this.iRowHeight - 1);
                this.gImage.setColor(Color.white);
                this.gImage.drawLine(0, n3, this.iRowHeadWidth - 2, n3);
            }
            ++n;
            n3 += this.iRowHeight;
        }
        graphics.drawImage(this.iImage, 0, 0, this);
        this.showText();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public boolean keyDown(Event event, int n) {
        int n2 = this.iSelectRow;
        int n3 = this.iSelectColumn;
        if (n2 < 0 || n2 >= this.iRowCount) {
            return false;
        }
        switch (n) {
            case 9: {
                n3 = (event.modifiers & 1) != 0 ? --n3 : ++n3;
                if (n3 < 0) {
                    n3 = 0;
                }
                if (n3 >= this.iColCount) {
                    n3 = this.iColCount - 1;
                }
                this.select(n2, n3);
                return true;
            }
            case 1004: {
                if (n2 > 0) {
                    this.select(n2 - 1, n3);
                }
                return true;
            }
            case 10: 
            case 1005: {
                if (n2 < this.iRowCount - 1) {
                    this.select(n2 + 1, n3);
                }
                return true;
            }
            case 27: {
                this.iSelectRow = -1;
                this.select(n2, n3);
                this.repaint();
                return true;
            }
        }
        return false;
    }

    public boolean mouseMove(Event event, int n, int n2) {
        if (n2 <= this.iRowHeight) {
            int n3 = n;
            n = n + this.iX - this.iGridWidth - this.iRowHeadWidth;
            int n4 = this.iColCount - 1;
            while (n4 >= 0) {
                if (n > -7 && n < 7) break;
                n += this.iColWidth[n4];
                --n4;
            }
            if (n4 >= 0) {
                if (!this.bDrag) {
                    this.setCursor(new Cursor(11));
                    this.bDrag = true;
                    this.iXDrag = n3 - this.iColWidth[n4];
                    this.iColDrag = n4;
                }
                return true;
            }
        }
        return this.mouseExit(event, n, n2);
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        if (this.bDrag && n < this.iWidth) {
            int n3 = n - this.iXDrag;
            if (n3 < 0) {
                n3 = 0;
            }
            this.iColWidth[this.iColDrag] = n3;
            this.adjustScroll();
            this.repaint();
        }
        return true;
    }

    public boolean mouseExit(Event event, int n, int n2) {
        if (this.bDrag) {
            this.setCursor(new Cursor(0));
            this.bDrag = false;
        }
        return true;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (this.iRowHeight == 0 || n > this.iWidth || n2 > this.iHeight) {
            return true;
        }
        n += this.iX - this.iRowHeadWidth;
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.iColCount) {
            int n5 = this.iColWidth[n4];
            if (n >= 0 && n <= n5) {
                n3 = n4;
                break;
            }
            n -= n5;
            ++n4;
        }
        if (n2 > this.iRowHeight) {
            n4 = n2 / this.iRowHeight - 1 + this.iFirstRow;
            if (n4 >= 0 && n4 < this.iRowCount) {
                this.select(n4, n3);
                if (this.cCallback != null) {
                    Event event2 = new Event(this.cCallback, 1001, String.valueOf("").concat(String.valueOf(this.iSelectRow)));
                    this.cCallback.action(event2, String.valueOf("").concat(String.valueOf(this.iSelectRow)));
                }
            }
        } else if (!this.bDrag) {
            this.sort(n3);
        }
        return true;
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getgetPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getgetMinimumSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        return this.dMinimum;
    }

    private void calcAutoWidth(int n) {
        int n2 = 10;
        this.iRowHeadWidth = 0;
        n2 = Math.max(n2, this.fMetrics.stringWidth(this.sColHead[n]));
        int n3 = 0;
        while (n3 < this.iRowCount) {
            String[] stringArray = (String[])this.vData.elementAt(n3);
            n2 = Math.max(n2, this.fMetrics.stringWidth(stringArray[n]));
            String string = (String)this.vRowHead.elementAt(n3);
            this.iRowHeadWidth = Math.max(this.iRowHeadWidth, this.fMetrics.stringWidth(string) + 6);
            ++n3;
        }
        this.iColWidth[n] = n2 + 6;
    }

    public void sort(int n) {
        this.select(-1, 0);
        int n2 = this.iRowCount;
        int n3 = 1;
        while (n3 < n2 && this.get(n, n3 - 1).compareTo(this.get(n, n3)) <= 0) {
            ++n3;
        }
        if (n3 == n2) {
            return;
        }
        n3 = (n2 >> 1) - 1;
        while (n3 > 0) {
            this.siftup(n3, n2 - 1, n);
            --n3;
        }
        n3 = n2 - 1;
        while (n3 > 0) {
            this.siftup(0, n3, n);
            String[] stringArray = (String[])this.vData.elementAt(0);
            this.vData.setElementAt(this.vData.elementAt(n3), 0);
            this.vData.setElementAt(stringArray, n3);
            --n3;
        }
    }

    private void siftup(int n, int n2, int n3) {
        Object e = this.vData.elementAt(n);
        String string = this.get(n3, n);
        int n4 = n;
        int n5 = n + n + 1;
        while (n5 < n2) {
            if (this.get(n3, n5).compareTo(this.get(n3, n5 + 1)) < 0) {
                ++n5;
            }
            this.vData.setElementAt(this.vData.elementAt(n5), n);
            n = n5;
            n = n5;
            n5 = n + n5 + 1;
        }
        if (n5 == n2) {
            this.vData.setElementAt(this.vData.elementAt(n5), n);
            n = n5;
        }
        n5 = n - 1 >> 1;
        while (n5 >= n4 && this.get(n3, n5).compareTo(string) < 1) {
            this.vData.setElementAt(this.vData.elementAt(n5), n);
            n = n5;
            n5 = n - 1 >> 1;
        }
        this.vData.setElementAt(e, n);
    }

    private void select(int n, int n2) {
        if (this.iSelectRow >= 0 && this.iSelectRow < this.iRowCount) {
            this.set(this.iSelectColumn, this.iSelectRow, this.tEdit.getText());
        }
        this.iSelectRow = n;
        this.iSelectColumn = n2;
        if (n < 0 || n >= this.iRowCount || n2 < 0 || n2 >= this.iColCount) {
            this.iSelectRow = -1;
            this.iSelectColumn = 0;
        }
        this.tEdit.setVisible(false);
        this.bEditing = false;
        if (this.iSelectRow >= 0) {
            while (this.iSelectRow < this.iFirstRow && this.iFirstRow > 0) {
                --this.iFirstRow;
                this.iY -= this.iRowHeight;
            }
            while (this.iSelectRow > this.iFirstRow - 2 + this.iHeight / this.iRowHeight && this.iFirstRow < this.iRowCount - 1) {
                ++this.iFirstRow;
                this.iY += this.iRowHeight;
            }
            this.calcEditPos();
            if (this.iEditX > this.iWidth) {
                this.iX += this.iEditX - this.iWidth;
                this.calcEditPos();
            }
            if (this.iEditX + this.iEditWidth > this.iWidth) {
                this.iX += this.iEditX + this.iEditWidth - this.iWidth;
                this.calcEditPos();
            }
            if (this.iEditX < this.iRowHeadWidth) {
                this.iX += this.iEditX - this.iRowHeadWidth;
                this.calcEditPos();
            }
            this.tEdit.setText(this.get(this.iSelectColumn, this.iSelectRow));
            this.adjustScroll();
        }
        this.repaint();
    }

    private void calcEditPos() {
        int n = -this.iX;
        int n2 = 0;
        while (n2 < this.iSelectColumn) {
            int n3 = this.iColWidth[n2];
            n += n3;
            ++n2;
        }
        this.iEditY = (this.iSelectRow - this.iFirstRow + 1) * this.iRowHeight;
        n2 = 0;
        if (this.iColWidth != null) {
            n2 = this.iColWidth[this.iSelectColumn];
        }
        this.iEditX = n + this.iRowHeadWidth;
        this.iEditWidth = n2;
    }

    private void showText() {
        this.calcEditPos();
        int n = this.iEditX;
        int n2 = this.iEditY;
        int n3 = this.iEditWidth;
        n3 = Math.min(n3, this.iWidth - n);
        if (n < 0) {
            n3 += n;
            n = 0;
        }
        if (this.iSelectRow >= 0 && n3 > 0 && n2 >= this.iRowHeight && n2 < this.iHeight - this.iRowHeight) {
            this.tEdit.setBounds(n, n2, n3, this.iRowHeight);
            if (!this.bEditing) {
                this.tEdit.setVisible(true);
                this.tEdit.requestFocus();
                this.tEdit.selectAll();
                this.bEditing = true;
            }
        } else if (this.bEditing) {
            this.tEdit.setVisible(false);
            this.bEditing = false;
        }
    }

    private String getDisplay(int n, int n2) {
        return ((String[])this.vData.elementAt(n2))[n];
    }

    private String get(int n, int n2) {
        return ((String[])this.vData.elementAt(n2))[n];
    }

    private void set(int n, int n2, String string) {
        String[] stringArray = (String[])this.vData.elementAt(n2);
        stringArray[n] = string;
    }
}

