/*
 * DicomDic.java - Dicom(Dicom.dict@C)ǂݍŃ^OŌł悤ɂ
 *
 * Copyright(C) 2000, Nagoya Institute of Technology, Iwata laboratory and Takahiro Katoji
 * http://mars.elcom.nitech.ac.jp/dicom/
 *
 * @author	Takahiro Katoji(mailto:katoco@mars.elcom.nitech.ac.jp)
 * @version
 *
 * @param   dicURL Dicom݂URL
 *
 */

package dicomviewer;

import java.io.*;
import java.util.*;
import java.net.*;

public class DicomDic {

  int             debug_level = 3;

  Hashtable				table = new Hashtable();  // f[^i[

  // RXgN^
  public DicomDic(String dicURL) {
    // fobOp
    if (debug_level > 3) System.out.println("Now Loading DicomDic from " + dicURL +"...");
    InputStream     inS;
    BufferedReader	din;
    StringTokenizer tkn;
    try{
      // fobOp
      if (debug_level > 3) System.out.println("Now Making Resive Stream....");
      if(dicURL.equals("none")) {
        // Jart@C̒ɂDicomQƂ
        inS = this.getClass().getResourceAsStream("Dicom.dic");
      }else {
        // URL\PbgAURL玫Ă
        URL urlConn = new URL(dicURL);
        inS = urlConn.openStream();
      }

      // MXg[̐ݒ
      din = new BufferedReader(new InputStreamReader(inS));
      String line_str;
      int j=0;

      // t@C1sAŌ܂œǂ
      while((line_str = din.readLine())!=null){

        // s̐擪#̏ꍇ̓RgƂēǂݔ΂
        if(line_str.startsWith("#")!=true){
          j++;
				  //HashtableɁAL[^O(String)AlDicomvalueIuWFNgƂē
				  String tag = null;
				  Dicomvalue dicomvalue = new Dicomvalue();
          tkn = new StringTokenizer(line_str);
          tag = tkn.nextToken();
          // fobOp
          if (debug_level > 5) System.out.println("Tag  : " + tag);
          dicomvalue.vr = tkn.nextToken();
          // fobOp
          if (debug_level > 5) System.out.println("VR   : " + dicomvalue.vr);
          dicomvalue.name = tkn.nextToken();
          // fobOp
          if (debug_level > 5) System.out.println("Name : " + dicomvalue.name);
          dicomvalue.vm = tkn.nextToken();
          // fobOp
          if (debug_level > 5) System.out.println("VM   : " + dicomvalue.vm);
          dicomvalue.version =tkn.nextToken();
          // fobOp
          if (debug_level > 5) System.out.println("Ver. : " + dicomvalue.version);
				  table.put(tag, dicomvalue);
        }
      }
      din.close();
    }
    catch(EOFException eof){
      System.out.println("EOFException: " + eof.getMessage() );
    }
    catch(IOException ioe){
      System.out.println("IOException: " + ioe.getMessage() );
    }
    catch(Exception e){
    	System.out.println("Exception: " + e.getMessage() );
    }
  }

  // ȉIuWFNg̒lԂ
  public String getName(String tag) {
    return ((Dicomvalue)table.get(tag)).name;
  }

  public String getVR(String tag) {
    return ((Dicomvalue)table.get(tag)).vr;
  }

  public String getVM(String tag) {
    return ((Dicomvalue)table.get(tag)).vm;
  }

  public String getVersion(String tag) {
    return ((Dicomvalue)table.get(tag)).version;
  }

  // f[^Ƀ^O܂܂邩ׂ
  public boolean isContain(String tag) {
    return table.containsKey(tag);
  }

  // nbVe[u̒lƂȂIuWFNg
  class Dicomvalue {
    String name;		//^Oɑ΂閼O
    String vr;			//VR
    String vm;			//VM
    String version;	//DicomVersion
  }
}


