/*
 * ImageData.java - 摜̏ێĂIuWFNg
 *
 * Copyright(C) 2000, Nagoya Institute of Technology, Iwata laboratory and Takahiro Katoji
 * http://mars.elcom.nitech.ac.jp/dicom/
 *
 * @author	Takahiro Katoji(mailto:katoco@mars.elcom.nitech.ac.jp)
 * @version
 *
 */

package dicomviewer;

import java.awt.*;
import java.awt.image.*;

public class ImageData {

  int     debug_level = 3;

  boolean	blackANDwhite = true;				// 摜̎true
  boolean rgbMode = false;            // Dicom RGB -> true
  boolean	inv = false;								// lK|W]
  int			pixel[];										// 摜̊esNZ
  int			orgPixel[];									// IWỉfl
  int     pixLength;                  // IWisNZ̒
  int			pixelMin;										// 摜ŏl
  int			pixelMax;										// 摜ől
  int			width;											// C[W
  int			height;											// C[W
  int			histogram[] = new int[256];	// qXgO
  int			histMax;										// qXgO̍ő吔
  int			ww,wl;          						// WW/WL

  // ̏
  int			defaultPixel[];							// ̉fl
  int			defaultWidth;								// ̃C[W
  int			defaultHeight;							// ̃C[W
  int     defaultWW, defaultWL;       // WW/WL

  Image   image;
  Toolkit toolkit;
  MemoryImageSource source;

  // DicomDataeϐɒlZbg
  public void setData(DicomData dicomData) {
    // fobOp
    if (debug_level > 3) System.out.println("Now set width and height....");
    // DicomDataC[W̕ƍ߂
    // String^int^ɃLXgĂ
    width		= Integer.parseInt(dicomData.getAnalyzedValue("(0028,0011)"));
    height	= Integer.parseInt(dicomData.getAnalyzedValue("(0028,0010)"));
    defaultWidth = width;
    defaultHeight = height;
    // fobOp
    if (debug_level > 3) System.out.println("Image width  : " + width);
    if (debug_level > 3) System.out.println("Image heigth : " + height);

    // fobOp
    if (debug_level > 3) System.out.print("Now set byte[] to int[]....");
    // DicomDatảflbyte[]int[]ɕϊ
    orgPixel        = new int[width * height];
    pixLength       = orgPixel.length;
    pixel           = new int[pixLength];
    defaultPixel    = new int[pixLength];
    byte[] tmpValue = new byte[dicomData.getValue("(7fe0,0010)").length];
    System.arraycopy(dicomData.getValue("(7fe0,0010)"), 0, tmpValue, 0, tmpValue.length);
    // fobOp
    if (debug_level > 3) System.out.println(" OK!");

    // ݃T|[gĂ̂,
    // (0028,0004)Photometric Interpretation RGB
    if(dicomData.isContain("(0028,0004)") &&
        dicomData.getAnalyzedValue("(0028,0004)").trim().equals("RGB")) {
      rgbMode = true;
      for(int i=0; i<pixLength; i++){
        orgPixel[i] = ((255 << 24) |
                       (0xff & tmpValue[3*i]) << 16 |
                       (0xff & tmpValue[(3*i)+1]) << 8 |
                       (0xff & tmpValue[(3*i)+2]) );
      }
    // ́AMONOCHROME2̂ƂB
    } else {
      // 蓖ărbg16bit̎
      if(dicomData.getAnalyzedValue("(0028,0100)").trim().equals("16")) {
        short shValue = 0;
        for(int i=0; i<pixLength; i++){
          shValue = (short)((0xff & tmpValue[(2*i)+1]) << 8 |
                            (0xff & tmpValue[2*i]) );
          orgPixel[i] = (int)shValue;
        }
      // 蓖ărbg8bit̎
      }else {
        for(int i=0; i<pixLength; i++)
          orgPixel[i] = (int)(0xff & tmpValue[i]);
      }
      // i[rbgAʃrbg̕␳
      int bit_stored = Integer.parseInt(dicomData.getAnalyzedValue("(0028,0101)"));
      int bit_hight  = Integer.parseInt(dicomData.getAnalyzedValue("(0028,0102)"));
      int bit_gap    = bit_hight - bit_stored +1;
      if(bit_gap > 0) {
        for(int i=0; i<pixLength; i++) orgPixel[i] = (orgPixel[i] >> bit_gap);
      }
    }

    // Ԃ̕ۑ
    System.arraycopy(orgPixel, 0, defaultPixel, 0, pixLength);
    
    tmpValue = null;

    // fobOp
    if (debug_level > 3) System.out.print("Now set pixelMin and pixelMax....");
    // 摜̍őlƍŏl߂B
    pixelMin = 0;
    pixelMax = 0;
    for(int i=0; i<pixLength; i++){
      if(pixelMin > orgPixel[i])
      	pixelMin = orgPixel[i];
      if(pixelMax < orgPixel[i])
      	pixelMax = orgPixel[i];
    }
    // fobOp
    if (debug_level > 3) System.out.println(" OK!");

    // fobOp
    if (debug_level > 3) System.out.print("Now set WW/WL....");
    // ftHgWW^WL̐ݒ
    // DICOMf[^̒WW/WLƂ́A̒lgB
    if(dicomData.isContain("(0028,1051)")) {
      try {
        ww = Integer.parseInt(dicomData.getAnalyzedValue("(0028,1051)").replace('+', ' ').trim());
      }catch(NumberFormatException e) {
        // ܂loȂƂ́AvZŋ߂B
        ww = pixelMax - pixelMin;
      }
    } else {
      ww = pixelMax - pixelMin;
    }
    if(dicomData.isContain("(0028,1050)")) {
      try {
        wl = Integer.parseInt(dicomData.getAnalyzedValue("(0028,1050)").replace('+', ' ').trim());
      }catch(NumberFormatException e) {
        // ܂loȂƂ́AvZŋ߂B
        wl = (ww >> 1) + pixelMin;
      }
    } else {
      wl = (ww >> 1) + pixelMin;
    }
    defaultWW = ww;
    defaultWL = wl;
    // fobOp
    if (debug_level > 3) System.out.println(" OK!");
    if (debug_level > 3) System.out.println("WW :" + ww + " WL :" + wl);

    // ̃C[WĂB
    for(int i=0; i < pixel.length; i++) pixel[i] = 0xff000000;
    source = new MemoryImageSource(width, height, pixel, 0, width);
    source.setAnimated(true);
    toolkit = Toolkit.getDefaultToolkit();
    image = toolkit.createImage(source);
  }

  // WW/WĽvZ,J[̐ݒ,lK|W]
  private void contrast() {

    // RgXgωуJ[ωB
    if(!rgbMode){
      //int tmp = (int)(ww * 0.5);
      int tmp = ww >> 1;
      int contrastMin = wl - tmp;
      int contrastMax = wl + tmp;

      if(blackANDwhite) {
    	  // 摜
        double invWW = 255d / (double)ww;
        int pix;

        for(int i=0; i<pixLength; i++){
          pix = orgPixel[i];
          if(pix <= contrastMin) pix = 0;
          else if(pix >= contrastMax) pix = 255;
          else
            // ꂪ
            // pix = (int)Math.round((255*(pix - contrastMin))/ww);
        	  pix = (int)((pix - contrastMin) * invWW);
          pixel[i] = (0xff000000 | (pix << 16) | (pix << 8) | pix);
          // lK|W]
          if(inv) pixel[i] = ((~pixel[i] & 0x00ffffff) | (pixel[i] & 0xff000000));
        }
      }else {
        // [J[
        float invWW = 0.67f / (float)ww;
        int pminWW = ww + contrastMin;
        int pix;
        float hue;

        for(int i=0; i<pixLength; i++){
          pix = orgPixel[i];
          if(pix <= contrastMin) hue = 0.67f;     // (F:4/6)
          else if(pix >= contrastMax) hue = 0.0f; // Ԃ܂
          else
            // ꂪ
            // hue = (1.0f - (pix - contrastMin)/ww) * 0.67f;
            hue = (float)(pminWW - pix) * invWW;
          pixel[i] = hue2RGB(hue);
          // lK|W]
          if(inv) pixel[i] = ((~pixel[i] & 0x00ffffff) | (pixel[i] & 0xff000000));
        }
      }
    }else {
      // Dicom RGB ModêƂ
      System.arraycopy(orgPixel, 0, pixel, 0, pixel.length);
    }
  }

  /**
   * HSB(ʓxƖx1.0Ƃ)RGBJ[郁\bh
   *
   * HSB
   *      0     1/6     2/6     3/6     4/6     5/6     1
   * F |------|-------|-------|-------|-------|------|
   *                     VA       }[^
   *      0                                             1
   * ʓx |---------------------------------------------|
   *      O[    W          ȐF
   *      0                                             1
   * x |---------------------------------------------|
   *              Â          邢
   *
   * @param hue - F
   * @see   java.awt.Color#HSBtoRGB(float, float, float)
   */
  private int hue2RGB(float hue) {
	  int r = 0, g = 0, b = 0;

    float h = (hue - (float)Math.floor(hue)) * 6.0f;
    float f = h - (float)java.lang.Math.floor(h);
    float q = 1.0f - f;

    switch ((int) h) {
	    case 0:
        r = 255;
		    g = (int) (f * 255.0f + 0.5f);
		    b = 0;
		    break;
	    case 1:
		    r = (int) (q * 255.0f + 0.5f);
		    g = 255;
		    b = 0;
		    break;
	    case 2:
		    r = 0;
		    g = 255;
		    b = (int) (f * 255.0f + 0.5f);
		    break;
	    case 3:
		    r = 0;
		    g = (int) (q * 255.0f + 0.5f);
		    b = 255;
		    break;
	    case 4:
		    r = (int) (f * 255.0f + 0.5f);
		    g = 0;
		    b = 255;
		    break;
	    case 5:
		    r = 255;
		    g = 0;
		    b = (int) (q * 255.0f + 0.5f);
		    break;
    }
	  return 0xff000000 | (r << 16) | (g << 8) | (b << 0);
  }

  private Image getImage() {
    // sNZlύXāAImageԂB
    source.newPixels();
    return image;
/*
    // C[WԂB
    Toolkit toolkit = Toolkit.getDefaultToolkit();
    return toolkit.createImage(new MemoryImageSource(width, height, pixel, 0, width));
*/
  }

  // ݂̃ftHgԂ̃C[WԂ
  public Image getDefaultImage() {
    contrast();
    return getImage();
  }

  // ,J[̏ԂԂ(J[̂Ƃtrue)
  public boolean color() {
    return rgbMode;
  }

  // WW/WLC[Wɔf
  public Image wwANDwl(int argWW, int argWL) {
    ww = argWW;
    wl = argWL;
    contrast();
    return getImage();
  }

  // WW/WL̒lZbg
  public void setWwWl(int argWW, int argWL) {
    ww = argWW;
    wl = argWL;
  }

  // Default̍𓾂āAWW/WLC[Wɔf
  public Image getImageWWWL2Current(int argWW, int argWL) {
    ww = defaultWW + argWW;
    wl = defaultWL + argWL;
    contrast();
    return getImage();
  }

  // WW^WLԂ
  public int getWW() {
    return ww;
  }
  public int getWL() {
    return wl;
  }

  // ftHgWW^WLԂ
  public int getDefaultWW() {
    return defaultWW;
  }
  public int getDefaultWL() {
    return defaultWL;
  }

  // C[W,Ԃ
  public int getWidth() {
    return width;
  }
  public int getHeight() {
    return height;
  }

  // Pixell̍őlAŏlԂ
  public int getPixelMin() {
    return pixelMin;
  }
  public int getPixelMax() {
    return pixelMax;
  }

  // lK|W]
  public void inverse() {
    inv = !inv;
  }
  public void setInverse(boolean flag) {
    inv = flag;
  }
/*
  public Image inverse() {
    inv = !inv;
    contrast();
    return getImage();
  }
*/

  // [J[
  public void setColor(boolean flag) {
    blackANDwhite = !flag;
  }
  public void changeColor() {
    blackANDwhite = !blackANDwhite;
  }

  // Ԃɖ߂B(WW/WLȊO)
  public void setDefaultPixel() {
    System.arraycopy(defaultPixel, 0, orgPixel, 0, pixLength);
    width =  defaultWidth;
    height = defaultHeight;

    blackANDwhite = true;				// 摜̎true
    inv = false;								// lK|W]
  }

  // 90x摜]
  public void rotateL() {
    int[] tmpPixel = new int[orgPixel.length];
    int temp;

    System.arraycopy(orgPixel, 0, tmpPixel, 0, tmpPixel.length);
    for(int i=0; i < height; i++) {
      for(int j=0; j < width; j++) {
        orgPixel[(width - j -1) * height + i] = tmpPixel[i * width + j];
      }
    }
    temp = width;
    width = height;
    height = temp;
  }
  public void rotateR() {
    int[] tmpPixel = new int[orgPixel.length];
    int temp;

    System.arraycopy(orgPixel, 0, tmpPixel, 0, tmpPixel.length);
    for(int i=0; i < height; i++) {
      for(int j=0; j < width; j++) {
        orgPixel[j * height + (height - i -1)] = tmpPixel[i * width + j];
      }
    }
    temp = width;
    width = height;
    height = temp;
  }

  // E摜]
  public void flipLR() {
    int[] tmpPixel = new int[orgPixel.length];
    int temp1, temp2;

    System.arraycopy(orgPixel, 0, tmpPixel, 0, tmpPixel.length);
    for(int i=0; i < height; i++) {
      temp1 = i * width;
      temp2 = temp1 + width -1;
      for(int j=0; j < width; j++) {
        orgPixel[temp2 - j] = tmpPixel[temp1 + j];
      }
    }
  }

  // ㉺摜]
  public void flipUD() {
    int[] tmpPixel = new int[orgPixel.length];
    int temp1, temp2;

    System.arraycopy(orgPixel, 0, tmpPixel, 0, tmpPixel.length);
    for(int i=0; i < height; i++) {
      temp1 = (height - i -1) * width;
      temp2 = i * width;
      for(int j=0; j < width; j++) {
        orgPixel[temp1 + j] = tmpPixel[temp2 + j];
      }
    }
  }

  // qXgO̍쐬
  private void makeHistogram()
  {
    // 
    for(int i=0; i<256; i++)
    	histogram[i] = 0;
    histMax = 0;

    // qXgO̍쐬
    for(int i=0; i<pixel.length; i++){
      int data = (0x000000ff & pixel[i]);
      histogram[data]++;
    }

    // qXgO̍ő吔߂
    for(int i=0; i<256; i++){
      if(histMax < histogram[i])
      	histMax = histogram[i];
    }
  }

  // qXgO,qXgO̍őlԂ
  public int[] getHistogram()
  {
    return histogram;
  }

  public int getHistMax()
  {
    return histMax;
  }

  // qXgO̕␳
  public Image reviseHistogram()
  {
    calcRevisedHistogram();
    return getImage();
  }

  // qXgO̕␳vZ
  private void calcRevisedHistogram(){
    double[]	aFreq 				= new double[256];        // ݐϓx
    int				sum   				= 0;                      // qXgO̘a
    double		allPixelsInv; 				                  // 1./Sf
    double		vmin;                 				          // ݐϓx̍ŏl
    double		vminInv;
    int[]			fixed 				= new int[256];           // ␳ꂽqXgO

    // qXgO
    makeHistogram();

    for(int i=0; i<pixel.length; i++){
      pixel[i] = (0x000000ff & pixel[i]); 						// Ƃ肠l
    }

    // ݐϓx̌vZ
    allPixelsInv = 1. / (height * width);
    for(int i=0; i<256; i++){
      sum += histogram[i];
      aFreq[i] = (double)sum * allPixelsInv;
    }

    // qXgO̕␳
    vmin = aFreq[0];
    vminInv = (double)255. / (1.- vmin);
    for(int i=0; i<256; i++){
      fixed[i] = (int)((aFreq[i] - vmin) * vminInv);
    }
    for(int i=0; i<pixel.length; i++){
      pixel[i] = ((255 << 24)
      				  | (fixed[pixel[i]] << 16)
                | (fixed[pixel[i]] << 8)
                | fixed[pixel[i]]);
    }
  }
}
