# Simplejobscript - free job board software

Scripts allows users to create out of the box working job board website. More info at [simplejobscript.com](https://simplejobscript.com).

![Product screenshot](https://simplejobscript.com/wp-content/uploads/free/sjs_screen.png)


## Features

installation module, clean and modern mobile responsive design, easy color / theme customization with color picker, job posting, moderation & statistics, company profiles & dashboard, job applications & management (review / reject job seekers),  job alerts & cron job newsletter script, built in widely used PHP & MySQL + HTML / CSS / JS, lightweight extendable source code, custom job types, categories and locations, admin CMS module / content management system, AJAX filters & search, template caching system, RSS & Sitemap generator, static pages CMS, captcha anti-spam module, database cleaner module, data feeder module, SEO manager, social media share buttons, report job feature,  landing page, contact page with Google Maps integrated.


## Product versions

There are 2 versions of the product. Complete software demo can be seen [online](https://demo.simplejobscript.com/).

Complete version includes premium plugins that have been developed: Job seeker profiles & 1 click job applications, Talent database, PayPal gateway integration & auto invoicing, Pricing plans to sell job and resume packages, Indeed jobs backfill & live search, Banner & Google Adsense manager

Base version that resides here on Github is a complete out of the box working job board that can be downloaded and used forever completely free. This version does not includes the premium plugins. Premium plugins and complete product have been developed to generate some revenue needed to keep the project alive so we can work and improve it.


## Getting started

All you need is a domain name and hosting for a standard website.


## Technical requirements

PHP 5+, mod_rewrite, mbstring and GD modules, MySQL 4.1+ or MariaDB, Apache or Nginx web server.


## Installation

a) Install from Github
	
Clone the git repository. Download additional folders [here](https://simplejobscript.com/wp-content/uploads/free/sjs-git.zip). These are mostly libraries and assets that we keep out of the git versioning. Next proceed with installation by following our [guide](https://simplejobscript.com/docs/installation-guide/).

b) Install from site

Download the software from [product pages](https://simplejobscript.com/downloads/simplejobscript-base/) and install it by following our [guide](https://simplejobscript.com/docs/installation-guide/).


### General install steps

1. Copy content of "upload" folder to your server

2. Open job board URL and type in project details

3. Create database for your site and finish the installation in the browser


## License

This project is licensed under the [MIT License](https://github.com/Microsoft/calculator/blob/master/LICENSE) - see the [LICENSE](LICENSE) file for details.


## Current version

Simplejobscript Version 1.64


## Source code structure

Project is built with PHP & MySQL running in backend and HTML/CSS/Javascript running in frontened. For templating [SMARTY](https://www.smarty.net/) has been used. It runs on it's own small MVC (Model-View-Controller) PHP structure. More details can be found at our [pages](https://simplejobscript.com/code-structure/).


## Contributing

We encourage, appreciate and are very thankful for any help and contributions to the project. If you fixed any bug, developed a feature and would like to give back to the community and help all the future users you can submit a pull request or [contact us](https://simplejobscript.com/contact/) to discuss any details. At the moment we are aware the front-end design section of the job board (mainly CSS) needs code refactoring as multiple developers worked on it there are duplications that await a simplification. We can also consider placing a sponsorship link of your project on our pages or pay you for development.
