<?
/**********************************************************************************
 * rss.php
 * Version: 1.00
 * Author: Rogers Cadenhead
 * Date: 05/21/2004
 * http://www.cadenhead.org/workbench/
 *
 **********************************************************************************
 This program is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 PARTICULAR PURPOSE.

 This work is hereby released into the Public Domain. To view a copy of the public
 domain dedication, visit http://creativecommons.org/licenses/publicdomain/ or
 send a letter to Creative Commons, 559 Nathan Abbott Way, Stanford, California
 94305, USA.
 **********************************************************************************/



// Author:  Guru Consulting Services, Inc.
// Homepage:  http://www.phpforumscript.com
// (c) Copyright 2008.  All Rights Reserved.


include_once 'master_config.inc.php';
include_once 'db.class.inc.php';						// Database class
$db=new db($DB_LOCALHOST,$DB_DATABASE,$DB_USERNAME,$DB_PASSWORD);
$db1=new db($DB_LOCALHOST,$DB_DATABASE,$DB_USERNAME,$DB_PASSWORD);

// prepare HTML text for use as UTF-8 character data in XML
function cleanText($intext) {
	$intext=strip_tags($intext);
    return utf8_encode(htmlspecialchars(stripslashes($intext)));
}

// set the file's content type and character set
// this must be called before any output
header("Content-Type: text/xml;charset=utf-8");

$phpversion = phpversion();

// display RSS 2.0 channel information
ECHO <<<END
<?xml version="1.0" encoding="utf-8"?>
<rss version="2.0">
   <channel>
      <title>$SITE_NAME</title>
      <link>$SITE_URL</link>
      <description>$SITE_DESCRIPTION</description>
      <language>en-us</language>
      <docs>http://backend.userland.com/rss</docs>
      <generator>PHP/$phpversion</generator>
END;

// display latest posts in each category on the main page
$query="SELECT *, date_format(timestamp,'%a %m/%d/%Y %h:%i %p') as timestamp1 FROM discussion_message WHERE parent_id='0' ORDER BY lastpost_timestamp DESC LIMIT $MAX_LATEST_POSTS";
if($db->query($query)){
	for($loopindex=0;$loopindex<$db->rs_count;$loopindex++){
		$db->fetch($loopindex);
		if(strlen($db->row["message"])>$SUMMARY_MAX){
			$description=ereg_replace("\n\r"," ",substr(strip_tags($db->row["message"]),0,$SUMMARY_MAX)." ...");
		} else {
			$description=ereg_replace("\n\r"," ",$db->row["message"]);
		}
		$description=cleanText($description);
		$title=cleanText($db->row["subject"]);
		$link=$SITE_URL.'/'.($BASE_URL==''?'':$BASE_URL."/").$db->row["id"].'/'.str_replace(' ','_',$title);
		$id=$db->row["id"];
		$time_posted=date("r", strtotime($db->row["timestamp1"]));
		// display an item
		ECHO <<<END

				<item>
					<title>$title</title>
					<link>$link</link>
					<description>$description</description>
					<pubDate>$time_posted</pubDate>
					<guid isPermaLink="false">$id.$time_posted</guid>
				</item>
END;
	}
} else {
	echo "no posts found";
}

ECHO <<<END

   </channel>
</rss>
END;

?>