<?php

/*
 *	W-AGORA 4.1
 *	-----------
 *	$Id: browse.php,v 1.13 2003/03/03 16:31:49 mdruilhe Exp $
 *	Usage:	Browse the server
 *	Author:	Marc Druilhe <mdruilhe@w-agora.net>
 */

	$bn_action="browse";
	$bn_action_mode="L";

	include "init.inc";

	function browse_dir ($dir) {
		global $WA_SELF, $bn, $bn_browse_dir;
		global $icon_dir, $img_dir;

		if (file_exists($dir) && !is_dir($dir)) return (-1);

		if (!eregi ($bn_browse_dir, $dir)) return (-2);

		$dir = ereg_replace ("/$", "", $dir);

		$d = dir($dir);
		if (!$d) return (-2);


		while ($entry=$d->read() ) {
			$path = $dir."/".$entry;
			if ($entry == ".") {
				continue;
			} elseif ( is_dir($path) ) {
				$dirs[] = $entry;
			} else {
				$files[] = $entry;		
			}
		}
		$d->close();


		printf(TITLE_DIRECTORY, $dir);

		if (is_array($dirs)) {		
			sort ($dirs);
			reset($dirs);
			while( list(,$entry) = each($dirs) ) {
				if ($entry == "..") {
					$path = dirname($dir);
					if (eregi ($bn_browse_dir, $path)) {
						echo "<i><a href=\"$WA_SELF?bn=$bn&dir=" . urlencode($path)."\"><IMG SRC=\"$img_dir/back.gif\" ALT=\"[DIR]\" BORDER=0> $entry</a></i><br>\n";
					}
				} else {
					$path = $dir."/".$entry;
					echo "<i><a href=\"$WA_SELF?bn=$bn&dir=" . urlencode($path)."\"><IMG SRC=\"$img_dir/folder.gif\" ALT=\"[DIR]\" BORDER=0> $entry</a></i><br>\n";
				}
			}
		}

		if (is_array($files)) {		
			sort ($files);
			reset($files);
			while( list(,$entry) = each($files) ) {
				$path = $dir."/".$entry;
				$img = att_icon($entry);
				echo "<a href=\"$WA_SELF?bn=$bn&dir=" . urlencode($path) . "\">$img $entry</a><br>\n";
			}
		}
		
		return 0;
	}


	display_header (LABEL_BROWSE_SERVER, false);

	if (!$bn_browse_server) {
		msgForm (ERROR_NO_BROWSE_SERVER, "post.$ext", 'close');
		exit;
	}

	if (!$dir) {
		$dir = $bn_browse_dir;
	}

	$ret = browse_dir ($dir);
	if ($ret == -1) {
		beginForm();
		print '<center>';
		textField ('path', $dir, 50);
		print '<br>'. getButton ('', BUTTON_OPEN, "opener.document.form0.server_file.value='$dir';window.close()");
		backButton ('', BUTTON_BACK);
		print getButton ('', BUTTON_CANCEL, 'window.close()');
		print '</CENTER></FORM>';
		exit;
	} elseif ($ret == -2) {
		msgForm (sprintf(ERROR_ACCESS_DIRECTORY, $dir), $WA_SELF, 'back');
		exit;
	}

	beginForm();
	print '<center>';
	backButton ('', BUTTON_BACK);
	print '&nbsp;' . getButton ('', BUTTON_CANCEL, 'window.close()');
	print '</CENTER></FORM>';
	display_footer(false);
?>
