<?PHP

/*
 *	W-AGORA 4.0
 *	-----------
 *	$Id: close.php,v 1.14 2005/02/10 14:14:23 mdruilhe Exp $
 *	Usage:		[un]Close a thread in a forum
 *	Authors:	Raptor <XpL_Raptor@gmx.net>
 *				Marc Druilhe <mdruilhe@w-agora.net>
 *
 */

# initialization stuff
# --------------------
 	$bn_action="close";
	$bn_action_mode="W";
	include "./init.inc";

# if thread to close is not defined then return to the list
# --------------------------------------------------------
	if (!$key) {
		display_header (LABEL_CLOSE_THREAD, $header_footer);
		msgForm (ERROR_SPECIFY_THREAD, "list.$ext", "");
		display_footer ($header_footer);
	}

# Only the moderator of this board can close a thread
# ---------------------------------------------------
	if (!$is_moderator) {
		display_header (LABEL_CLOSE_THREAD, $header_footer);
		msgForm (ERROR_FORBIDDEN_ACCESS, "view.$ext?key=$key", "");
		display_footer ($header_footer);
	}

# read note in order to insure that this note exists and to get userid/password of the owner
# ---------------------------------------------------------------------------------------
	$note = $db->getNote ($bn_db, $key);
	if (!$note) {
		display_header (LABEL_CLOSE_THREAD, $header_footer);
		msgForm (sprintf(ERROR_NOTE_NOT_FOUND, $msg[0]), "list.$ext", "");
		display_footer ($header_footer);
	}

# delete FORM has been submitted -> do the stuff
# ----------------------------------------------
	if ($do_close) {
		
# Execute before_access program
# ------------------------------
		if (!empty($bn_before_access)) {
			if (file_exists ("$bn_dir/$bn_before_access") ) {
				include "$bn_dir/$bn_before_access";
			} else {
				include "$bn_dir_default/$bn_before_access";
			}
		} elseif (file_exists ("$bn_dir_default/before_access.$ext") ) {
			include ("$bn_dir_default/before_access.$ext");
		}

		display_header (LABEL_CLOSE_THREAD, $header_footer);

# Close the thread
# ----------------
		$thread=$note["thread"];
		if ($note["closed"]==0) {
			$ret = $db->setClosedThread ($bn_db, $thread, 1);
			$db->unSubscribeUser ($site, $bn_db, "", $thread);
			$success_msg = LABEL_THREAD_CLOSED;
		} else {
			$ret = $db->setClosedThread ($bn_db, $thread, 0);
			$success_msg = LABEL_THREAD_OPENED;
		}

		if ($ret < 0) {
			MsgForm (sprintf(ERROR_DATABASE, $ret), "list.$ext?bn=$bn", 'close');
			display_footer ($header_footer);
		}

# Displays success message then exit
# ----------------------------------
		print "<BR><BR>";
		MsgWarning ($success_msg);
		display_footer ($header_footer);

	} // do_delete

# do_delete not set => set all fields as global variables
# -------------------------------------------------------
	extract ($note);

# displays form (OK to delete)
# ----------------------------
	display_header (LABEL_CLOSE_THREAD, $header_footer);

	beginForm();
	hiddenField ("key", $key);
	if ($first != $key) {
		hiddenField ("first", $first);
	}
	hiddenField ("expnd", $expnd);
	hiddenField ("do_close", 1);

	if ($note["closed"]==0) {
		print LABEL_ASK_CLOSE_THREAD;
	} else {
		print LABEL_ASK_OPEN_THREAD;
	}

?>
 <CENTER>
  <INPUT TYPE="submit" VALUE="<?PHP echo BUTTON_SUBMIT?>">
  <INPUT TYPE="button" VALUE="<?PHP echo BUTTON_CANCEL?>" onClick="history.back()">
 </CENTER>
</FORM>
<HR SIZE=4>
<?PHP
# Display note and attachments (using template)
# ---------------------------------------------
	$viewkey = $key;
	include "$inc_dir/viewnote.$ext";

# Display footer
# --------------
	display_footer ($header_footer);
?>
