<?php

/*
 *	W-AGORA 4.0
 *	-----------
 *	$Id: delete_site.php,v 1.15 2003/07/25 22:31:08 mdruilhe Exp $
 *	 Usage:		Remove a complete site
 *	 Author:	Marc Druilhe <mdruilhe@w-agora.net>
 */

require ("init_admin.inc");

display_header (TITLE_SITE_DELETE);

# --------------------------------------------------
# check if this user is authorized to delete a site
# --------------------------------------------------
if ($auth->level < ROOT) {
	MsgForm (ERROR_NO_ROOT, "$WA_SELF?site=$site", 'back');
	echo "</body></html>";
	exit;
}

# ------------------------------------------------
# gets all forums in this site
# ------------------------------------------------
$forums = $db->listForums ($site);

# ---------------------------------------------
# FORM has been submitted -> delete this site
# ---------------------------------------------

if (isset($do_delete)) {

# Delete all forums from this site
# --------------------------------
	if (is_array($forums)) {
		reset($forums);
		$remove_site=true;	// set flag so that delete_forum won't stop
		while ( list (, $forum) = each ($forums) ) {
			$bn= $forum["bn_name"];
			include "delete_forum.$ext";
		}   
	}

# -----------------------------------------------------------------
# Now delete all tables and configuration files:
# -----------------------------------------------------------------

# drop table / delete DBM file for this site
# -------------------------------------------
	$ret = $db->deleteSite ($site);
	if ($ret < 0) {
			msgWarning (LABEL_NOTICE . " : " . str_replace("{SITE}", $site, ERROR_NO_DELETE));
	}

# ---------------------------------------------------------------------------------------
# Open a new DB connection for the main agora database
#		$agora_db = agora "system" database
#		$db = site database
# ---------------------------------------------------------------------------------------

	$agora_dbparam = getDBaccess('agora');
	$agora_access = $agora_dbparam["bn_access"];
	$agora_dbname = $agora_dbparam["dbname"];
	$agora_dbhost = $agora_dbparam["dbhost"];
	$agora_dbport = $agora_dbparam["dbport"];
	$agora_dbuser = $agora_dbparam["dbuser"];
	$agora_dbpassword = $agora_dbparam["dbpassword"];
	$agora_dbadmuser = $agora_dbparam["dbadmuser"];
	$agora_dbadmpassword = $agora_dbparam["dbadmpassword"];

	if ($agora_access != $bn_access) {
		include ("$inc_dir/$agora_access.$ext");
	}

	$db->closeDB();

	$agora_dbclass = "${agora_access}_access";
	$agora_db = new $agora_dbclass;
	$ret = $agora_db->openDB($agora_dbhost, $agora_dbport, $agora_dbadmuser, $agora_dbadmpassword, $agora_dbname, "agora");
	if ($ret < 0) {
		msgForm (ERROR_NO_DATABASE, "$WA_SELF", 'back');
		echo "</BODY>\n</HTML>";
		exit;
	}

# Delete entry in the site table (agora)
# --------------------------------------
	$agora_db->deleteForumEntry("agora", $site);	
	if ($ret < 0) {
		MsgForm (str_replace("{SITE}", $site, ERROR_NO_DELETE_AGORA), "$WA_SELF?site=$site", 'back');
	}

# Remove site directory 
# ---------------------
	include "$site_cfg_file";
	if (!empty($bn_dir_default) && is_dir($bn_dir_default)) {
		$dir = opendir("$bn_dir_default");
		while ( $entry = readdir($dir) ) {
			if ( ($entry != ".") && ($entry != "..") ) {
				echo LABEL_FILE_REMOVING  . "<b>$bn_dir_default/$entry</b><br>";
				unlink ("$bn_dir_default/$entry");
			}
		}
		closedir($dir);
		echo LABEL_DIRECTORY_REMOVING . "<b>$bn_dir_default</b><br>";
		rmdir ("$bn_dir_default");
	}

	if (!empty($bn_dir) && is_dir($bn_dir)) {
		$dir = opendir("$bn_dir");
		while ( $entry = readdir($dir) ) {
			if ( ($entry != ".") && ($entry != "..") ) {
				echo LABEL_FILE_REMOVING . "<b>$bn_dir/$entry</b><br>";
				unlink ("$bn_dir/$entry");
			}
		}
		closedir($dir);
		echo LABEL_DIRECTORY_REMOVING . "<b>$bn_dir</b><br>";
		rmdir ("$bn_dir");
	}
	
# Remove configuration file
# -------------------------
	echo LABEL_FILE_REMOVING . "<b>$site_cfg_file</b><br>";
	unlink ("$site_cfg_file");

	unset($site);
	MsgForm (str_replace("{SITE}", $bn, LABEL_SITE_REMOVING), "admin.$ext");
	
	echo "</body></html>";
	exit;
}

#  display FORM
#  ------------

	beginForm();
	hiddenField ("do_delete", 1);

	if (is_array($forums)) {
		list_forums ($forums, LABEL_SITE_CONTENT, "", "edit_forum.$ext");
	} else {
		echo "<p align=center><em>" . LABEL_SITE_NO_CONTENT . "</em></p>";
	}
?>

 <br>
 <h3 align=center><?echo str_replace("{SITE}", $site, LABEL_SITE_DELETE_CONFIRMATION)?></h3>
 <center>
  <INPUT TYPE="submit" VALUE="<?echo LABEL_DELETE_THIS_SITE ?>">
  <INPUT TYPE="button" VALUE="<?echo BUTTON_CANCEL?>" onClick="history.back()">
 </center>
</FORM>
</BODY>
</HTML>
