<?php

/* 
 *	W-AGORA 4.0
 *	-----------
 *	$Id: delete_threads.php,v 1.28 2005/01/28 00:04:00 mdruilhe Exp $
 *	Usage:		Delete /edit individual note(s) in forum
 *	Authors:	Marc Druilhe <mdruilhe@w-agora.com>
 *				Franky <liedekef@pandora.be>
 */

require ("init_admin.inc");
require ("$cfg_file");

function getForumInfo ($forum) {
	global $cfg_dir, $ext, $db;
	global $dest_db, $dest_dir_notes;

	include ("$cfg_dir/$forum.$ext");
	$dest_dir_notes = $bn_dir_notes;

	$dest_forum = $db->getForum($GLOBALS["site"], $forum);
	$dest_db = $dest_forum["bn_db"];
}

# include messages
# ----------------
	if (!empty($bn_msgs) && file_exists ("$bn_dir/$bn_msgs") ) {
		include "$bn_dir/$bn_msgs";
	} elseif (file_exists ("$bn_dir_default/msgs.$ext") ) {
		include ("$bn_dir_default/msgs.$ext");
	}

	$msg[0] = "thread";

# fields definition
# -----------------
	if (!empty($bn_fields) && file_exists ("$bn_dir/$bn_fields") ) {
		include "$bn_dir/$bn_fields";
	} elseif (file_exists ("$bn_dir_default/fields.$ext") ) {
		include ("$bn_dir_default/fields.$ext");
	}

# Set core variables (managed by w-agora)
# this code is here for compatibility w/ old fields def. files (bn_var is reset)
# ------------------------------------------------------------------------------
	unset ($bn_var);
	$bn_var = array (
		"unixdate",		// timestamp (creation date)
		"userid",		// user ID
		"password",		// MD5 encoded password
		"filename",		// name of HTML note
		"mail_reply",	// set to "1" if replies to this note must be sent by email
		"hidden",		// set to 1 if note must be approved by the moderator
		"hits",			// hits count 
		"closed",		// closed thread (RFU)
		"ip"			// logged IP address of sender
	);

# force w-agora variables to be listed
# ------------------------------------
	reset ($bn_var);
	while ( list(, $var) = each($bn_var) ) {
		$list_var[$var] = 1;
	}
	$list_var["username"] = 1;
	$list_var["subject"] = 1;

# listing outline
# ---------------
	if (!empty($bn_list_vars) && file_exists ("$bn_dir/$bn_list_vars") ) {
		include "$bn_dir/$bn_list_vars";
	} elseif (file_exists ("$bn_dir_default/list.$ext") ) {
		include ("$bn_dir_default/list.$ext");
	}

# Note template
# -------------
	if (!empty($bn_template) && file_exists ("$bn_dir/$bn_template") ) {
		include "$bn_dir/$bn_template";
	} elseif (file_exists ("$bn_dir_default/template.$ext") ) {
		include ("$bn_dir_default/template.$ext");
	}

	$this_forum = $db->getForum($site, $bn);
	$bn_db = $this_forum["bn_db"];
	$totalthreads = $this_forum["totalthreads"];
	$totalnotes = $this_forum["totalnotes"];

	$period_units = array (
		"1" => LABEL_DAYS,
		"7" => LABEL_WEEKS,
		"30" => LABEL_MONTHS
	);

# Check that notes range is correct (date, keys)
# ----------------------------------------------
if (!isset ($confirmed) ) {
	switch ($select) {
		case "bykeys":
			if (!is_array ($keys) || (count($keys) <1) ) {
				msgWarning (CAPTION_SELECT_NOTES);
				$action = "form";
			}
		break;

		case "bydate":
			$date1 = mktime(0,0,0,$m1,$j1,$a1) - ($bn_tz_offset*3600);
			$date2 = mktime(23,59,59,$m2,$j2,$a2) - ($bn_tz_offset*3600);
			if ($date2 <= $date1) {
				msgWarning (ERROR_INCORRECT_DATES);
				$action = "form";
			} else {
				$display_date1 = formated_date ($date1);
				$display_date2 = formated_date ($date2);
			}
		break;

		case "oldest":
			if (empty ($period) ) {
				msgWarning (ERROR_NO_PERIOD);
				$action = "form";
			} else {
				// $date1 = 1;
				$date1 = $this_forum[unixdate];
				$timeframe = $period * $unit * 24*60*60;
				$date2 = time() - $timeframe;
				if ($date2 <= $date1) {
					msgWarning (str_replace("{NUMBER}", $period, str_replace("{PERIOD}", $period_units[$unit], ERROR_NO_NOTES_OLDER)));
					$action = "form";
				} else {
					$display_date1 = formated_date ($date1);
					$display_date2 = formated_date ($date2);
				}
			}
		break;

		default:
			$action = (isset ($action)) ? $action : "form";
		break;
	}
}

# Check selected action
# ---------------------
switch ($action) {

	// Confirm copy/move threads to forum
	case "confirmcopy":
		beginForm();
		hiddenField ("action", "copy");
		hiddenField ("select", "$select");
		hiddenField ("dest_forum", "$dest_forum");
		hiddenField ("confirmed", "1");
		echo "<BR><BR><CENTER><b>";
		if (isset($movethreads) ) {
			echo str_replace("{FORUM}", $dest_forum, CONFIRM_THREAD_MOVE);
			hiddenField ("movethreads", "1");
		} else {
			echo str_replace("{FORUM}", $dest_forum, CONFIRM_THREAD_COPY);
		}
		if ($select == "bykeys") {
			$count = count ($keys);
			for ($i=0; $i < $count; $i++) {
				hiddenField ("keys[$i]", $keys[$i]);
			}
		} else {
			hiddenField ("date1", "$date1");
			hiddenField ("date2", "$date2");
		}

		echo "<BR><BR>";
		submitButton ("submit", LABEL_CONFIRM);
		backButton ('back', BUTTON_CANCEL );
		echo "</CENTER>";
		endForm();
		exit;
	break;

	case "confirmdelete":
		beginForm();
		hiddenField ("action", "delete");
		hiddenField ("select", "$select");
		hiddenField ("confirmed", "1");
		echo "<BR><BR><CENTER><b>";
		if ($select == "bykeys") {
			$count = count ($keys);
			for ($i=0; $i < $count; $i++) {
				hiddenField ("keys[$i]", $keys[$i]);
			}
			printf (CONFIRM_DELETE_THREAD, $count);
		} else {
			hiddenField ("date1", "$date1");
			hiddenField ("date2", "$date2");
			printf (CONFIRM_DELETE_THREAD_DATE, $display_date1, $display_date2);
		}
		echo "<BR><BR>";
		submitButton ("submit", LABEL_CONFIRM);
		backButton ('back', BUTTON_CANCEL );
		echo "</CENTER>";
		endForm();
		?></body></html><?
		exit;
	break;

	case "copy":
		// set global variables dest_db dest_dir_notes
		if ($select != "bykeys") {
			$keys = $db->getThreadsDate ($bn_db, $date1, $date2, "lastdate");
		}

		if (!is_array ($keys) ) {
			msgWarning (ERROR_NO_THREAD);
			break;
		}
		getForumInfo($dest_forum);

		reset ($db_var);
		while ( list(, $var) = each($db_var) ) {
			$list_var[$var] = 1;
		}

		echo "<h3 align='center'>" . str_replace("{FORUM}",$dest_forum, LABEL_COPYING_NOTES) . "</h3>";
		// For each thread selected : 
		// --------------------------
		reset ($keys);
		while (list (, $thread) = each ($keys) ) {
			
			$ret = $db->copyThread ($bn_db, $thread, $bn_dir_notes, $dest_db, 0, $dest_dir_notes);
			if ($ret < 0) {
			    msgWarning (str_replace("{FORUM}",$bn, str_replace("{THREAD}", $thread, ERROR_COPY_THREAD)));
			}
			if ( isset($movethreads) && ($ret == 0 ) ) {
				$ret = $db->deleteThread ($bn_db, $thread, $bn_dir_notes);
			}

			if ($ret < 0) {
			    msgWarning (str_replace("{FORUM}",$bn, str_replace("{THREAD}", $thread, ERROR_DELETE_THREAD)));
			}
		}
	break;

	case "delete":
		if ($select == "bykeys") {
			$ret = $db->mDeleteThreads ($bn_db, $keys, $bn_dir_notes);
		} else {
			$ret = $db->mDeleteThreadsDate ($bn_db, $date1, $date2, $bn_dir_notes);
		}
		if ($ret < 0) {
			msgWarning (str_replace("{FORUM}",$bn, ERROR_DELETE_THREAD));
		}
	break;

	case "open":
		$ret = $db->setClosedThread ($bn_db, $thread, 0);
		if ($ret < 0) {
			msgWarning (sprintf(ERROR_DATABASE, $ret));
		} else {
			msgWarning (LABEL_THREAD_OPENED);
		}
	break;

	case "close":
		$ret = $db->setClosedThread ($bn_db, $thread, 1);
		if ($ret < 0) {
			msgWarning (sprintf(ERROR_DATABASE, $ret));
		} else {
			msgWarning (LABEL_THREAD_CLOSED);
		}
	break;

	default:
	break;
}

# No action set => get threads to be deleted
# ------------------------------------------
	display_header (TITLE_MANAGE_THREADS);

	$expnd="none";
	$ret = $db->listThreads ($bn_db, $first, $last, "", 0, $bn_maxthreads);
	if (!is_array ($ret) || ($ret < 0)) {
		msgWarning (sprintf(ERROR_DATABASE, $ret));
		echo "</body></html>";
		exit;
	}

	if ($ret["total"] == 0) {
		msgWarning (sprintf(ERROR_NO_ENTRY_FOUND, $msg[0]));
		echo "</body></html>";
		exit;
	}

	$last= $ret["last"];
	$first = $ret["first"];
	$prev = (isset($ret["prev"])) ? $ret["prev"] : 0;
	$next = (isset($ret["next"])) ? $ret["next"] : 0;

	table_header (LABEL_SELECT_THREAD);

	beginForm();

	$select = "bykeys";

# Choice #1 => select individual threads
# --------------------------------------
	echo "<br><font size='+1'><b>1. " . LABEL_SELECT_THREAD_OR_DATE . "</b></font>";
	echo "<br><BR><li>";
	radioButton ("select", "bykeys", $select, LABEL_SELECT_INDIVIDUAL_THREAD . "<P>" );
	$bn_before_line = '
if ($closed==1) {
	$close_action="open";
	$close_icon="$icon_dir/open.gif";
	$alt_text=LABEL_OPEN_THREAD;
	$class="closedthread";
} else {
	$close_action="close";
	$close_icon="$icon_dir/close.gif";
	$alt_text=LABEL_CLOSE_THREAD;
	$class="openthread";
}
	';
	$bn_delete_header = "<table cellspacing=\"0\" width=\"100%\">";
	$bn_delete_odd_first_line = "<tr class=\"mouseout\" onmouseout=\"changeclass(this,'mouseout')\" onmouseover=\"changeclass(this,'mouseover')\"><td class=\"s_label\"><input type=\"checkbox\" name=\"keys[]\" value=\"\$note\"> <i>\$newestNote</i> <b><a href=\"view.$ext?bn=\$bn&key=\$key\" class='\$class'>\$subject</a></b> (\$username) [\$replies " . LABEL_REPLIES . "]</td><td> <a href='$WA_SELF?site=$site&bn=$bn&action=\$close_action&thread=\$key'><img src=\"\$close_icon\" border=0 alt=\"\$alt_text\"></a></td></tr>";
	$bn_delete_even_first_line = $bn_delete_odd_first_line;
	$bn_delete_begin_level = "";
	$bn_delete_odd_line = "";
	$bn_delete_even_line = "";
	$bn_delete_end_level = "";
	$bn_delete_end_thread = "";
	$bn_delete_footer = "</table>";

	$db->displayList (0, "delete");

	if ($prev || $next) {
		echo "<HR><CENTER><TABLE><TR><TD width='100' align=center>&nbsp;";
		if ($prev) {
			$list_prev_text = LABEL_PREV_PAGE;
			$list_prev_url = "$WA_SELF?bn=$bn&expnd=$expnd&last=$first&sort=$sort&where=$where";
			displayURL ($list_prev_url, "", LABEL_PREV_PAGE, ALT_PREV_PAGE);
		}
		echo "</TD><TD width='100' align=center>&nbsp;";
		if ($next) {
			$list_next_text = LABEL_NEXT_PAGE;
			$list_next_url = "$WA_SELF?bn=$bn&expnd=$expnd&first=$last&sort=$sort&where=$where";
			displayURL ($list_next_url, "", LABEL_NEXT_PAGE, ALT_NEXT_PAGE);
		}
		echo "</TD></TR></TABLE></CENTER>\n";
	}

	echo "<br><CENTER>";
	resetButton ("reset", LABEL_UNSELECT );
	echo "</CENTER>";

# Choice #2 => select threads by date
# -----------------------------------
	$date1 = $this_forum["unixdate"];
	$date2 = time() - (24*3600*28);
	if ($date1 > $date2) {
		$date2=time();
	}

	echo "<br><b>" . LABEL_OR . "</b><br><br><li>";
	radioButton ("select", "bydate", $select, LABEL_THREAD_BETWEEN);
	textField ("j1", date("d", $date1), 2); echo "/";
	textField ("m1", date("m", $date1), 2); echo "/";
	textField ("a1", date("Y", $date1), 4);
	echo LABEL_AND;
	textField ("j2", date("d", $date2), 2); echo "/";
	textField ("m2", date("m", $date2), 2); echo "/";
	textField ("a2", date("Y", $date2), 4);

# Choice #3 => select threads older than a given date
# ---------------------------------------------------
	$period = (isset($period)) ? $period : 3;
	$unit = (isset($unit)) ? $unit : 3;

	echo "<br><br><b>" . LABEL_OR . "</b><br><br><li>";
	radioButton ("select", "oldest", $select, LABEL_THREAD_OLDER);
	textField ("period", $period, 2);
	listBox ("unit", $period_units, $unit);

# Now check if other availables forums in this site for which the moderator is responsible
# ----------------------------------------------------------------------------------------
	if ($auth->level > MODER) {
		$forums =  $db->listForums($site);
	} else {
		$forums =  $db->listForums($site, $auth->userid);
	}

	$dest_forums = array();
	reset($forums);
	while (list ($name, $f) = each ($forums) ) {
		$forum = $f["bn_name"];
		if ($forum != $bn) {
			$dest_forums[$forum] = $name;
		}
	}

	if (count ($dest_forums) > 0) {
		echo "<hr noshade><br><font size='+1'><B>2. " . LABEL_SELECT_ACTION . "</B></font>";
		echo "<br><li> ";
		radioButton ("action", "confirmdelete", "confirmdelete", ACTION_THREAD_DELETE);
		echo "<li>";
		radioButton ("action", "confirmcopy", "", ACTION_THREAD_COPY);
		listBox ("dest_forum", $dest_forums, "");
		echo "&nbsp;&nbsp;";
		checkBox ("movethreads", "1", $move, ACTION_THREAD_MOVE);
	} else {
		echo "<br><br><font size='+1'><B>" . ACTION_THREAD_DELETE . "</B></font>";
		hiddenField ("action", "confirmdelete");
	}

	echo "<br><CENTER>";
	submitButton ("", LABEL_EXECUTE);
	echo "</CENTER>";
	endForm();
	table_footer ();
?>
</BODY>
</HTML>
