<?php

/*
 *	W-AGORA 4.0
 *	-----------
 *	$Id: download_forum.php,v 1.32 2005/02/10 14:14:27 mdruilhe Exp $
 *	Usage:		download (displays) the whole contents of a forum
 *	Author:		Marc Druilhe <mdruilhe@w-agora.com>
 */	

	$bn_action="download";
	$bn_action_mode="R";
	require ("init.inc");
	
	function displayNote ($key) {
		global $inc_dir, $ext, $site, $bn, $db, $auth, $bn_db, $bn_action, $bn_pad;
		global $bn_dir, $bn_dir_notes, $bn_dir_default, $icon_dir, $bn_before_access, $bn_doc_var;
		global $bn_user_mail, $bn_thread, $bn_modify, $bn_delete, $is_moderator;
		global $bn_win_width, $bn_win_height;

		$has_children=is_array($db->children[$key]);

		$bn_action="view";

		// evaluate all variables
		if ($key>0) {
			extract ($db->entries[$key]);
		}

		// we don't display key 0 (administrative note)
		// and don't display old notes (if list only new)
		if ( ($hidden && $auth->level<MODER) || ($key == 0) ) {
			$hidden_note = true;
		} else {
			// initialize links variables
			if ($bn_user_mail && $bn_thread) {
				$subscribe_thread_url = "subscribe_thread.$ext?site=$site&bn=$bn&thread=$thread";
				$subscribe_thread_text = LABEL_SUBSCRIBE_THREAD;
				$subscribe_thread_link = anchorWindow ($subscribe_thread_url, $subscribe_thread_text, ALT_RECEIVE_UPDATES, 620, 460);
			}

			// CLOSE
			$close_url = "";
			if ($is_moderator && $bn_thread) {
				$close_url = "close.$ext?bn=$bn&key=$key";
				$close_text = LABEL_CLOSE_OPEN_THREAD;
				$close_link = anchor ($close_url, "", $close_text, $close_text );
			}

			if (!empty($bn_before_access)) {
				if (file_exists ("$bn_dir/$bn_before_access") ) {
					include "$bn_dir/$bn_before_access";
				} else {
					include "$bn_dir_default/$bn_before_access";
				}
			} elseif (file_exists ("$bn_dir_default/before_access.$ext") ) {
				include ("$bn_dir_default/before_access.$ext");
			}
			printf ("\n<a name=\"N%s\"></a>\n", $key);
			$viewkey = $key;
			require	("$inc_dir/viewnote.$ext");
		}

		if ( is_array($db->children[$key]) ) {
			// display all replies to this thread
			reset ($db->children[$key]);
			while ( $child=current($db->children[$key]) ) {
				$nextchild = next($db->children[$key]);
				if ($parent == 0) {
					printf ("\n<p><a name=\"T%s\"></a><div align=\"right\">", $child);
					printf ("<a href=\"#top\">%s</a>&nbsp;&nbsp;&nbsp;&nbsp;</div>\n", LABEL_TOP);
					if ($nextchild) {
						printf ("<div align=right><a href=\"#T${nextchild}\">%s</a>&nbsp;</div>", LABEL_NEXT_THREAD);
					}					
				}
				// print "<blockquote>";
				displayNote ($child);
				// print "</blockquote>";
			}
		}
	}

	/* Execute before_access program */
	if (!empty($bn_before_access)) {
		if (file_exists ("$bn_dir/$bn_before_access") ) {
			include "$bn_dir/$bn_before_access";
		} else {
			include "$bn_dir_default/$bn_before_access";
		}
	} elseif (file_exists ("$bn_dir_default/before_access.$ext") ) {
		include ("$bn_dir_default/before_access.$ext");
	}

	display_header (TITLE_DOWNLOAD_FORUM, $header_footer);
	if (empty($bn)) {
		msgForm (ERROR_NO_FORUM_SPECIFIED, "$main_page", "", "_top");
		exit;
	}

	$unit = (isset($unit)) ?  $unit : "7";

	if ( 0 == (integer)$unit ) {
		$period = "";
	} else {
		$period = (empty($period)) ? "1" : $period;
	}

	beginForm();
	print ("<a name=\"top\"></a>");
	print LABEL_SHOW_ACTIVE_THREADS;
	textField ("period", $period, 3);
	$units = array (
			"0" => LABEL_SHOW_ALL,
			"1" => LABEL_DAYS,
			"7" => LABEL_WEEKS,
			"30" => LABEL_MONTHS
			);
	listBox ("unit", $units, $unit);
	submitButton ("go", LABEL_GO);
	endForm();

# Gets listing outline
# --------------------
	if (!empty($bn_list_vars) && file_exists ("$bn_dir/$bn_list_vars") ) {
		include "$bn_dir/$bn_list_vars";
	} elseif (file_exists ("$bn_dir_default/list.$ext") ) {
		include ("$bn_dir_default/list.$ext");
	}

	if (empty($bn_digest_even_first_line) ) { // even first line should not be empty if defined
		$bn_digest_header = "<div align=left><ul>";
		$bn_digest_odd_first_line = "<li><font size=-1>\$formated_date</font> <a href='#N\$key'><em>\$subject</em></a> \$att_icon (\$username)";
		$bn_digest_even_first_line = "<li><font size=-1>\$formated_date</font> <a href='#N\$key'><em>\$subject</em></a> \$att_icon (\$username)";
		$bn_digest_begin_level = "<ul>";
		$bn_digest_odd_line = "<li><font size=-1>\$formated_date</font> <a href='#N\$key'><em>\$subject</em></a> \$att_icon (\$username)";
		$bn_digest_even_line = "<li><font size=-1>\$formated_date</font> <a href='#N\$key'><em>\$subject</em></a> \$att_icon (\$username)";
		$bn_digest_end_level = "</ul>";
		$bn_digest_footer = "</ul></div>";
	}

# gets all notes from the forum
# -----------------------------
	$list_var["body"]=1;
	$expnd="all";

	if ($period>0) {
		$last = $now - ($period * $unit * 24*60*60);
	} else {
		$last = 0;
	}

	if ($totalnotes == 0) {
		msgWarning (sprintf(ERROR_NO_ENTRY_FOUND, $msg[0]));
		echo "</body></html>";
		exit;
	}

	$ret = $db->listThreads ($bn_db, 0, 0, "newest>$last", 1, 0);

# displays notes listing
# -----------------------
	if (!is_array ($ret) || ($ret < 0)) {
		echo "<CENTER><strong>"; printf(ERROR_DATABASE, $ret); echo "</STRONG></CENTER>";
	} else {
		require_once "$inc_dir/listrenderer.$ext";
		$list =& new ListRenderer($db);
		$list->displayList(0, 'digest');
	}

# Now display each individual note
# --------------------------------
	$bn_action="view";

# include Note template
# ----------------------
	if (!empty($bn_template) && file_exists ("$bn_dir/$bn_template") ) {
		include "$bn_dir/$bn_template";
	} elseif (file_exists ("$bn_dir_default/template.$ext") ) {
		include ("$bn_dir_default/template.$ext");
	}

## $bn_doc_var="<p><STRONG>\$formated_date <font color=\"#339900\">\$subject</font></strong><P>\$body<br><P><a href='mailto:\$useraddress?subject=[\$bn] \$subject'>\$username</a>";

	if (is_array($db->entries)) {
		reset($db->entries);
		displayNote(0);
	}

# Display footer
# --------------
	display_footer ($header_footer);
?>
