<?php

/*
 *  W-AGORA 4.0
 *  -----------
 *  $Id: download_thread.php,v 1.25 2004/10/10 22:49:15 mdruilhe Exp $
 *  Usage:      download (displays) the whole contents of a thread
 *  Authors:    Marc Druilhe <mdruilhe@w-agora.com>
 *              Laurent aufrre <laurent.aufrere@free.Fr>
 */

# Initialization stuff
# --------------------
	$bn_action="download";
	$bn_action_mode="R";
	require ("init.inc");

	settype($thread, "integer");

	if (empty($bn)) {
		if (!empty($before_access)) include $before_access;
		display_header (TITLE_DOWNLOAD_THREAD, $header_footer);
		msgForm ("You must specify a forum", "$main_page", "", "_top");
		display_footer ($header_footer);
		exit;
	}

	if (empty ($thread) ) {
		if (!empty($before_access)) include $before_access;
		display_header (TITLE_DOWNLOAD_THREAD, $header_footer);
		msgForm (ERROR_SPECIFY_THREAD, "$main_page", "", "_top");
		display_footer ($header_footer);
		exit;
	}

# Gets listing outline
# --------------------
	if (!empty($bn_list_vars) && file_exists ("$bn_dir/$bn_list_vars") ) {
		include "$bn_dir/$bn_list_vars";
	} elseif (file_exists ("$bn_dir_default/list.$ext") ) {
		include ("$bn_dir_default/list.$ext");
	}

	if (empty($bn_digest_even_first_line) ) { // even first line should not be empty if defined
		$bn_digest_header = "<div align=left><ul>";
		$bn_digest_odd_first_line = "<li><font size=-1>\$formated_date</font> <a href='#N\$key'><em>\$subject</em></a> \$att_icon (\$username)";
		$bn_digest_even_first_line = "<li><font size=-1>\$formated_date</font> <a href='#N\$key'><em>\$subject</em></a> \$att_icon (\$username)";
		$bn_digest_begin_level = "<ul>";
		$bn_digest_odd_line = "<li><font size=-1>\$formated_date</font> <a href='#N\$key'><em>\$subject</em></a> \$att_icon (\$username)";
		$bn_digest_even_line = "<li><font size=-1>\$formated_date</font> <a href='#N\$key'><em>\$subject</em></a> \$att_icon (\$username)";
		$bn_digest_end_level = "</ul>";
		$bn_digest_footer = "</ul></div>";
	}

# *********************************
# set the view url to switch to normal display
# -----------------------------

// NORMAL VIEW
	$normal_view_url = "view.$ext?site=$site&bn=$bn&key=$thread";
	$normal_view_text = LABEL_NORMAL_VIEW;
	$normal_view_link = anchor ($normal_view_url, "", $normal_view_text, ALT_NORMAL_VIEW);

	$edit_text = LABEL_EDIT_MESSAGE; // used in template

# gets all notes in this thread
# -----------------------------
	$list_var["body"]=1;
	$expnd="all";

	$ret = $db->getThread ($bn_db, $thread, $thread);

	$db->query("UPDATE $bn_db SET hits=hits+1 WHERE thread=$thread");

	/* Execute before_access program */
	if (!empty($before_access)) include $before_access;

	display_header (TITLE_DOWNLOAD_THREAD, $header_footer);

	print ("<a name=\"top\"></a>");

# displays notes listing
# -----------------------
	if ($ret < 0) {
		echo "<CENTER><strong>"; printf(ERROR_DATABASE, $ret); echo "</STRONG></CENTER>";
	} else {
		print "<div align=right>$normal_view_link</div>";
		$db->displayList ($thread, "digest");
	}

	if (empty($bn_flat_even_first_line) ) { // even first line should not be empty if defined
		$bn_flat_header = "";
		$bn_flat_odd_first_line = "<a name='N\$key'>".$bn_doc_var;
		$bn_flat_even_first_line = $bn_flat_odd_first_line;
		$bn_flat_begin_level = "";
		$bn_flat_odd_line = $bn_flat_odd_first_line;
		$bn_flat_even_line = $bn_flat_odd_first_line;
		$bn_flat_end_level = "";
		$bn_flat_footer = "";
	}


# Now display each individual note
# --------------------------------
	if (is_array($db->entries)) {
		reset($db->entries);
		$db->displayList ($thread, "flat");
	}
# ***************************************
# handle thread sorting in order to properly set links to next/previous thread in the current list
# ------------------------------------------------------------------------------------------------
	$set_url_sort = false;
	if (!empty($HTTP_GET_VARS["sort"])) {
		list ($s, $o) = split(',', $HTTP_GET_VARS["sort"], 2);
		$s = preg_replace('/\W/', '', $s);
		if ($o[0]=="d") {
			$sort = "$s,d";
			$threads_order = "$s DESC";
		} else {
			$sort = "$s";
			$threads_order = "$s";
		}
		if (!@setcookie ("${bn}_sort", $sort, 0, '/')) {
			$set_url_sort = true;
		}
	} elseif (!empty($HTTP_COOKIE_VARS["${bn}_sort"]) ) {
		list ($s, $o) = split(',', $HTTP_COOKIE_VARS["${bn}_sort"], 2);
		$o = ($o[0]=="d") ? "DESC" : "ASC";
		$threads_order = "$s $o";
	} else {
		$threads_order = (empty($default_threads_order)) ? "newest DESC" : $default_threads_order;
	}

# read note from database, exit if error
# --------------------------------------
	$note = $db->getNote ($bn_db, $thread, $where, $threads_order);

# set URLs to be displayed in the navbar
# ---------------------------------------

// PREVIOUS / NEXT THREAD
	$view_prev_text = (empty($msg[79])) ? LABEL_PREV_THREAD : $msg[79];
	if (!empty($note["tprev"])) {
		$tprev = $note["tprev"];
		$view_prev_url = "$WA_SELF?bn=$bn&thread=$tprev".$nav;
		if ($set_url_sort) {
			$view_prev_url .= "&sort=".urlencode($sort);
		}
		$view_prev_link = anchor ($view_prev_url, "", $view_prev_text, ALT_PREV_THREAD);
	} else {
		$view_prev_url = "";
		$view_prev_link = "";
	}

	$view_next_text = (empty($msg[80])) ? LABEL_NEXT_THREAD : $msg[80];
	if (!empty($note["tnext"])) {
		$tnext = $note["tnext"];
		$view_next_url = "$WA_SELF?bn=$bn&thread=$tnext".$nav;
		if ($set_url_sort) {
			$view_next_url .= "&sort=".urlencode($sort);
		}
		$view_next_link = anchor ($view_next_url, "", $view_next_text, ALT_NEXT_THREAD);
	} else {
		$view_next_url = "";
		$view_next_link = "";
	}

# set the thread navigation bar
# ------------------------------
	$nav_pipe = (!empty($view_next_url) && !empty($view_prev_url))? "|": "";
	$nav_bar = "$view_prev_link &nbsp; $nav_pipe &nbsp; $view_next_link";

# display navigation bar
# ----------------------
	if (!$bn_no_nav_bar) {
		print "<!-- NAV BAR -->\n<br><div align=right>$nav_bar</div>\n<!-- /NAV BAR -->\n";
	}
# ***************************************
# Display footer
# --------------
	display_footer ($header_footer);
?>
