<?php

/*
 *	W-AGORA 4.0
 *	-----------
 *	$Id: edit.php,v 1.22 2005/02/10 14:14:27 mdruilhe Exp $
 *	Usage:		Display Update form
 *	Author:		Marc Druilhe <mdruilhe@w-agora.com>
 *
 */	

# Initialization stuff
# --------------------
	$bn_action="edit";
	$bn_action_mode="W";
	$popup=1;
	//set the minimum time between updates to send the mail or not
	$min_mail_update_time=12*3600;
	require ("init.inc");

	// Some installations (multimania.fr..) seems to lose/unset $key
	if (isset ($HTTP_POST_VARS['key'])) {
		$key = $HTTP_POST_VARS['key'];
	} elseif (isset ($HTTP_GET_VARS['key'])) {
		$key = $HTTP_GET_VARS['key'];
	}

# if note to edit is not defined then return to the list
# ------------------------------------------------------
	if (empty($key)) {
		if (!empty($before_access)) include $before_access;
		display_header (LABEL_EDIT_MESSAGE, $header_footer);
		MsgForm (ERROR_SPECIFY_KEY, "list.$ext", 'close');
		display_footer ($header_footer);
	}

# read note from database, exit if error
# --------------------------------------
	$note = $db->getNote ($bn_db, $key);
	if ($note < 0) {
		if (!empty($before_access)) include $before_access;
		display_header (LABEL_EDIT_MESSAGE, $header_footer);
		MsgForm (sprintf(ERROR_NOTE_NOT_FOUND, $msg[0]), "list.$ext", 'close');
		display_footer ($header_footer);
	}

# set all fields as global variables
# ----------------------------------
	while ( list( $var, $val ) = each( $note)) {
		if (is_string ($var)) {
			if ($bn_html_var[$var]) {
				if ($bn_use_smileys) {
					$val = strip_smileys($val);
				}
				if ($bn_auto_url) {
					$val = strip_url($val);
				}
			}
			$$var = kill_quotes(stripslashes($val));
		}
	}

# If thread is closed : only moderator can edit it 
# ------------------------------------------------
	if (($note["closed"]==1) && !$is_moderator) {
		if (!empty($before_access)) include $before_access;
		display_header (TITLE_ERROR, $header_footer);
		msgForm (MSG_THREAD_IS_CLOSED, "view.$ext?bn=$bn&key=$key", 'close');
		display_footer ($header_footer);
	}

# If this is not a public forum (authenticated user) then we check that the user
# is the original poster of this note or that he is a moderator
# ----------------------------------------------------------------------------
	if (!$is_authenticated) {
		if ($note["userid"] == 'guest') {
			$is_owner = false;
			$ask_password = true;
		} else {
			$loginURL = $auth->getLoginURL();
			if (is_string($loginURL)) {
				header("Location: $loginURL");
			} else {
				if (!empty($before_access)) {
					include $before_access;
				}
				display_header ('login', $header_footer);
				$auth->login($site, LABEL_MUST_LOGIN);
				display_footer ($header_footer);
			}
			exit;
		}
	} elseif ($is_moderator) {
		// a moderator can edit/delete a post
		$is_owner=true;
		$ask_password = false;
	} elseif ($auth->user["userid"] == $note["userid"]) {
		// the note was posted by this authenticated user
		$is_owner = true;
		$ask_password = false;
	} elseif ($note["userid"] == 'guest') {
		// This note has been posted by a guest user => check password
		$is_owner = ($auth->user["password"] == $note["password"]) ? true : false;
		$ask_password = !$is_owner;
	} else {
		// The user is authenticated but this note was posted by another user
		if (!empty($before_access)) {
			include $before_access;
		}
		display_header (TITLE_ERROR, $header_footer);
		MsgForm (ERROR_FORBIDDEN_ACCESS, "view.$ext?key=$key", 'close'); // access forbidden
		display_footer ($header_footer);
		exit;
	}

#	Exit with error if this note is hidden
# --------------------------------------
	if (!$is_owner && ($note["$hidden"] == "1") ) {
		if (!empty($before_access)) include $before_access;
		display_header (TITLE_ERROR, $header_footer);
		MsgForm (ERROR_FORBIDDEN_ACCESS, "list.$ext", ""); // access forbidden to this page
		display_footer ($header_footer);
	}

# Check that the "allow modify" option is set on this forum
# If not set then only the moderator of this board can edit a message
# -------------------------------------------------------------------
	if (!$bn_modify && !$is_moderator) {
		if (!empty($before_access)) include $before_access;
		display_header (TITLE_ERROR, $header_footer);
		MsgForm (ERROR_FORBIDDEN_ACCESS, "view.$ext?key=$key", 'close');
		display_footer ($header_footer);
	}

	// DELETE
	$delete_url = "";
	if ($bn_delete) {
		$delete_url = "delete.$ext?bn=$bn&key=$key&expnd=$thread";
		$delete_text = LABEL_DELETE_MESSAGE;
		$delete_link = anchor ($delete_url, "", $delete_text, LABEL_DELETE_THIS_MESSAGE);
	}

	// CLOSE
	$close_url = "";
	if ($is_moderator) {
		$close_url = "close.$ext?bn=$bn&key=$key&expnd=$thread";
		$close_text = LABEL_CLOSE_OPEN_THREAD;
		$close_link = anchor ($close_url, "", $close_text);
	}

# Display form
# ------------
	if (($now-$mod_date)>$min_mail_update_time) $default_mail_update=1;
	if (!empty($before_access)) include $before_access;
	display_header (LABEL_EDIT_MESSAGE, $header_footer);

	$setUserField = false;		// Don't set username and password from cookies, get it from the note
	$form_action = "update.$ext";
	$back_form="edit";

	include "$inc_dir/form.$ext";

# Display footer
# --------------
	display_footer ($header_footer);
?>
