<?php

/*
 *	W-AGORA 4.0
 *	-----------
 *	$Id: edit_forum.php,v 1.13 2003/12/03 15:06:29 mdruilhe Exp $
 *	Usage:		Edit  parameters of a forum
 *	Author:		Marc Druilhe <mdruilhe@w-agora.com>
 *
 */

require ("init_admin.inc");

# read site administration configuration
# --------------------------------------
require ("$site_cfg_file");	
require ("$bn_dir/$bn_fields");
if (empty($bn_msgs) ) {
	include ("$bn_dir_default/site_msgs.$ext");
} else {
	include "$bn_dir/$bn_msgs";
}

display_header (LABEL_EDIT_FORUM);

# --------------------------------------------------
# check if this user is authorized to edit a forum
# --------------------------------------------------
if ($auth->level < ADMIN) {
	MsgForm (ERROR_NO_ADMIN, "admin_site.$ext?site=$site&force_login=1", "", "_top");
	echo "</body></html>";
	exit;
}

# ------------------------------------------------
# list forums if none has been selected, then exit
# ------------------------------------------------
if (empty($bn)) {
	$forums = $db->listForums ($site);
	if (is_array($forums)) {
		list_forums ($forums, sprintf(LABEL_SITE_EDIT_FORUM, $site));
	} else {
		msgForm (sprintf(ERROR_NO_FORUM_ADMIN, $site), "create_forum.${ext}?site=$site");
	}
	exit;
}

# --------------------------------------------
# a forum has been selected => get this forum
# --------------------------------------------
$forum = $db->getForum($site, $bn);
if (!is_array($forum)) {
	MsgForm (sprintf(ERROR_NO_FORUM, $forum_name), "$WA_SELF?site=$site", 'back');
	echo "</body></html>";
	exit;
}

# save owner for later usage
# --------------------------
$old_owner = $forum["owner"];
$bn_db = $forum["bn_db"];		// for compatibility (bn_db overwritten in old config. file)

# -----------------------------------------------------
#  Creation form have been submitted => do installation
# -----------------------------------------------------
if (isset($go)) {

	$go=0;

#  Check required fields
# ----------------------
	if (is_array($bn_bind_var)) {
		reset($bn_bind_var);
		while (list($field, $required) = each($bn_bind_var)) {
			if ($required && !$$field) {
				$mess = sprintf (ERROR_MISSING_FIELD, $field);
				MsgForm ("$mess", "$WA_SELF", 'back');
				exit;
			}
		}
	}

#  Now update this forum in the forums table
#  -----------------------------------------
	$moderated = (isset($moderated)) ? 1 : 0;
	for (reset ($bn_var); $field=current($bn_var); next($bn_var)) {
		if (isset($$field) ) {
			$$field=strip_magic_quotes($$field);
			$forum[$field]=$$field;
		}
	}

	if (isset($parent) ) {
		$forum["parent"] = $parent;			// update parent (category)
	}

	$ret = $db->updateForum ($site, $bn, $forum);
	if ($ret < 0) {
		MsgForm (sprintf(ERROR_NO_FORUM_UPDATE, $forum_name, $site), "$WA_SELF?site=$site&bn=$bn", 'back');
		exit;
	}
	
# If moderator has been choosen
# -----------------------------
	if (!empty ($owner) && ($owner != $old_owner) ) {
# First, we check if his a moderator (don't update userforum for administrators
		$u = $db->getUser($site, $owner);
		if (is_array($u) && ($u["userpriv"] == "moder") ) {
# Then we check if this moderator did have access to this forum
			$privs = $db->getPrivs($site, $bn, $owner);
			if (is_array ($privs)) {
# 	yes => we grant him moderator privilege
				$privs["listpriv"]   = 1;
				$privs["readpriv"]   = 1;
				$privs["writepriv"]  = 1;
				$privs["modpriv"]    = 1;
				$ret = $db->updatePrivs ($site, $bn, $owner, $privs);
				if ($ret < 0) {
					MsgForm (sprintf(ERROR_NO_UPDATE_PRIVILEGES, $owner,$forum_name), "$WA_SELF?site=$site&bn=$bn", 'back');
					exit;
				}
			} else {
# 	No => we create a new entry in userforum
				$new_privs["unixdate"]   = $now;
				$new_privs["userid"]     = $owner;
				$new_privs["bn_name"]    = $bn;
				$new_privs["listpriv"]   = 1;
				$new_privs["readpriv"]   = 1;
				$new_privs["writepriv"]  = 1;
				$new_privs["modpriv"]    = 1;
				$new_privs["state"]      = 1;
				$new_privs["last_login"] = 0;
				$new_privs["last_post"]  = 0;
				$ret = $db->InsertPrivs ($site, $bn, $owner, $new_privs);
				if ($ret < 0) {
					MsgForm (sprintf(ERROR_NO_NEW_MODERATOR, $owner, $forum_name), "$WA_SELF?site=$site&bn=$bn", 'back');
					exit;
				}
			}
		}
	}

} // End $go

#  evaluate all fields from $forum
#  --------------------------------
	while ( list( $var, $val ) = each( $forum)) {
		if (is_string ($var)) {
			$$var = kill_quotes(stripSlashes($val));
		}
	}

?>

 <SCRIPT type="text/javascript" LANGUAGE="JavaScript">
<!-- // Hide for old browsers
  function CheckForm(form) {
<?
	/* Check for required fields */
	reset($bn_bind_var);
	while (list($field, $required) = each($bn_bind_var)) {
		if ($required) {
?>
    if ((form.<?echo $field?>.value != null) && (form.<?echo $field?>.value.length == 0)) {
      alert ("<?php printf (ERROR_MISSING_FIELD, $field)?>");
      form.<?echo $field?>.focus();
      return false;
    }
<?
		}
	}
?>
    return true;
  }
// End of script -->
 </SCRIPT>

<FORM NAME="form_post" METHOD="post" ACTION="<?echo $WA_SELF?>" onSubmit="return CheckForm(this);" >

<?
	hiddenField ("site", $site);
	hiddenField ("bn", $bn);
	hiddenField ("bn_name", $bn); // !! only for form verification purpose !!!!

	table_header(LABEL_EDIT_FORUM_SHORT . " $forum_name");
	$categories = $db->getCategories($site);

?>
 <TABLE BORDER="0" WIDTH="100%">
  <CAPTION><B><?echo LABEL_FORUM_INFORMATION?></B></CAPTION>
  <TR>
   <TD WIDTH="40%" ALIGN="RIGHT" VALIGN="MIDDLE" class=label><?echo COLUMN_FORUM_TITLE ?>:</TD>
   <TD><?textField ("bn_title", $bn_title, 40, 255);?></TD>
  </TR>
  <TR>
   <TD WIDTH="40%" ALIGN="RIGHT" VALIGN="TOP" class=label><?echo COLUMN_DESCRIPTION ?>:</TD>
   <TD><?textArea ("descr", $descr, 3, 40);?></TD>
  </TR>
  <TR>
   <TD WIDTH="40%" ALIGN="RIGHT" VALIGN="TOP" class=label><?echo COLUMN_CATEGORY ?>:</TD>
   <TD><?listBox ("parent", $categories, $parent);?></TD>
  </TR>
  <TR>
   <TD WIDTH="40%" ALIGN="RIGHT" VALIGN="TOP" class=label><?echo COLUMN_ORDER ?>:</TD>
   <TD><?textField ("rank", $rank, 3);?></TD>
  </TR>
  <TR>
   <TD WIDTH="40%" ALIGN="RIGHT" VALIGN="TOP" class=label><?echo COLUMN_STATE ?>:</TD>
   <TD><?listBox ("state", $forum_states, $state);?></TD>
  </TR>
 </TABLE>
 <BR>
 <TABLE BORDER="0" CELLPADDING="2" WIDTH="100%">
  <CAPTION><B><?echo LABEL_PRIVACY_INFORMATION ?></B></CAPTION>
  <TR>
   <TD ALIGN="RIGHT" class=label><? echo LABEL_CHANGE_ACCESS ?>:</TD>
   <TD><?listBox ("type", $forum_types, $type); ?></TD>
   <TD ALIGN="RIGHT"><?checkBox ("moderated", 1, $moderated); ?></TD>
   <TD class=label><?echo LABEL_MODERATED ?></TD>
  </TR>
<?php
	$users = $db->getUsers ($site, "", "root,admin,moder");
	if (is_array($users)) {
# fill in combo box with all site moderators
# ------------------------------------------
		reset($users);
		while (list(,$user) = each ($users) ) {
			$userid = $user["userid"];
			$moderators[$userid] = $user["username"];
		}
		echo "<TR><TD ALIGN='RIGHT' colspan=2 class=label>" . LABEL_CHOOSE_MODERATOR . ":</TD>";
		echo "<TD colspan=2>";
		listBox ("owner", $moderators, $owner);
		echo "</TD></TR>";
	}
	echo "</TABLE>\n";
?>
<br>
<CENTER>
 <INPUT NAME="go" TYPE="submit" VALUE="<?echo LABEL_UPDATE_THIS_FORUM ?>">
 <INPUT TYPE="reset"  VALUE="<?echo LABEL_RESET ?>">
</CENTER>
<?php	table_footer(); ?>
</FORM>
</BODY>
</HTML>
