<?php

/* 
 *	W-AGORA 4.2
 *	-----------
 *	$Id: editform.php,v 1.28 2005/04/14 13:57:04 mdruilhe Exp $
 *	Usage:		Edit an HTML file into a textarea (HTML form/header/footer...)
 *	Author:		Marc Druilhe <mdruilhe@w-agora.net>
 *
 */

	require ("init_admin.inc");

# Only a site administrator can edit layout
# -----------------------------------------
	if ($site=="agora") {
		if ($auth->level < ROOT) {
			MsgForm (ERROR_NO_ROOT, "admin_site.$ext?site=$site&force_login=1", "", "_top");
			echo "</body></html>";
			exit;
		}
		$editsite=1;
	} elseif ($auth->level < ADMIN) {
		MsgForm (ERROR_NO_ADMIN, "admin_site.$ext?site=$site&force_login=1", "", "_top");
		echo "</body></html>";
		exit;
	}

# reads configuration
# -------------------
	if ($editsite==1) {
		$cfg_file = $site_cfg_file;	
	}

	include ("$cfg_file");
	if (empty($bn_dir_default)) {
		if (is_dir("$bn_dir_forums/$site/default") ) {
			$bn_dir_default = "$bn_dir_forums/$site/default";
		} else {
			$bn_dir_default = $bn_dir;
		}
		
	}

# set pathname of file to be edited : if variable $bn_xxx is empty then set path to default
# -----------------------------------------------------------------------------------------
	$file = basename($file);	// strip ../.. against intrusions
	$f = "bn_${file}";
	$page_title = LABEL_FILE_EDITING . " '$file'";

	if ($editdefault==1) {
		$form_file = "$bn_dir_default/$file.$ext";
		$page_info = WARNING_EDITING_DEFAULT;
	} elseif (empty ($$f) ) {
		$form_file = "$bn_dir_default/$file.$ext";
		$page_info = "<strong>".WARNING_EDITING_DEFAULT."</strong>";
		if (!empty($bn) ) {
			$page_info .= "<br>" . sprintf(LABEL_SPECIFIC_TEMPLATE, "editconf.$ext?site=$site&bn=$bn&mode=advanced#include");
		} elseif ($editsite==1) {
			$page_info .= "<br>" . sprintf(LABEL_SPECIFIC_TEMPLATE, "editconf.$ext?site=$site&editsite=1");
		}
	} else {
		$form_file="$bn_dir/" . $$f;
	}

# Prevent the user to edit a file outside w-agora
# -----------------------------------------------
	if (! (ereg("$bn_dir_forums", $form_file) || ereg("$tmpl_dir", $form_file))) {
		msgForm ("access restricted to $form_file", "$WA_SELF", 'back');
		exit;
	}


# Save file if submit has been sent
# ---------------------------------
	if (isset($_POST['save'])) {
		if (file_exists ("$form_file")) {
			copy ("$form_file", "$form_file.bak.$ext");
		}

		$form = strip_magic_quotes($_POST['form']);
		$form = ereg_replace("\r\n", "\n", $form);	// PC -> Unix
		$form = ereg_replace("\r", "\n", $form);	// Mac -> Unix
		$form = ereg_replace('([^\\$])\{'.'([a-zA-Z0-9_]+)'.'}', '\\1<'."?echo \$\\2?".'>', $form);
		$fd = fopen ("$form_file", "w");
		fputs ($fd, $form);
		fclose ($fd);

# Else : Restore file if UNDO has been requested
# ---------------------------------------
	} elseif (isset($undo)) {
		if (file_exists ("$form_file.bak.$ext")) {
			copy ("$form_file.bak.$ext", "$form_file");
		}
	}

# Now loads the file into the editable field
# ------------------------------------------
	$form = "";
	if (file_exists ($form_file)) {
		$form_title = "<em>" . LABEL_FILE_EDITING . ": $form_file </em>";
		$fd = fopen("$form_file","r");
		while ($line = fgets($fd, 256) ) {
			$form .= $line;
		} 
		fclose($fd);
	} else {
		$form_title = "<em>" . LABEL_NEW_FILE_EDITING . " $form_file </em>";
		if (file_exists ("$bn_dir_default/$file.$ext")) {
			copy ("$bn_dir_default/$file.$ext", "$form_file");
			$fd = fopen("$form_file","r");
			// $form = fread ($fd, filesize ("$form_file"));
			while ($line = fgets($fd, 256) ) {
				$form .= $line;
			} 
			fclose($fd);
		}
	}

# convert template variables : <?echo $x ? > to {x}
# -------------------------------------------------
	$form = ereg_replace("<"."\\? *echo \\$"."([a-zA-Z0-9_]+)[; ]*\\?".">", "{\\1}", $form);

# Displays the FORM
# -----------------
	display_header ($page_title);
	echo "<center>$page_info</center><br>";
	table_header ("$form_title");
	beginForm();
	hiddenField ("file", $file);	// holds file name (form, header, footer, ...)
	hiddenField ('editdefault', $editdefault);
	hiddenField ('editsite', $editsite);
	textArea ("form", HtmlSpecialChars($form), 25, 80);
	br();
	submitButton ("save", LABEL_SAVE);
	resetButton ("reset", LABEL_RESET);
	submitButton ("undo", LABEL_UNDO);
	print "</CENTER>";
	endForm();
	table_footer();
?>
