<?php

/*
 *	W-AGORA 4.1
 *	-----------
 *	$Id: export.php,v 1.13 2005/02/09 11:58:46 mdruilhe Exp $
 *	Usage:		export (displays) the whole contents of a forum/thread into an external viewer (msword)
 *	Author:		Syloo <syloo@w-agora.net>
 */	

	$bn_action="export";
	$bn_action_mode="R";
	$in_navigator = 1;
	$no_cookie=1;
	require ("init.inc");
	if (empty($bn)) {
		msgForm ("You must specify a forum", "$main_page", "", "_top");
		exit;
	}

	function display_note ($key) {
		global $msg, $inc_dir, $ext, $site, $bn, $db, $auth, $bn_db, $bn_action, $bn_pad;
		global $bn_dir, $bn_base_url, $bn_dir_notes, $bn_dir_default, $icon_dir, $bn_before_access, $bn_doc_var;
		global $bn_user_mail, $bn_thread, $bn_modify, $bn_delete, $is_moderator;
		global $bn_win_width, $bn_win_height;

		$has_children=is_array($db->children[$key]);

		$bn_action="view";

		// evaluate all variables
		if ($key>0) {
			extract ($db->entries[$key]);
		}

		// we don't display key 0 (administrative note)
		// and don't display old notes (if list only new)
		if ( ($hidden && $auth->level<MODER) || ($key == 0) ) {
			$hidden_note = true;
		} else {
			if (!empty($bn_before_access)) {
				if (file_exists ("$bn_dir/$bn_before_access") ) {
					include "$bn_dir/$bn_before_access";
				} else {
					include "$bn_dir_default/$bn_before_access";
				}
			} elseif (file_exists ("$bn_dir_default/before_access.$ext") ) {
				include ("$bn_dir_default/before_access.$ext");
			}
			printf ("\n<a name=\"N%s\"></a>\n", $key);

			# Sets the text for attachments if any
			# ------------------------------------
			$att = $db->getAttachments ($bn_db, $key);
			if (is_array($att)) {
				$export_att_text = sprintf ("%s attachments in <a href='$bn_base_url/view.$ext?bn=$bn&key=$key'>original note</a>", count($att) );
			}

			# Display message
			# ---------------
			$formated_date = formated_date ($unixdate);
			if (isSet($body)) {
				$body = format_text(strip_smileys($body));
			}
			$doc=str_replace('"','\"', $bn_doc_var);
			eval ("print stripSlashes(\"$doc\n\");");
		}

		if ( is_array($db->children[$key]) ) {
			// display all replies to this thread
			reset ($db->children[$key]);
			while ( $child=current($db->children[$key]) ) {
				$nextchild = next($db->children[$key]);
				if ($parent == 0) {
					print "<center><table width='90%'><tr><td align='right'>";
					printf ("<a name=\"T%s\"></a><div align=\"right\">", $child);
					if ($nextchild) {
						printf ("<a href=\"#T${nextchild}\">%s</a>", ALT_NEXT_THREAD);
						printf (" | <a href=\"#top\">%s</a></div>\n", LABEL_TOP);
						echo "<HR>";
					}
					print "</td></tr></table></center>";
				}
				display_note ($child);
			}
		}
	}

# Gets listing outline
# --------------------
	if (!empty($bn_list_vars) && file_exists ("$bn_dir/$bn_list_vars") ) {
		include "$bn_dir/$bn_list_vars";
	} elseif (file_exists ("$bn_dir_default/list.$ext") ) {
		include ("$bn_dir_default/list.$ext");
	}

# Set listing outline in digest mode (backward compatibility)
# -----------------------------------------------------------
	$export_thread_word_url = "export.$ext?bn=$bn&action=export&thread=\$thread";
	$export_thread_word_text = " -&gt; MsWord";
	$export_thread_word_link = anchor ($export_thread_word_url, $target_frame, $export_thread_word_text, "export MsWord" );


	if (empty($bn_digest_even_first_line) ) { // even first line should not be empty if defined
		$bn_digest_header = "<div align=left><ul>";
		$bn_digest_odd_first_line = "<li><font size=-1>\$formated_date</font> <a href='#N\$key'><em>\$subject</em></a> (\$username) [ $export_thread_word_link ]";
		$bn_digest_even_first_line = "<li><font size=-1>\$formated_date</font> <a href='#N\$key'><em>\$subject</em></a> (\$username) [ $export_thread_word_link ]";
		$bn_digest_begin_level = "<ul>";
		$bn_digest_odd_line = "<li><font size=-1>\$formated_date</font> <a href='#N\$key'><em>\$subject</em></a> (\$username)";
		$bn_digest_even_line = "<li><font size=-1>\$formated_date</font> <a href='#N\$key'><em>\$subject</em></a> (\$username)";
		$bn_digest_end_level = "</ul>";
		$bn_digest_footer = "</ul></div>";
	}

# include Note template
# ----------------------
	if (!empty($bn_template) && file_exists ("$bn_dir/$bn_template") ) {
		include "$bn_dir/$bn_template";
	} elseif (file_exists ("$bn_dir_default/template.$ext") ) {
		include ("$bn_dir_default/template.$ext");
	}

	$title = (empty($thread)) ? "Export complete forum" : "Export thread";

	/* Execute before_access program */
	if (!empty($bn_before_access)) {
		if (file_exists ("$bn_dir/$bn_before_access") ) {
			include "$bn_dir/$bn_before_access";
		} else {
			include "$bn_dir_default/$bn_before_access";
		}
	} elseif (file_exists ("$bn_dir_default/before_access.$ext") ) {
		include ("$bn_dir_default/before_access.$ext");
	}
	
	/* export: send msword header to navigator when action is "export"  */
	if ($action == "export") {
		$in_navigator = 0;
		$content_type = "application/msword";
		$filename = "export.html";
		// header ("Content-length: $size");
		// header ("Content-Type: $content_type");
		// header ("Content-Disposition: filename=\"$filename\"");
		if (strstr($HTTP_USER_AGENT,"MSIE 5") && !strstr($HTTP_USER_AGENT,"Opera")) {
			header ("Content-Type: $content_type");
			header ("Content-Disposition: filename=\"$filename\"");
		} else {
			header ("Content-Type: $content_type; name=\"$filename\"");
			header ("Content-Disposition: attachment; filename=\"$filename\"");
		}
	}

	print ("<a name=\"top\"></a>");

# Displays form to select date range
# ----------------------------------
	if ($in_navigator) {
		$unit = (isset($unit)) ?  $unit : "7";
		if ( 0 == (integer)$unit ) {
			$period = "";
		} else {
			$period = (empty($period)) ? "1" : $period;
		}
		display_header ($title, $header_footer);
		beginForm($WA_SELF, "get");
	    dspMsg (LABEL_SHOW_ACTIVE_THREADS);
		textField ("period", $period, 3);
		$units = array (
					"0" => LABEL_SHOW_ALL,
					"1" => LABEL_DAYS,
					"7" => LABEL_WEEKS,
					"30" => LABEL_MONTHS
				);
		listBox ("unit", $units, $unit);
		print "<br>&nbsp;&nbsp;";
		submitButton ("action", LABEL_GO);
		submitButton ("action","export");
		endForm();
	}
	
# gets all notes from the forum
# -----------------------------
	$thread = (isset($thread)) ? (integer) $thread : 0;

	if ($period>0) {
		$last = $now - ($period * $unit * 24*60*60);
	} else {
		$last = 0;
	}

	$totalnotes = $forum["totalnotes"];

	if ($totalnotes == 0) {
		msgWarning (sprintf(ERROR_NO_ENTRY_FOUND, $msg[0]));
		echo "</body></html>";
		exit;
	}

	$list_var["body"]=1;
	$expnd="all";
	if (!empty ($thread) ) {
		$ret = $db->getThread ($bn_db, $thread, $thread);
		$notes = $ret;
		$threads =1;
	} else {
		$ret = $db->listThreads ($bn_db, O, $last, "", 1, 0);
		$notes = $ret["notes"];
		$threads = $ret["threads"];
	}

# displays notes listing
# -----------------------
	if ($ret < 0) {
		echo "<CENTER><strong>"; printf(ERROR_DATABASE, $ret); echo "</STRONG></CENTER>";
	} elseif ($notes > 1) {
		$db->displayList ($thread, "digest");
	}

# Now display each individual note
# --------------------------------
	$bn_action="view";

	$bn_doc_var="<p><center><table border=0 cellpadding=0 cellspacing=0 width=\"90%\"><TR><td class='border'>\n<table width=100% border=0 cellspacing=1 cellpadding=4>\n<TR>\n<TD class=\"entetetableau\" width='18%'>\n \$GLOBALS[m_author]\n</TD>\n<TD class='entetetableau'>\n \$GLOBALS[m_subject]:&nbsp;&nbsp; \$subject</B></FONT>\n</TD>\n</TR>\n<tr>\n <TD class='message' width='18%' valign=top>\n<B><A HREF=\"\$profile_url&showuser=\$userid\">\$username</A></B><BR>\$pays</td>\n <TD class='message'>\n<FONT color=\"#000080\"><SMALL>\$GLOBALS[m_sent] \$formated_date</SMALL></FONT> &nbsp;<HR size=1>\n   \$body\n <br><center>\$export_att_text</center>\n</td>\n</tr>\n</TABLE></TD></TR></TABLE>\n</center>\n ";

	if (is_array($db->entries)) {
		reset($db->entries);
		display_note($thread);
	}

# Display footer
# --------------
	if ($in_navigator) {
		display_footer ($header_footer);
	}
?>
