<?PHP

/*
 *	W-AGORA 4.0
 *	-----------
 *	$Id: dbsearch.php,v 1.20 2005/01/27 23:32:38 mdruilhe Exp $
 *	Usage:		include file - Class: DBSearch : search in database
 *	Authors:	Marc Druilhe <mdruilhe@w-agora.net>
 */

class DBsearch {

/**
 * search in forums 
 *
 * @param	string 		$pattern		The string to search for
 * @param	string 		$forum			The forum into which performing the search, 
 *										if empty search in all forums
 * @param	integer		$search_type	search mode : 0= all words, 1=any word, 2=exact phrase
 * @param	array 		$search_fields	List of the fields into performing search
 * @param	string 		$userid			If set then search only posts made by userid 
 * @param	integer 	$date			Starting date
 * @param	integer 	$limit			Maximum number of results
 * @returns	integer		Number of results, negative value in case of error
 */
function search ($pattern, $forum="", $search_type=0, $search_fields="", $where="", $limit=0, $casesensitive=0) {
	global $db, $site, $ext, $lang;
	global $img_dir, $icon_dir, $cfg_dir, $bn_dir_default, $site_cfg_file;
	global $label_posted_by_on, $label_read_more;

	$bn_action = "search";
	$bn_action_mode="S";

# gets all forums => load $forums[] with all table names in this site
# -------------------------------------------------------------------
	$query = "SELECT distinct bn_db, bn_name, type, bn_title FROM $site WHERE state != '0' AND category=0";
	if (is_array($forum) ) {
		$f = implode ("','", $forum);
		$query .= " AND bn_name in ('$f')";
	} elseif (!empty($forum) ) {
		$query .= " AND bn_name='$forum'";
	}

	$result = $db->query ($query);
	while ($db->next_record() ) {
		$table = $db->Record["bn_db"];
		$forums[$table] = $db->Record;
	}

	if (!is_array ($forums) ) {
		return -1;
	}

 # start search against all selected forums
 # ----------------------------------------
	// $cols = "cle,thread,newest,unixdate,childs,subject,username " . implode (",", $search_fields);
	//$cols= "*";
	$total=0;
	
	include "$site_cfg_file";
	if (empty($bn_list_vars) ) {
		include "$bn_dir_default/list.$ext";
	} else {
		include "$bn_dir/$bn_list_vars";
	}
	$forum_title = str_replace('"', '\"', $bn_search_forum_title );
	reset ($forums);
	while (list($t, $forum) = each ($forums) ) {
		$bn = $forum["bn_name"];
		$bn_title = $forum["bn_title"];
		$lineNo = 0;
		if ( ($forum["type"]=="priv") && ! $GLOBALS['auth']->havePermission($bn, "L") ) {
		    continue;
		}

# If a specific template has been defined, load it
# ------------------------------------------------
		$cfg_file = "$cfg_dir/$bn.$ext";
		unset ($bn_fields);
		unset ($bn_list_vars);
		unset ($list_var);
		if (file_exists ("$cfg_file")) {
			include ("$cfg_file");
		}

		if (empty($bn_fields) ) {
			include ("$bn_dir_default/fields.$ext");
		} else {
			include "$bn_dir/$bn_fields";
		}
		$cols = "cle,thread,newest,childs";
		$list_var["unixdate"]=1;
		reset($list_var);
		while (list($var,$val) = each($list_var)) {
			if ($val==1) $cols.=",$var";
		}

		if (empty($bn_list_vars) ) {
			include "$bn_dir_default/list.$ext";
		} else {
			include "$bn_dir/$bn_list_vars";
		}
		
		$column_author		= COLUMN_AUTHOR;
		$column_subject		= COLUMN_SUBJECT;
		$column_date		= COLUMN_DATE;
		$column_description	= COLUMN_DESCRIPTION;
		$column_downloads	= COLUMN_DOWNLOADS;
		$label_read_more	= LABEL_READ_MORE;

		// preserve double quotes in templates and set local template variables
		$header = str_replace('"', '\"', $bn_search_header);
		$odd_line = str_replace('"', '\"', $bn_search_odd_first_line);
		$even_line = str_replace('"', '\"', $bn_search_even_first_line);
		$footer = str_replace('"', '\"', $bn_search_footer);

		// Set default fields to search in
		if (!is_array ($search_fields) ) {
			$search_fields = array ("subject", "body", "username", "useraddress");
		}

		if (!empty($bn_before_access)) {
			if (file_exists ("$bn_dir/$bn_before_access") ) {
				include "$bn_dir/$bn_before_access";
			} else {
				include "$bn_dir_default/$bn_before_access";
			}
		} elseif (file_exists ("$bn_dir_default/before_access.$ext") ) {
			include ("$bn_dir_default/before_access.$ext");
		}

		// build Where clause
		$whereclause = $db->buildSearchWhereClause ($pattern, $search_fields, $search_type, $casesensitive, $where);

		$result = $db->query ("SELECT DISTINCT $cols FROM $t WHERE $whereclause ORDER BY unixdate DESC");
		if ($db->next_record()) {
			eval ("echo stripSlashes(\"$forum_title\");");
			eval ("echo stripSlashes(\"$header\");");
			if ($search_type == 2) {
			    $pattern = '"'.$pattern.'"';
			}
			$urlpattern=urlencode($pattern);
			do {
				$key = $db->Record["cle"];
				$total++;
				$lineNo++;
				extract ($db->Record);
				$formated_date = formated_date ($unixdate);
				$body = format_text($body);
				$view_url = "view.$ext?bn=$bn&key=$key&pattern=$urlpattern";
				$show_profile_url = "";
				$show_profile_link = "";
				if ($userid != "guest") {
					$show_profile_url = "profile.$ext?bn=$bn&showuser=$userid";
					$show_profile_text = msg(145, "<img src=\"$icon_dir/show_profile.gif\" width=15 height=15 border=0>");
					$show_profile_link = anchor ($show_profile_url, "", $show_profile_text, sprintf (ALT_SHOW_PROFILE, $userid) );
					$label_posted_by_on = sprintf(LABEL_POSTED_BY_ON, "<a href=\"$show_profile_url\">$userid</a>", $formated_date);
				} else {
					$label_posted_by_on = sprintf(LABEL_POSTED_BY_ON, "$username (GUESTUSER_USERNAME)", $formated_date);
				}

				// before line script
				if (!empty($bn_before_line) ) {
					eval ($bn_before_line);
				}

				// display line
				if ($lineNo % 2) {
					eval ("echo stripSlashes(\"$odd_line\");");
				} else {
					eval ("echo stripSlashes(\"$even_line\");");
				}

			} while ($db->next_record());
			
			eval ("echo stripSlashes(\"$footer\");");
		}
	}
	return $total;
}

} // end Class

?>
