<?php

/*
 *	W-AGORA 4.0
 *	-----------
 *	$Id: htmlarea.php,v 1.3 2003/12/24 16:49:08 mdruilhe Exp $
 *	Usage:	HTMLArea 3.0 Wysigyg editor handling (see http://sf.net/projects/itools-htmlarea/)
 *	Author:	Marc Druilhe <mdruilhe@w-agora.net>
 *
 */

# Disable htmlarea if HTML not allowed or module not installed
# ------------------------------------------------------------
	if (!file_exists(HTMLAREA_DIR."/htmlarea.js") || empty($bn_allow_html) ) {
		$use_htmlarea = 0;
		return;
	}

	$browser = $HTTP_SERVER_VARS['HTTP_USER_AGENT'];
	if (! @preg_match("/(msie|gecko)/i", $browser)) {
		$use_htmlarea = 0;
		return;
	}
	if (preg_match("/opera/i", $browser)) {
		$use_htmlarea = 0;
		return;
	}

# Set the HTMLAREA language according to the w-agora current settings
# -------------------------------------------------------------------
	if ( isset($lang) && file_exists(HTMLAREA_DIR."/lang/$lang.js") ) {
		$htmlarea_lang = $lang;
	} elseif ( isset($default_lang)&& file_exists(HTMLAREA_DIR."/lang/$default_lang.js") ) {
		$htmlarea_lang = $default_lang;
	} else {
		$htmlarea_lang = 'fr';
	}
?>

<style type="text/css">
@import url("<?echo HTMLAREA_DIR?>/htmlarea.css");
</style>

<script type="text/javascript" language="javascript">
<!-- // Hide for old browsers
var _editor_url = "<?echo HTMLAREA_DIR?>";
// End of script -->
</script>

<script type="text/javascript" src="<?echo HTMLAREA_DIR?>/htmlarea.js"></script>
<script type="text/javascript" src="<?echo HTMLAREA_DIR?>/lang/<?echo $htmlarea_lang?>.js"></script>
<script type="text/javascript" src="<?echo HTMLAREA_DIR?>/dialog.js"></script>

<script type="text/javascript" language="javascript">
 <!-- // Hide for old browsers

var _use_htmlarea = false;

var myConfig = new HTMLArea.Config();

if (myConfig) {
	_use_htmlarea = true;
}

myConfig.width =  "600";
myConfig.height = "250";
// myConfig.killWordOnPaste = true;

myConfig.pageStyle =
  'body { background-color: #FFFFFF; color: black; font-family: verdana,sans-serif; font-size: x-small; margin: 0.5em} ' +
  'p {margin-top: 0.2em; margin-bottom: 0em; } ';


/* Default config
myConfig.toolbar = [
	[ "fontname", "space",
	  "fontsize", "space",
	  "formatblock", "space",
	  "bold", "italic", "underline", "separator",
	  "strikethrough", "subscript", "superscript", "separator",
	  "copy", "cut", "paste", "space", "undo", "redo" ],
	
	[ "justifyleft", "justifycenter", "justifyright", "justifyfull", "separator",
	  "insertorderedlist", "insertunorderedlist", "outdent", "indent", "separator",
	  "forecolor", "hilitecolor", "textindicator", "separator",
	  "inserthorizontalrule", "createlink", "insertimage", "inserttable", "htmlmode", "separator",
	  "popupeditor", "separator", "showhelp", "about" ]
];

*/

myConfig.toolbar = [
	[ "fontname", "space",
	  "fontsize", "space",
	  "bold", "italic", "underline", "separator",
	  "forecolor", "hilitecolor", "textindicator", "separator",
	  "justifyleft", "justifycenter", "justifyright", "justifyfull", "separator",
	  "insertorderedlist", "insertunorderedlist", "outdent", "indent", "separator",
      "inserthorizontalrule", "htmlmode"
	  ],
];

myConfig.statusBar = false;

/* Smileys
function insertSmiley(editor, smiley) {
	editor.focusEditor();
	editor.insertHTML('<img src="<?echo $icon_dir?>/' + smiley + '.gif" border=0 align="absmiddle">');
};

myConfig.registerButton ("icon7", ":-)", "<?echo $icon_dir?>/icon7.gif", false, insertSmiley);
myConfig.registerButton ("icon28", ":lol:", "<?echo $icon_dir?>/icon28.gif", false, insertSmiley);
myConfig.registerButton ("icon30", ":fou:", "<?echo $icon_dir?>/icon30.gif", false, insertSmiley);
myConfig.registerButton ("icon12", ";-)", "<?echo $icon_dir?>/icon12.gif", false, insertSmiley);
myConfig.registerButton ("icon38", ":sweat:", "<?echo $icon_dir?>/icon38.gif", false, insertSmiley);

// add the new button to the toolbar
myConfig.toolbar.push(["linebreak", "icon7", "icon28", "icon30", "icon12", "icon38" ]);
*/

// End of script -->
</script>
