<?PHP

/*
 *	W-AGORA 4.0
 *	-----------
 *	$Id: namazu.php,v 1.2 2002/07/22 14:11:54 mdruilhe Exp $
 *	Usage:		include file - Document indexing using namazu
 *	Author:		Jun Kuwamura <juk@rccm.co.jp>
 */

/* 
 * From namazu README.en:
 *
 *  Namazu is a search engine software intended for easy use.  Not
 *  only it works as CGI program for small or medium scale WWW search
 *  engine, but also works as personal use such as search system for
 *  local HDD.  Now, search clients for Mule and Tcl/Tk, JAVA and
 *  Win32 are available.
 *
 *  You can get latest news about Namazu from:
 *   <URL:http://saturn.aichi-u.ac.jp/%7Eccsatoru/Namazu/>
 */

class namazu {

	/***********************************/
	/*  Initialize NAMAZU Config. File  */
	/***********************************/

Function initSearchConf () {
  global $bn_dir;
  global $bn_dir_notes;

  $namazu_conf = "$bn_dir/namazu.conf"; 
  if (file_exists ("$namazu_conf"))
    copy ("$namazu_conf", "$namazu_conf.bak"); 

  $fp = @fopen ($namazu_conf, "w+");
  if (!$fp) return (-2);

fputs($fp, "# This is the Namazu configuration file.\n");
fputs($fp, "#   originally, this file is named 'namazu.conf-dist'. so you should\n");
fputs($fp, "#   copy this to 'namazu.conf' to use.\n");
fputs($fp, "#\n");
fputs($fp, "#   item and value are MUST be separated with TAB character.\n");
fputs($fp, "#   see \"manual.html#NAMAZU_CONF\" for detailed information.\n");
fputs($fp, "#     <Item List>\n");
fputs($fp, "#       * INDEX   : Pathname where index file (NMZ.*) is placed.\n");
fputs($fp, "#       * REPLACE : Replace URL string for search result output.\n");
fputs($fp, "#                   describe by FROM TO order. if you do not want to \n");
fputs($fp, "#                   do this replacement in command line use, you can\n");
fputs($fp, "#                   run 'namazu' with -U option and avoid this processing.\n");
fputs($fp, "#       * BASE    : append <BASE HREF=\"...\"> to search result HTML.\n");
fputs($fp, "#                   this value must terminate with '/' or '\' character.\n");
fputs($fp, "#       * WAKATI  : Japanese processor's pathname.\n");
fputs($fp, "#                   (KAKASI or ChaSen you defined at make time)\n");
fputs($fp, "#       * LOGGING : set OFF to turn off search keyword logging. \n");
fputs($fp, "#                   default: logging ON (to NMZ.slog)\n");
fputs($fp, "#	* LANG    : set language JAPANESE or ENGLISH.\n");
fputs($fp, "#\n");
$doc_root=getenv("DOCUMENT_ROOT");
$req_uri=getenv("REQUEST_URI");
$req_dir=dirname($req_uri);
$svr_name=getenv("SERVER_NAME");
$svr_port=getenv("SERVER_PORT");
fputs($fp, "INDEX	$doc_root$req_dir/$bn_dir/index.namazu\n");
fputs($fp, "REPLACE	$bn_dir_notes	http://$svr_name:$svr_port/$req_dir/$bn_dir_notes\n");
#fputs($fp, "BASE	file://localhost/$doc_root$req_dir/$bn_dir_notes\n");
fputs($fp, "BASE	http://$svr_name:$svr_port/$req_dir/$bn_dir_notes\n");
fputs($fp, "WAKATI	/usr/local/bin/kakasi\n");
fputs($fp, "#LOGGING	OFF\n");
fputs($fp, "LANG	JAPANESE\n");

# test
#$req_uri=getenv("REQUEST_URI");
#fputs($fp, "#REQUEST_URI	$req_uri\n");
#$http_ref=getenv("HTTP_REFERER");
#fputs($fp, "#HTTP_REFERER	$http_ref\n");

  fclose ($fp);
  return (0);
}

// remove configuration & index files
function removeConf() {
	global $bn_dir;

	unlink ("$bn_dir/namazu.conf");
	$indexfile = $bn_dir+"/index.namazu";
	if (FileInode ("$indexfile") > 0) {
		if (FileType ("$indexfile") == "dir") {
			$fileidx = OpenDir ("$indexfile");
			while ($fileidx) {
				unlink("$indexfile/$fileidx");
				$fileidx = ReadDir ();
			}
			CloseDir();
			rmdir ("$indexfile");
		} else {
			unlink ("$indexfile"); 
		}
	}
	if (FileInode ("$bn_dir/namazu.conf.bak") > 0) {
		unlink ("$bn_dir/namazu.conf.bak");
	}
}

Function IndexNotes() {
  global $bn_search_path;
  global $bn_dir;
  global $bn_dir_notes;

  $namazu_conf = $bn_dir+ "/namazu.conf";
  $inode = fileinode($namazu_conf);
  if ($inode < 0) {
    system ("nohup $bn_search_path -d $bn_dir_notes $bn_dir/index.namazu ../../.. >/dev/null 2>&1 &"); 
  } else {
    system ("nohup $bn_search_path -i $bn_dir_notes $bn_dir/index.namazu ../../.. >/dev/null 2>&1 &"); 
  }
  return (0);
}

Function search ($pattern, $casesensitive) {
	global $bn_search_path;
	global $bn_dir;
	global $msg;

	if (!file_exists ($bn_search_path))
		return (-1); 

	$namazu_conf = "$bn_dir/namazu.conf"; 
	$namazu_out = "$bn_dir/namazu_out.html";

	exec ("$bn_search_path -f $namazu_conf '$pattern' '$namazu_out'",$result);
	include "$namazu_out";
	return (0);
}

}; // end class

$search = new namazu;

?>
