<?

/* 
 *   W-AGORA
 *   -------
 *   File:	swish.php
 *   Usage:	include file - Document indexing using swish
 *   date:	March 1999
 *   version:	3.0.0b3
 *   Author:	Marc Druilhe <mdruilhe@araxe.fr>
 *
 */   

class swish {

// initialize configuration file
function initSearchConf () {
  global $bn_dir;
  global $bn_dir_notes;

  $swish_conf = "$bn_dir/swish.conf"; 

  if (file_exists ("$swish_conf"))
    copy ("$swish_conf", "$swish_conf.bak"); 

  $fp = @fopen ($swish_conf, "w+");
  if (!$fp)
    return (-2);

  fputs($fp, "#  SWISH configuration file\n");
  fputs($fp, "IndexDir $bn_dir_notes\n");
  fputs($fp, "IndexFile $bn_dir/index.swish\n");
  fputs($fp, "IndexReport 3\n");
  fputs($fp, "FollowSymLinks yes\n");
  fputs($fp, "NoContents .ps .gif .au .hqx .xbm .mpg .pict .tiff\n");
/*  fputs($fp, "ReplaceRules replace \"$bn_dir_notes\" \"$bn_url_notes\"\n"); */
  fputs($fp, "FileRules filename is index.swish\n");
  fputs($fp, "FileRules filename is swish.conf\n");
  fputs($fp, "FileRules filename contains # % ~ admin. .db .out .pag .lck .dir .bak .orig .old .tmp\n");
  fputs($fp, "FileRules directory contains .htaccess\n");
  fputs($fp, "IgnoreWords SwishDefault\n");
  fclose ($fp);
  return (0);
}

// remove configuration & index files
function removeConf() {
	global $bn_dir;

	@unlink ("$bn_dir/swish.conf");
	@unlink ("$bn_dir/index.swish");
	@unlink ("$bn_dir/swish.conf.bak");
	@unlink ("$bn_dir/swish.out");
}

// launch indexing
function indexNotes() {
	global $bn_search_path;
	global $bn_dir, $bn_dir_notes;

	$swish_conf = "$bn_dir/swish.conf";
	if (!file_exists ($bn_search_path))
		return (-1); 
	if (file_exists ($swish_conf)) 
		exec ("nohup $bn_search_path -c $swish_conf >$bn_dir/swish.out 2>&1 &"); 
	else
		exec ("nohup $bn_search_path -i $bn_dir_notes -f $bn_dir/index.swish >$bn_dir/swish.out 2>&1 &"); 
	return (0);
}

function search ($pattern, $casesensitive) {
	global $bn;
	global $bn_search_path;
	global $bn_dir, $bn_dir_notes;
	global $msg;

	if (!file_exists ($bn_search_path))
		return (-1); 

	exec ("$bn_search_path -f $bn_dir/index.swish -w '$pattern' |/usr/bin/grep '^[0-9].*'", $result);
	$num = count ($result);
	if ($num == 0) {
	    echo "<p><center><h2>" . sprintf(MSG_NO_MATCHES, $msg[0]) . "</center></h2>";
		return (0);
	}
	echo "<p><h2>" . str_replace('{MSG}', $msg[0], str_replace('{NUM}', $num, LABEL_MATCHES_FOUND)) . "</h2><p>";
	echo "<center><table border=2><tr><th>".COLUMN_ATTACHMENTS ."</th><th>".COLUMN_SIZE."</th><th>".COLUMN_SCORE."</th></tr>";
	for ($i=0; $i<$num; $i++) {
		$score = strtok ($result[$i], " " );
		$file = strtok (" ");
		$file = ereg_replace ("$bn_dir_notes/", "", $file);
		if (ereg ("/", $file)) {
			$key = strtok ($file, "/");
			$url="getfile.$ext?bn=$bn&key=$key";
		}
		else {
			$key = ereg_replace(".html", "", $file);
			$url="view.$ext?bn=$bn&key=$key";
		}
		$tmp = strtok ($result[$i], "\"");
		$desc = strtok("\"");
		$size = strrchr($result[$i]," ");
		echo "<tr><td><a href=\"$url\"> $desc </a></td><td align=center>$size</td><td align=center>$score</td></tr>";
	}
	echo "</table></center><HR>";
	return (0);
}

};

$search = new swish;
?>
