<?php

/*
 *	W-AGORA 4.1
 *	-----------
 *	$Id: mail.php,v 1.4 2005/01/27 23:23:42 mdruilhe Exp $
 *	Usage:		Send email to users
 *	Authors:	Laurent Aufrre <laurent.aufrere@free.fr>
 *
 */

function exit_form ($title="", $msg="") {
	global $ext, $header_footer, $before_access;
	global $popup,$redirect;
	global $site,$bn,$key,$userid;
	if ($popup) $action="close";
	if (!isset($HTTP_POST_VARS)) {
		if ($redirect=="profile") {
			$redirect.=".$ext?site=$site&bn=$bn&showuser=$userid";
		} else {
			$redirect.=".$ext?site=$site&bn=$bn&key=$key";
		}
	}
	if (!empty($before_access)) include $before_access;
	display_header ($title, $header_footer);
	msgForm ($msg, $redirect,$action);
	display_footer ($header_footer);
	exit;
}

if (empty($bn)) {
	$bn_acion_mode = 'R';
} else {
	$bn_action_mode = 'W';
}

$bn_action="mail";
$popup=1;
require ("init.inc");

	
# A site must be selected
# -----------------------
	if ($site == "agora") {
		header ("Location: $main_page");
		exit;
	}

# A forum must be selected except if mailing to a specified user
# --------------------------------------------------------------
	if (!isset($userid) && empty($bn)) {
		msgForm (ERROR_NO_FORUM_SPECIFIED, "$main_page", "");
		exit;
	}

# Check if the user is authenticated in this site otherwise redirect him to the login form
# ----------------------------------------------------------------------------------------
	if (!$is_authenticated) {
		$loginURL = $auth->getLoginURL();
		if (is_string($loginURL)) {
			header("Location: $loginURL");
		} else {
			if (!empty($bn_before_access)) {
				if (file_exists ("$bn_dir/$bn_before_access") ) {
					include "$bn_dir/$bn_before_access";
				} else {
					include "$bn_dir_default/$bn_before_access";
				}
			} elseif (file_exists ("$bn_dir_default/before_access.$ext") ) {
				include ("$bn_dir_default/before_access.$ext");
			}
			display_header ("login", $header_footer);
			$auth->login($site);
			display_footer ($header_footer);
		}
		exit;
	}

# Set the return page
# -------------------
	switch ($redirect) {
		case "list":
		case "view":
		case "profile":
		case "users":
			break;
		default:
			$redirect="list";
			break;
	}


# Set addresses depending of the type of mail and do some checkings
# -----------------------------------------------------------------

	if ($type=="author" || $type=="moderator") {

		# If note is not defined then return to the list
		# ------------------------------------------------------
		if (empty($key)) {
			$redirect = "list";
			exit_form ("error", ERROR_SPECIFY_KEY);
		}

		# Read note from database and get author infos, exit if error
		# --------------------------------------
		$note = $db->getNote ($bn_db, $key, $where, $threads_order);
		if ($note < 0) {
			$redirect="list";
			exit_form ("error", sprintf(ERROR_NOTE_NOT_FOUND, $msg[0]));
		}

		# (4.0) Exit with error if this note is hidden
		# --------------------------------------------
		if (!$is_moderator && ($note['hidden'] == '1') ) {
			$redirect="list";
			exit_form ('forbidden', ERROR_FORBIDDEN_ACCESS);
		}

		if ($type=="author") {
		
			# Check if private mails are allowed
			# -----------------------------------
			if (!$bn_private_mail && !$is_moderator) {
				error_exit ('disabled',ERROR_PRIVATE_MAIL_DISABLED);
				exit;
			}

			# Check mail addresses
			# --------------------
			if ($note['userid']=='guest') {
				$dest_userids[] = GUESTUSER_USERNAME;
				$mail_to[]=$note['useraddress'];
			} else {
				$author=$db->getUser($site,$note['userid']);
				if (is_array($author)) {
					$dest_userids[]=$author['userid'];
					if ($author['mailok']) {
						$mail_to[]=$author['useraddress'];
					} else {
						exit_form('no mail wanted',sprintf(LABEL_USER_NOT_MAILED,$note['userid']));
					}
				} else {
					exit_form('no user',sprintf(ERROR_NO_MATCHING_USER,$note['userid']));
				}
			}
	
		} else {
	
			# Check mail addresses
			# --------------------
			$admins = $db->getAdministrators($site);
			if (is_array($admins) ) {
				reset ($admins);
				while (list (, $m) = each ($admins) )  {
					$mail_to[] = $m["useraddress"];
					$dest_userids[] = $m['userid'];
				}
			}
			
			$mods = $db->getModerators($site, $bn);
			if (is_array($mods) ) {
			  reset ($mods);
			  while (list (, $m) = each ($mods) )  {
				  $mail_to[] = $m["useraddress"];
				  $dest_userids[] = $m['userid'];
			  }
			}
		}

	} elseif ($userid!="") {
		$dest_user=$db->getUser($site,$userid);
		if (is_array($dest_user)) {
			if ($dest_user['mailok']) {
				$mail_to[]=$dest_user['useraddress'];
				$dest_userids[] = $dest_user['userid'];
			} else {
				exit_form('no mail wanted',sprintf(LABEL_USER_NOT_MAILED,$dest_user['userid']));
			}
		} else {
			exit_form('no user',sprintf(ERROR_NO_MATCHING_USER,$dest_user['userid']));
		}
	} else {
		exit_form('no type',ERROR_NO_MAIL_TYPE);
	}

	if (is_array($mail_to)) {
			foreach ($mail_to as $i=>$m) {
				if (empty($m) || !validate_email($m, MAIL_CHECK_DNS)) unset($mail_to[$i]);
			}
		}
	
	if (empty($mail_to)) exit_form('no valid address', ERROR_NO_ADDRESS);

	$mail_from = $auth->user["useraddress"];

	$dest_userids=implode(",",$dest_userids);


# Execute before_access program
# -----------------------------
	if (!empty($before_access)) include $before_access;

# send Message if FORM has been filled
# ------------------------------------
	if (isset($go)) {
		
		$go=0;

		require ("$inc_dir/mail.$ext");

		$ret=@mail_users ($mail_to, $msgsubject, $msgbody, $mail_from);
		
		if ($ret) {
			$msg=sprintf(LABEL_MAIL_USER_OK,$dest_userids);
		} else {
			$msg=sprintf(LABEL_MAIL_USER_NO_OK,$dest_userids);
		}
		exit_form('result',$msg);
	}

	$form_title=sprintf(TITLE_MAIL_FORM,$dest_userids);
	$msgsubject = (isset($msgsubject)) ? $msgsubject : "";
	$msgbody = (isset($msgbody)) ? $msgbody : "";

# Displays FORM
# -------------
	display_header (LABEL_MAIL . " $forum_name",$header_footer);
	
	beginForm();
	hiddenField ("popup", $popup);
	hiddenfield ("type", $type);
	hiddenfield("key",$key);
	hiddenfield("userid",$userid);
	hiddenfield("redirect",$redirect);

	hiddenfield("go","go");
	if (!empty($bn_mail_form) && file_exists("${bn_dir}/${bn_mail_form}") ) {
		include "${bn_dir}/${bn_mail_form}";
	} elseif ( file_exists("${bn_dir_default}/mail_form.$ext") ) {
		include "${bn_dir_default}/mail_form.$ext";
	} else {
		include "templates/default/agora/mail_form.$ext";
	}
	endForm();
	
	display_footer ($header_footer);
?>