<?php

/*
 *	W-AGORA 4.1
 *	-----------
 *	$Id: mail_users.php,v 1.18 2004/01/14 21:13:45 mdruilhe Exp $
 *	Usage:		Send email to users
 *	Authors:	Rich Sezov <rich@lightspring.com>
 *				Marc Druilhe <mdruilhe@w-agora.net>
 *
 */

	require ("init_admin.inc");

# Load site administration configuration
# --------------------------------------
	require ("$site_cfg_file");
	if (empty($bn_msgs) ) {
		include ("$bn_dir_default/site_msgs.$ext");
	} else {
		include "$bn_dir/$bn_msgs";
	}

	require ("$inc_dir/mail.$ext");

# Include mail template
# ---------------------
	if (empty($bn_mail_template) ) {
		include ("$bn_dir_default/mail_template.$ext");
	} else {
		include "$bn_dir/$bn_mail_template";
	}

# Displays Header
# ---------------
	if ( empty($bn)) {
		display_header (LABEL_SEND_SITE_EMAIL . " $site");
	} else {
		display_header (LABEL_SEND_FORUM_EMAIL . " $forum_name");
	}

# Grab the "active" users out of the database
# -------------------------------------------
	$numusers=0;

	if (empty($bn)) {
		$users = $db->getUsers($site, '', 'user,moder', '', '', 'userid');
	} else {
		$users = $db->getUsers($site, $bn, 'user,moder', '', "UF.state='1'", 'userid');
	}

	$userlist = array();
	if (is_array($users) ) {
		reset($users);
		while (list($userid,$user) = each ($users) ) {
			if ($user['mailok']=='Y') {
				$useraddress = $user['useraddress'];
				$userlist[$userid] = $useraddress;
			}
		}
	}

	if (count($userlist) < 1) {
		msgWarning (LABEL_NO_ACTIVE_USERS);
		exit;
	}


# send Message if FORM has been filled
# ------------------------------------
	if (isset($sendmail) ) {
		$html = "<P>";

		$numusers=0;

		if (!empty($sendtoall)  ) {

			// send to ALL users
			reset($users);
			while (list($userid,$user) = each ($users) ) {
				$username = $user['username'];
				$useraddress = $user['useraddress'];
				$mailok = $user['mailok'];
				if ($mailok == "Y") {
					$numusers++;
					$recipients[] = $useraddress;
					$html .= '&nbsp;&nbsp;' . sprintf(LABEL_USER_MAILED, $username, $useraddress);
				} else {
					$html .= '&nbsp;&nbsp;' . sprintf(LABEL_USER_NOT_MAILED, $username, $useraddress);
				}
			}
		} elseif (is_array($form_users)) {
		    
			// send to selected users
			reset($form_users);
			while (list(,$userid) = each ($form_users) ) {
				$username = $users[$userid]['username'];
				$useraddress = $users[$userid]['useraddress'];
				$mailok = $users[$userid]['mailok'];
				if ($mailok == "Y") {
					$numusers++;
					$recipients[] = $useraddress;
					$html .= '&nbsp;&nbsp;' . sprintf(LABEL_USER_MAILED, $username, $useraddress);
				} else {
					$html .= '&nbsp;&nbsp;' . sprintf(LABEL_USER_NOT_MAILED, $username, $useraddress);
				}
			}
		}

		$html .= "";

		if (is_array($recipients) ) {
			$html .=  '<br><br>&nbsp;&nbsp;' . sprintf(LABEL_MAIL_USERS, $numusers) . '<br>';
			mail_users ($recipients, $msgsubject, $msgbody, $mail_from, $reply_to);
		}
		print $html . '<br>';
	}


# Displays FORM
# -------------
	$mail_from = (isset($mail_from)) ? $mail_from : "$bn_mail_from";
	$reply_to = (isset($reply_to)) ? $reply_to : "$bn_reply_to";
	$msgsubject = (isset($msgsubject)) ? $msgsubject : "";
	$msgbody = (isset($msgbody)) ? $msgbody : "";


	table_header (LABEL_MAIL_FILL_FORM);
	beginForm();

?>
<table width="95%" border=0>
<tr>
  <td width=100 class=label><?echo COLUMN_TO ?></td>
  <td>
<?php
	listBox('form_users', $userlist, '', 1);
	echo '<br>'.checkBox('sendtoall', 1, $sendtoall, LABEL_SEND_TO_ALL);
?>
  </td>
</tr>

<tr>
  <td width=100 class=label><?echo COLUMN_FROM ?></td>
  <td><input type="text" name="mail_from" size=60 value="<?echo $mail_from?>" maxlength=100></td>
</tr>
<tr>
  <td width=100 class=label><?echo COLUMN_REPLY_TO ?></td>
  <td><input type="text" name="reply_to" size=60 value="<?echo $reply_to?>" maxlength=100></td>
</tr>
<tr>
  <td width=100 class=label><?echo COLUMN_SUBJECT ?></td>
  <td><input type="text" name="msgsubject" size=60 value="<?echo $msgsubject?>" maxlength=255></td>
</tr>
<tr>
  <td width=100 valign="top" class=label><?echo COLUMN_MESSAGE ?></td>
  <td><textarea name="msgbody" rows=10 cols=60 wrap=virtual><?echo $msgbody?></textarea></td>
</tr>
<tr><td align=center colspan=2>
 <hr noshade width="90%">
 <input type=submit name="sendmail" value="<?echo LABEL_SEND_MAIL ?>">
 <input type="reset">
</td></tr>
</table>
<?PHP 
	endForm();
	table_footer();
?>
</BODY>
</HTML>
