<?

/*
 *	W-AGORA 4.2
 *	-----------
 *	$Id: subscribe_thread.php,v 1.19 2005/03/11 11:35:08 mdruilhe Exp $
 *	Usage:		subscribe a user to a thread (allowing him to receive emails)
 *	Authors:	Laurent Aufrere <laurent.aufrere@free.fr>
 *				Marc Druilhe <mdruilhe@w-agora.com>
 *
 */

# User must have read access in order to subscribe to the mailing list
# --------------------------------------------------------------------
	$bn_action_mode="R";
	$bn_action="subscribe_thread";
	$popup=1;				// Can open in a separated window
	require ("init.inc");

# A forum must be selected in order to subscribe
# ---------------------------------------------
	if (empty($bn)) {
		die (ERROR_NO_FORUM_SPECIFIED);
	}

	settype($thread, "integer");
	if (empty($thread)) {
		die (ERROR_SPECIFY_KEY);
	}

# Check if the user is authenticated in this site otherwise redirect him to the login form
#----------------------------------------------------------------------------------------
	if (($forum["type"] != "pub") && !$is_authenticated) {
		$redirect = urlencode("$WA_SELF?thread=$thread");
		header ("Location: login.$ext?site=$site&bn=$bn&popup=$popup&thread=$thread&redirect=$redirect");
		exit;
	}

# Set useraddress if user is authenticated
# ----------------------------------------
	if ($is_authenticated) {
		$userid = $auth->userid;
		$useraddress = $auth->user["useraddress"];
	}

# Execute before_access program
# -----------------------------
	if (!empty($before_access)) include $before_access;

	display_header (TITLE_SUBSCRIBE_THREAD, $header_footer);

# If Subscription form have been submitted
# ----------------------------------------
	if (isset($go)) {
		$go=0;
		if (($forum["type"] == "pub") && !$is_authenticated) {
			# Check that the user email address is valid if set
			# --------------------------------------------------
			$useraddress=ereg_replace (" ", "", $useraddress);
			if (empty($useraddress) || !validate_email ($useraddress, MAIL_CHECK_DNS)) {
				msgForm (ERROR_INVALID_EMAIL, "$WA_SELF", "back", "", "list");
				display_footer ($header_footer);
				exit;
			}
		}

		if ($subscribe == 1) {
			$db->subscribeUser ($site, $bn_db, $useraddress, $thread);
			msgForm (MSG_CONFIRM_SUB_THREAD, "view.$ext?bn=$bn&key=$thread", "close");
		} else {
			$db->unSubscribeUser ($site, $bn_db, $useraddress, $thread);
			msgForm (MSG_CONFIRM_UNSUB_THREAD, "view.$ext?bn=$bn&key=$thread", "close");
		}
		display_footer ($header_footer);
		exit;

	} // End $go

# Check if the user has already subscribed to this thread
# ------------------------------------------------------
	if ($is_authenticated) {
		$subscribed = $db->checkSubscribedUser ($site, $bn_db, $useraddress, $thread);
	} else {
		$subscribed=FALSE;
	}

	$current = ($subscribed == TRUE) ? "1" : "0";

	$form_title = TITLE_SUBSCRIBE_THREAD;
	$subscribe_query = $form_title;	// backward compatibility
	$subscribe_radio = getRadioButton ("subscribe", "1", $current, LABEL_YES );
	$unsubscribe_radio = getRadioButton ("subscribe", "0", $current, LABEL_NO );
	$submit_button = getSubmitButton ('submit', BUTTON_SUBSCRIBE);
	$label_useraddress = LABEL_ENTER_EMAIL;
	$input_useraddress = ($is_authenticated) ? "$useraddress" : "<INPUT NAME=\"useraddress\" VALUE=\"$useraddress\" size=40>";

	beginForm();
	hiddenField("go", "go");
	hiddenField("thread",$thread);

	if (!empty($bn_subscribe_form) && file_exists("${bn_dir}/${bn_subscribe_form}") ) {
		include "${bn_dir}/${bn_subscribe_form}";
	} elseif ( file_exists("${bn_dir_default}/subscribe_form.$ext") ) {
		include "${bn_dir_default}/subscribe_form.$ext";
	} else {
		include "${tmpl_dir}/default/agora/subscribe_form.$ext";
	}
	endForm();
	display_footer ($header_footer);
?>
