<?php

/* 
 *	W-AGORA 4.0
 *	-----------
 *	$Id: upgrade_403.php,v 1.11 2004/10/05 17:09:35 mdruilhe Exp $
 *	Usage:		Upgrade all installation from 4.0.2 to 4.0.3
 *	Author:		Marc Druilhe <mdruilhe@w-agora.com>
 */

# Define globals
# --------------

	$agora_dir = "..";


function updateSite ($site) {
	global $db;

	$db->Halt_On_Error = "no";

	// Update SITE table
	echo ("<li> <I>altering table</I> <B>${site}</B>");
	$db->query ("ALTER TABLE $site ADD att_count INT NOT NULL DEFAULT 0");
	$db->query ("ALTER TABLE $site ADD att_size  INT NOT NULL DEFAULT 0");


	// Update USERS table
	echo ("<li> <I>altering table</I> <B>${site}_users</B>");
	$db->query ("alter table ${site}_users add totalposts int NOT NULL DEFAULT 0");
	$db->query ("alter table ${site}_users add lastpost int NOT NULL DEFAULT 0");
	$db->query ("alter table ${site}_users add lastforumpost varchar(64) NOT NULL DEFAULT ''");
	$db->query ("alter table ${site}_users add signature varchar(255) NOT NULL DEFAULT ''");
	$db->query ("alter table ${site}_users add picture varchar(255) NOT NULL DEFAULT ''");
	$db->query ("alter table ${site}_users add icq varchar(32) NOT NULL DEFAULT ''");
	$db->query ("alter table ${site}_users add aim varchar(32) NOT NULL DEFAULT ''");
	$db->query ("alter table ${site}_users add msn varchar(32) NOT NULL DEFAULT ''");
	$db->query ("alter table ${site}_users add yahoo varchar(32) NOT NULL DEFAULT ''");

	// Update UserThread (mail subscriptions) table
	echo ("<li> <I>altering table</I> <B>${site}_userthread</B>");
	$db->query ("alter table ${site}_userthread change bn_name bn_name varchar(64) NOT NULL DEFAULT ''");

	$db->Halt_On_Error = "halt";
}

function updateUserForumStats($site, $forum) {
	global $db;

	$db->Halt_On_Error = "report";
	$result =  $db->query ("SELECT userid, max(unixdate) AS lastpost, count(unixdate) AS totalposts FROM $forum GROUP BY userid");
	if (!$result) {
		return FALSE;
	}

	while ($db->next_record() ) {
		$users[] = $db->Record;
	}

	if (!is_array($users) ) {
		return;
	}

	reset ($users);
	while (list(,$user) =  each ($users) ) {
		$userid = $user["userid"];
		$lastpost = $user["lastpost"];
		$totalposts = $user["totalposts"];

		$result =  $db->query ("SELECT userid FROM ${site}_userforum WHERE userid='$userid' AND bn_name='$forum'");
		if ($db->next_record() ) {
			$query = "UPDATE ${site}_userforum SET totalpost=$totalposts, lastpost=$lastpost WHERE userid='$userid' AND bn_name='$forum'";
		} else {
			$query = "INSERT INTO ${site}_userforum (bn_name, userid, totalpost, lastpost, state) VALUES('$forum', '$userid', '$totalposts', '$lastpost', '1')";
		}
		$result = $db->query ($query);
	}

}

function updateSiteStats($site) {
	global $db;

	$db->Halt_On_Error = "report";
	$result =  $db->query ("SELECT userid, MAX(lastpost) AS lastpost, SUM(totalpost) AS totalposts FROM ${site}_userforum GROUP BY userid");
	if (!$result) {
		return FALSE;
	}

	$i=0;
	while ($db->next_record() ) {
		$users[$i++] = $db->Record;
	}

	if (!is_array($users) ) {
		return;
	}

	reset ($users);
	while (list($i,$user) =  each ($users) ) {
		$users[$i]["lastforumpost"] = "";
		$userid = $user["userid"];
		$lastpost = $user["lastpost"];
		if ($lastpost > 0) {
			$result =  $db->query ("SELECT bn_name FROM ${site}_userforum WHERE userid='$userid' AND lastpost='$lastpost'");
			if ($db->next_record() ) {
				$users[$i]["lastforumpost"] = $db->f("bn_name");
			}
		}
	}

	reset ($users);
	while (list(,$user) =  each ($users) ) {
		$userid = $user["userid"];
		$lastpost = $user["lastpost"];
		$totalposts = $user["totalposts"];
		$lastforumpost = $user["lastforumpost"];
		$result = $db->query ("UPDATE ${site}_users SET totalposts=$totalposts, lastpost=$lastpost, lastforumpost='$lastforumpost' WHERE userid='$userid'");
	}
}

function updateMsgFile ($msgfile) {

	global $bn_dir, $new_msg;

	include "$msgfile";
	reset ($new_msg);

	print "<li> <I>updating messages in </I> <B>$msgfile</B> ";
	$touch = FALSE;

	while (list ($i, $m) = each($new_msg) ) {
		if (!isset($msg[$i]) ) {
			$touch = TRUE;
			$msg[$i] = $new_msg[$i];
			echo " <B>$i</B> ";
		}
	}

	if ($touch) {
		print "<li> <I>writing file </I> <B>$msgfile</B>";
		$f = new Config;
		$ret = $f->open("$msgfile");
		if (!$ret) {
			return FALSE;
		}
		reset ($msg);
		while (list ($i, $m) = each($msg) ) {
			$f->writeString ("msg[$i]", $msg[$i]);
		}
		$f->close ();
	}
}

	chdir ("$agora_dir");

	if (empty($site)) {
		$site= 'agora';
	}

	include ("init_admin.inc");

# Load default messages
# ---------------------
	include "$tmpl_dir/default/agora/msgs.$ext";
	$new_msg = $msg;
	unset ($msg);

?>

<html>
<head>
<style type="text/css">
<!--
 body { font-size: 9pt  font-family: Helvetica, Arial, Geneva; }
-->
</style>
</head>
<body>
<H3>Upgrading w-agora from version 4.0.2 to 4.0.3</H3>

<?

# If site specified then upgrade it
# ---------------------------------
	if ($site != 'agora')  {
		@set_time_limit(30);
		print "<ul>";
		print "<li><I>Upgrading site:</I> <B>$site</B><br> ";
		require "tools/upgrade_site_403.$ext";
		print "</ul>";
		exit;
	}

# ... else (no site specified => upgrade all sites)
# -------------------------------------------------

# Initial setup
# -------------
	include "$cfg_dir/site_agora.$ext";

# Open database
# -------------
	include "$inc_dir/$bn_access.$ext";
	$db_class = "${bn_access}_access";
	$db = new $db_class;
	$ret = $db->openDB($dbhost, $dbport, $dbuser, $dbpassword, $dbname, $site);

	print "<ul>";
	print "<li><I>Upgrading agora main configuration and database:</I> <br> ";

	print "<ul>";

# Update site config. files
# -------------------------
	// update messages
	echo "<li> copy $tmpl_dir/admin/site_msgs.$ext $bn_dir_forums/$site/msgs.$ext ";
	copy ("$tmpl_dir/admin/site_msgs.$ext", "$bn_dir_forums/$site/msgs.$ext");


# Update site tables
# ------------------
	updateSite("agora");

	print "</ul>";

# Update all sites
# ----------------

	// gets all configured sites
	$db->query ("select bn_name AS site from agora");
	while ($db->next_record() ) {
		$sites[] = $db->f("site");
	}

	$db->closeDB();
	unset ($db);

	reset ($sites);
	while (list (, $site) = each($sites) ) {
		@set_time_limit(30);
		print "<hr>";
		print "<li><I>Upgrading site:</I> <B>$site</B><br> ";
		require "tools/upgrade_site_403.$ext";
	}

	print "</ul>";

?>