<?php

/* 
 *	W-AGORA 4.0
 *	-----------
 *	$Id: upgrade_413.php,v 1.5 2002/12/09 16:40:37 mdruilhe Exp $
 *	Usage:		Upgrade all installations from 4.1.x to 4.1.2
 *	Author:		Marc Druilhe <mdruilhe@w-agora.net>
 */

# Define globals
# --------------

	$agora_dir = "..";

	function updateSite ($site) {
		global $db, $tmpl_dir, $ext;

		$hoe = $db->setHaltOnError('report');

		// Update attachments inline flag
		// ------------------------------
		$db->query ("UPDATE ${site}_attachments SET inline='1' WHERE inline=''");

		// Create LOG table (history + statistics)
		// ---------------------------------------
		include "$tmpl_dir/admin/log_fields.$ext";
		reset ($bn_var);
		unset ($field_descr);
		while (list(, $var) = each($bn_var)) {
			$field_descr[$var] = $bn_var_size[$var];
		}
		$ret = $db->createTable ("${site}_log", $field_descr);


		// set forum owner field in site table (should not be null nor blank
		// -----------------------------------------------------------------
		$db->query ("UPDATE $site SET owner='admin' WHERE owner=''");
		$db->query ("UPDATE $site SET owner='admin' WHERE owner IS NULL");

		$db->setHaltOnError($hoe);
	}


	chdir ("$agora_dir");

	$site = empty($site) ? 'agora' : $site;
	include ("init_admin.inc");

?>
<html>
<head>
<style type="text/css">
<!-- 
body { font-size: 9pt  font-family: Helvetica, Arial, Geneva; }
-->
</style>
</head><body><H3>Upgrading w-agora from version 4.1.2 to 4.1.3</H3>
<?

# If site is defined => upgrade only this site and exit
# -----------------------------------------------------
	if ($site!='agora') {
			@set_time_limit(30);
			print "<hr><h2>Upgrading site: <B>$site</B></h2> ";
			// update site
			updateSite($site);
			// close DB connection
			$db->closeDB();
			print "</ul>";
			exit;
	}

# gets all configured sites
# -------------------------
	$db->query ("select bn_name, bn_title from agora");
	while ($db->next_record() ) {
		$sitename = $db->f("bn_name");
		$sites[$sitename] = $db->f("bn_title");
	}

	$db->closeDB();
	unset ($db);

# loop over all sites
# -------------------
	reset ($sites);
	while (list ($site, $site_title) = each($sites) ) {
		@set_time_limit(30);
		print "<hr><h2>Upgrading site: <B>$site</B> ($site_title)</h2> ";

		// include Site configuration
		if (!is_file ("$cfg_dir/site_${site}.$ext") ) {
			die ("Cannot open file: $cfg_dir/site_${site}.$ext, make sure that site $site really exists");
		}
		include "$cfg_dir/site_${site}.$ext";

		// open new DB connection for this site
		include_once ("$inc_dir/$bn_access.$ext");
		$db_class = "${bn_access}_access";
		$db = new $db_class;
		$db->openDB($dbhost, $dbport, $dbuser, $dbpassword, $dbname, $site);

		// update site
		updateSite($site);

		// close DB connection
		$db->closeDB();
		unset ($db);
		print "</ul>";
	}

	print "<H3>Done!</H3>";

?>
