<?php

/* 
 *	W-AGORA 4.0
 *	-----------
 *	$Id: upgrade_42.php,v 1.5 2005/03/11 10:24:05 mdruilhe Exp $
 *	Usage:		Upgrade all installations from 4.1.4+ to 4.2
 *	Author:		Marc Druilhe <mdruilhe@w-agora.net>
 */

# Define globals
# --------------

	$agora_dir = "..";
	$base_url = "..";

	function updateSite ($site) {
		global $db, $tmpl_dir, $ext;

		$hoe = $db->setHaltOnError('report');
	
		// set forum owner field in site table (should not be null nor blank
		// -----------------------------------------------------------------
		print "<div align=\"left\">";
		print "<ul>";
		print "<li>Adding field 'state' in users table</li>";
		$db->query ("ALTER TABLE ${site}_users ADD state VARCHAR(1) NOT NULL DEFAULT '1'");
		$db->query ("UPDATE ${site}_users SET state='1'");

		print "<li>Adding field 'totalread' in userforum table</li>";
		$db->query ("ALTER TABLE ${site}_userforum ADD totalread INT NOT NULL DEFAULT 0");

		print "<li>Creating Custom menus table</li>";
		$menus_descr["menu_name"] = "32";
		$menus_descr["menu_key"] = "32";
		$menus_descr["menu_value"] = "255";
		$db->createTable ("${site}_menus", $menus_descr, 'menu_name,menu_key');

		if ($site == "agora") {
			print "</ul>";
			print "</div>";
			$db->setHaltOnError($hoe);
			return;
		}
			
		print "<li>Creating LOG rotation and statistics tables</li>";

		$log_descr = array(
			'datestamp' => 'TIMESTAMP',
			'forum' => '64',
			'action' => '64',
			'userid' => '32',
			'thread' => 'INT',
			'note_id' => 'INT',
			'ip' => '32'
		);

		$db->createTable ("${site}_log_t1", $log_descr);
		$db->createTable ("${site}_log_t2", $log_descr);
		$db->createTable ("${site}_log_t3", $log_descr);
		$db->createTable ("${site}_log_t4", $log_descr);

		$db->createIndex ("${site}_log_t1", 'datestamp');
		$db->createIndex ("${site}_log_t2", 'datestamp');
		$db->createIndex ("${site}_log_t3", 'datestamp');
		$db->createIndex ("${site}_log_t4", 'datestamp');

		$forumstat_descr = array(
			'year_stat' => 'INT',
			'month_stat' => 'INT',
			'day_stat' => 'DATETIME NOT NULL',
			'forum' => '64',
			'total_insert' => 'INT',
			'total_login' => 'INT',
			'total_view' => 'INT',
			'total_subscribe' => 'INT',
			'total_register' => 'INT'
		);

		$db->createTable ("${site}_dailyforumstats", $forumstat_descr);
		$db->createIndex ("${site}_dailyforumstats", 'year_stat,month_stat,day_stat,forum', true, "${site}_dailyforumstats_uk");
		$db->createIndex ("${site}_dailyforumstats", 'day_stat,forum', true, "${site}_dailyforumstats_day");

		$userstat_descr = array(
			'year_stat' => 'INT',
			'month_stat' => 'INT NULL',
			'week_stat' => 'INT NULL',
			'day_stat' => 'DATETIME NULL',
			'total_users' => 'INT'
		);

		$db->createTable ("${site}_dailyuserstats", $userstat_descr);
		$db->createIndex ("${site}_dailyuserstats", 'year_stat,month_stat,week_stat,day_stat', true, "${site}_dailyuserstats_uk");
		$db->createIndex ("${site}_dailyuserstats", 'day_stat');


		$db->setHaltOnError('no');
		print "<li>Removing unused indexes on tables</li>";

		$db->dropIndex ($site, "thread");
		$db->dropIndex ($site, "newest");
		$db->dropIndex ("${site}_log", "thread");

		print "<li>Setting indexes and primary key on tables</li>";
		$db->createIndex ($site, 'bn_name');
		$db->addPrimaryKey ("${site}_attachments", 'att_id');
		$db->createIndex ("${site}_attachments", 'note_id');
		$db->createIndex ("${site}_attachments", 'bn_name');
		$db->addPrimaryKey ("${site}_users", 'userid');
		$db->addPrimaryKey ("${site}_userforum", 'userid,bn_name');
		$db->createIndex ("${site}_userthread", 'thread');
		$db->createIndex ("${site}_userthread", 'bn_name');

		print "</ul>";
		print "</div>";
		$db->setHaltOnError($hoe);
	}


	chdir ("$agora_dir");
	@set_time_limit(0);

	$site = empty($site) ? 'agora' : $site;
	include ("init_admin.inc");

	display_header ("Upgrading w-agora from version 4.1.4+ to 4.2", "$base_url");

	if ($site!='agora') {
		// If site is defined => upgrade only this site and exit
		$db->query ("select bn_title from agora where bn_name='$site'");
		if ($db->next_record() ) {
			$sites[$site] = $db->f("bn_title");
		} else {
			die("invalid site: $site");
	}

		$db->closeDB();
		unset ($db);
	} else {
		// gets all configured sites
	$db->query ("select bn_name, bn_title from agora");
	while ($db->next_record() ) {
		$sitename = $db->f("bn_name");
		$sites[$sitename] = $db->f("bn_title");
	}

	$db->closeDB();
	unset ($db);
	$sites["agora"]="agora";
	}

# loop over all sites
# -------------------
	reset ($sites);
	while (list ($site, $site_title) = each($sites) ) {
		print "<p>Upgrading site: <strong>$site</strong> ($site_title)";

		// include Site configuration
		if (!is_file ("$cfg_dir/site_${site}.$ext") ) {
			die ("Cannot open file: $cfg_dir/site_${site}.$ext, make sure that site $site really exists");
		}
		include "$cfg_dir/site_${site}.$ext";

		// open new DB connection for this site
		include_once ("$inc_dir/$bn_access.$ext");
		$db_class = "${bn_access}_access";
		$db = new $db_class;
		$hoe = $db->setHaltOnError('report');
		$ret = $db->openDB($dbhost, $dbport, $dbuser, $dbpassword, $dbname, $site);
		if($ret <0) {
			msgWarning ("Site $site could not be upgraded, please try later!");
			print "</p><hr noshade=\"noshade\">";
			continue;
		}
		$db->setHaltOnError($hoe);

		updateSite($site);
		$db->closeDB();
		unset ($db);
		print "</p><hr noshade=\"noshade\">";
	}

	print "<p>Done!</p>";

	display_footer();

?>
