<?php require("./config.inc.php");

/*

YapBB, a fully functional bulletin board system
Copyright (C) 2000/01  Arno van der Kolk
http://yapbb.sourceforge.net/

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

//=====================================================================================================================
// Description: this is the YapBB control panel
//=====================================================================================================================

require($cfgIncludeDirectory . "class_Snoopy.php");

//boolean
function is_update_available($local, $remote)
{
	$local = explode("-", $local);
	$remote = explode("-", $remote);

	$vRemote = (float)$remote[0];	// new version
	$vLocal = (float)$local[0];		// old version
	$bRemote = (int)$remote[1];		// new patch (build/patch)
	$bLocal = (int)$local[1];		// old patch (build/patch)
	unset($local);
	unset($remote);

	if ($vRemote > $vLocal)
		return true;
	else if ($vRemote == $vLocal)
		if ($bRemote > $bLocal)
			return true;
		else
			return false;
	else
		return false;
}


//boolean
function isDBinstalled()
{
	global $cfgDatabase;
	$result = mysql_list_tables($cfgDatabase['database']);
	$ok2 = TRUE;
	for ($i = 0; $ok2 && $i < mysql_num_rows($result); $i++)
	{
		$ok = FALSE;
		$tb_names[$i] = mysql_tablename ($result, $i);
		for ($j = 0; $j < sizeof($cfgDatabase); $j++)
			$ok = ok || $cfgDatabase[$j] == $tb_names[$i];
		$ok2 = $ok2 && $ok;
	}
	return $ok2;
}

function updateConfig($var)
{
	$configFile = "config.inc.php";
	$var = "cfg" . strtoupper(substr($var, 0, 1)) . substr($var, 1);
	$fh = @fopen($configFile,"r+");
	if (is_bool($fh) || $fh == FALSE)
	{
		sendError("Update failed!!");
	}
	$file = fread($fh, filesize($configFile));
	fseek($fh, 0);
	$arr = explode("\n", $file);
	$s = sizeof($arr);
	$file = "";
	for ($i = 0; $i < $s; $i++)
	{
		$line = $arr[$i];
		if (substr(trim($line), 0, 1 + strlen($var)) == "\$$var")
		{
			if (is_long($pos = strpos($line, "=")))
			{
				global $$var;
				$line = substr($line, 0, $pos + 1) . ' "' . addslashes($$var) . '";';
			}
			else
			{
				//parse error
			}
		}
		//echo $line . "<br>";//\n";
		$file .= "$line\n";
	}
	//fwrite($fh, $file);
	fclose($fh);

	unset($i);
	unset($fh);
	unset($file);
	unset($arr);
	unset($s);
	unset($line);
}

/*$postVars = array("verify", "categoryDescription", "categoryPosition", "forumPosition", "forumDescription", "forumName",
				"forumUseHTML", "forumUseYBB", "forumPassword", "topicDescription", "topicPostID", "topicViews",
				"topicActive", "topicForumID", "topicLastPostID", "siteTitle", "siteHomeURL");
$getVars = array("order", "action", "onlyModerators", "begin", "userid", "categoryid", "forumid", "topicid");

for ($i = 0; $i < sizeof($postVars); $i++)
	if (isset($HTTP_POST_VARS[$postVars[$i]])) ${$postVars[$i]} = $HTTP_POST_VARS[$postVars[$i]]; else unset(${$postVars[$i]});

for ($i = 0; $i < sizeof($getVars); $i++)
	if (isset($HTTP_GET_VARS[$getVars[$i]]))
		${$getVars[$i]} = $HTTP_GET_VARS[$getVars[$i]];
	else if (!isset($HTTP_POST_VARS[$getVars[$i]]))
		unset(${$getVars[$i]});
*/

if ($categoryid == "" || $categoryid <= 0) unset($categoryid);
if ($forumid == "" || $forumid <= 0) unset($forumid);
if ($topicid == "" || $topicid <= 0) unset($topicid);
if ($userid == "" || $userid <= 0) unset($userid);

if (!($DBinstalled = isDBinstalled())) $action = "get_config_mysql";

$forumResultRow = array();
$forumResultRow['password'] = 4;			//2 = moderator, 3 = admin, 4 = sys op
require($cfgIncludeDirectory . "forumpassword.php");
unset($forumResultRow);

if ($action == "get_categories")
{
	$loop = "categories";
	$categoryQuery = new MySQL;
	$catRes = $categoryQuery->select("SELECT * FROM " . $cfgDatabase['category'] . ((isset($order) && !empty($order))?" ORDER BY $order":" ORDER BY position"));
	for ($i = 0; $i < $categoryQuery->rows; $i++)
	{
		${$loop}[$i]['id'] = $catRes[$i]['id'];
		${$loop}[$i]['position'] = $catRes[$i]['position'];
		${$loop}[$i]['description'] = htmlspecialchars(stripslashes($catRes[$i]['description']));
	}
	$actionGetCategories = TRUE;
}
else if ($action == "get_category_properties")
{
	$PAGE_BACK = "$PHP_SELF?action=get_categories";
	if ($categoryid > 0)
	{
		$categoryQuery = new MySQL;
		$catRes = $categoryQuery->select("SELECT position, description FROM " . $cfgDatabase['category'] . " WHERE id = $categoryid");
		if ($categoryQuery->rows != 1)
			sendError("pe: More than one category with the same ID!");
		$categoryDescription = htmlspecialchars(stripslashes($catRes[0]['description']));
		$categoryPosition = (int)$catRes[0]['position'];
		$template->register($templateHandler, "categoryid, categoryDescription");
		$loop = "position";
		$res = $categoryQuery->select("SELECT COUNT(id) AS count FROM " . $cfgDatabase['category']);
		if ($categoryQuery->rows != 1)
			sendError("pe: ergens blaat");
		for ($i = 0; $i < $res[0]['count']; $i++)
		{
			${$loop}[$i]['id'] = $i;
			${$loop}[$i]['value'] = $i;
			if ($i == 0)
				${$loop}[$i]['value'] .= " (" . $lang['default'] . ")";
			${$loop}[$i]['selected'] = (($i == $categoryPosition)?" selected ":"");
		}
		$actionGetCategoryProperties = TRUE;
	}
	else
	{
		header("Location: $PAGE_BACK");
		exit;
	}
}
else if ($action == "set_category_properties")
{
	if ($categoryid > 0)
	{
		if (isset($categoryDescription) && !empty($categoryDescription) && $categoryPosition >= 0)
		{
			$categoryQuery = new MySQL;
			$categoryQuery->query("UPDATE " . $cfgDatabase['category'] . " SET position = $categoryPosition, description = '" . addslashes($categoryDescription) . "' WHERE id = $categoryid");
			$PREV_MSG = "Update succeeded";	//mod:bugje
		}
		else
		{
			header("Location: $PHP_SELF?action=get_category_properties&categoryid=$categoryid");
			exit;
		}
	}
	header("Location: $PHP_SELF?action=get_categories");
	exit;
}
else if ($action == "add_category")
{
	$categoryQuery = new MySQL;
	if (isset($categoryDescription) && !empty($categoryDescription) && $categoryPosition >= 0)
	{
		$categoryPosition = 0 + $categoryPosition;
		$categoryQuery->query("INSERT INTO " . $cfgDatabase['category'] . " (position, description) VALUES ($categoryPosition, '" . addslashes($categoryDescription) . "')");
		header("Location: $PHP_SELF?action=get_categories");
		$PREV_MSG = "New category inserted";
		exit;
	}
	else
	{
		$catRes = $categoryQuery->select("SELECT COUNT(id) AS count FROM " . $cfgDatabase['category']);
		if ($categoryQuery->rows != 1)
			sendError("pe: ergens blaat");
		$loop = "position2";
		for ($i = 0; $i <= $catRes[0]['count']; $i++)
		{
			${$loop}[$i]['id'] = $i;
			${$loop}[$i]['value'] = $i;
			if ($i == 0)
				${$loop}[$i]['value'] .= " (" . $lang['default'] . ")";
			${$loop}[$i]['selected'] = "";
		}
		$actionAddCategory = TRUE;
		$PAGE_BACK = "$PHP_SELF?action=get_categories";
	}
}
else if ($action == "delete_category")
{
	$PAGE_BACK = "$PHP_SELF?action=get_categories";
	$actionDeleteCategory = TRUE;
	if ($categoryid > 0)
	{
		if ($verify == 1)
		{
			$query = new MySQL;
			$forumQuery = new MySQL;
			$forRes = $forumQuery->select("SELECT id FROM " . $cfgDatabase['forum'] . " WHERE category = $categoryid");
//			echo "Locking all applicable topics<br>\n";
//			flush();
			$forumIDs = "";
			for ($i = 0; $i < $forumQuery->rows; $i++)
				$forumIDs .= $forRes[$i]['id'] . ", ";
			$forumIDs = substr($forumIDs, 0, -2);
			if ($forumIDs != "") $query->query("UPDATE " . $cfgDatabase['topic'] . " SET active = 0 WHERE forumid IN ($forumIDs)");
//			echo "Waiting 10 seconds for connections to close...<p>\n";
//			flush();
			sleep(10);

			$res = $query->select("SELECT p.id FROM " . $cfgDatabase['post'] . " AS p, " . $cfgDatabase['forum'] . " AS f, " . $cfgDatabase['topic'] . " AS t WHERE p.topicid = t.id AND t.forumid = f.id AND f.category = $categoryid");
			$sql = "";
			for ($i = 0; $i < $query->rows; $i++)
				$sql .= $res[$i]['id'] . ", ";
			$sql = substr($sql, 0, -2);
			if ($sql != "") $query->query("DELETE FROM " . $cfgDatabase['post'] . " WHERE id IN ($sql)");

			if ($forumIDs != "") $query->query("DELETE FROM " . $cfgDatabase['topic'] . " WHERE forumid IN ($forumIDs)");
			$query->query("DELETE FROM " . $cfgDatabase['forum'] . " WHERE category = $categoryid");
			$query->query("DELETE FROM " . $cfgDatabase['category'] . " WHERE id = $categoryid");

			header("Location: $PAGE_BACK");
			exit;
		}
		else
		{
			//show 'delete_category'-form
			$template->register($templateHandler, "categoryid");
		}
	}
	else
	{
		header("Location: $PAGE_BACK");
		exit;
	}
}
else if ($action == "get_forums")
{
	$loop = "forums";
	$forumQuery = new MySQL;
	$forRes = $forumQuery->select("SELECT * FROM " . $cfgDatabase['forum'] . ((isset($categoryid))?" WHERE category = $categoryid":"") . ((isset($order) && !empty($order))?" ORDER BY $order":" ORDER BY position"));
	for ($i = 0; $i < $forumQuery->rows; $i++)
	{
		${$loop}[$i]['id'] = $forRes[$i]['id'];
		${$loop}[$i]['position'] = $forRes[$i]['position'];
		${$loop}[$i]['name'] = htmlspecialchars(stripslashes($forRes[$i]['name']));
		${$loop}[$i]['category'] = $forRes[$i]['categoryid'];
	}
	$actionGetForums = TRUE;
	if ($categoryid > 0)
	{
		$template->register($templateHandler, "categoryid");
		$PAGE_BACK = "$PHP_SELF?action=get_categories";
	}
}
else if ($action == "get_forum_properties")
{
	$PAGE_BACK = "$PHP_SELF?action=get_forums&categoryid=$categoryid";
	if ($forumid > 0)
	{
		$forumQuery = new MySQL;
		$forRes = $forumQuery->select("SELECT * FROM " . $cfgDatabase['forum'] . " WHERE id = $forumid");
		if ($forumQuery->rows != 1)
			sendError("pe: More than one forum with the same ID!");
		$forumDescription = htmlspecialchars(stripslashes($forRes[0]['description']));
		$forumName = htmlspecialchars(stripslashes($forRes[0]['name']));
		$forumPosition = (int)$forRes[0]['position'];
		$forumPassword = $forRes[0]['password'];
		$forumUseHTML = $forRes[0]['usehtml'];
		$forumUseYBB = $forRes[0]['useybb'];
		$forumCategory = $forRes[0]['category'];
		$template->register($templateHandler, "forumCategory, forumid, forumDescription, forumName, forumPassword");
		$loop[0] = "stati";
		$loop[1] = "categories2";
		$loop[2] = "position3";
		for ($i = 0; $i < sizeof($cfgStrOperator); $i++)
		{
			${$loop[0]}[$i]['type'] = $i + 1;
			${$loop[0]}[$i]['description'] = $cfgStrOperator[$i] . (($i < sizeof($cfgStrOperator) - 1)?" and up":" only");
			${$loop[0]}[$i]['selected'] = (($forumPassword == $i + 1)?" selected ":"");
		}
		$categoryQuery = new MySQL;
		$catRes = $categoryQuery->select("SELECT * FROM " . $cfgDatabase['category']);
		for ($i = 0; $i < $categoryQuery->rows; $i++)
		{
			${$loop[1]}[$i]['id'] = $catRes[$i]['id'];
			${$loop[1]}[$i]['description'] = htmlspecialchars(stripslashes($catRes[$i]['description']));
			${$loop[1]}[$i]['selected'] = (($catRes[$i]['id'] == $forumCategory)?" selected ":"");
		}

		$forRes = $forumQuery->select("SELECT COUNT(id) AS count FROM " . $cfgDatabase['forum'] . " WHERE category = $forumCategory");
		if ($forumQuery->rows != 1)
			sendError("pe: Get forum count error");
		for ($i = 0; $i <= $forRes[0]['count']; $i++) //allow for a lower position
		{
			${$loop[2]}[$i]['id'] = $i;
			${$loop[2]}[$i]['value'] = $i;
			if ($i == 0)
				${$loop[2]}[$i]['value'] .= " (" . $lang['default'] . ")";
			${$loop[2]}[$i]['selected'] = (($i == $forumPosition)?" selected ":"");
		}

		$actionGetForumProperties = TRUE;
		if ($forumCategory > 0 && !($categoryid > 0))
			$PAGE_BACK = "$PHP_SELF?action=get_forums&categoryid=$forumCategory";
	}
	else
	{
		header("Location: $PAGE_BACK");
		exit;
	}
}
else if ($action == "set_forum_properties")
{
	$PAGE_BACK = "$PHP_SELF?action=get_forums&categoryid=$forumCategory";
	if ($forumid > 0)
	{
		if (isset($forumName) && !empty($forumName) && isset($forumDescription) && !empty($forumDescription) && $forumCategory > 0 && $forumPassword > 0 && isset($forumUseHTML) && isset($forumUseYBB) && ($forumUseHTML == 1 || $forumUseHTML == 0) && ($forumUseYBB == 1 || $forumUseYBB == 0) && $forumPosition >= 0)
		{
			$forumQuery = new MySQL;
			$forumQuery->query("UPDATE " . $cfgDatabase['forum'] . " SET description = '" . addslashes($forumDescription) . "', name = '" . addslashes($forumName) . "', useybb = $forumUseYBB, usehtml = $forumUseHTML, password = $forumPassword, category = $forumCategory, position = $forumPosition WHERE id = $forumid");
			$PREV_MSG = "Update succeeded";	//mod:bugje
		}
		else
		{
			$PAGE_BACK = "$PHP_SELF?action=get_forum_properties&categoryid=$forumCategory&forumid=$forumid";
		}
	}
	header("Location: $PAGE_BACK");
	exit;
}
else if ($action == "add_forum")
{
	$PAGE_BACK = "$PHP_SELF?action=get_forums&categoryid=";
	if (isset($categoryid)) $PAGE_BACK .= $categoryid;
	else if (isset($forumCategory)) $PAGE_BACK .= $forumCategory;
	else $PAGE_BACK = "";

	$categoryQuery = new MySQL;
	if (/*isset($forumid) && isset($forumName) &&*/ !empty($forumName) && isset($forumDescription) && isset($forumPassword) && !empty($forumPassword) && isset($forumUseHTML) && ($forumUseHTML == 0 || $forumUseHTML == 1) && isset($forumUseYBB) && ($forumUseYBB == 0 || $forumUseYBB == 1) && $forumCategory > 0 && $forumPosition >= 0)
	{
		$categoryQuery->query("INSERT INTO " . $cfgDatabase['forum'] . " (name, description, usehtml, useybb, password, category, position) VALUES ('" . addslashes($forumName) . "', '" . addslashes($forumDescription) . "', $forumUseHTML, $forumUseYBB, $forumPassword, $forumCategory, $forumPosition)");
		$PREV_MSG = "New forum inserted";
		header("Location: $PAGE_BACK");
		exit;
	}
	else
	{
		//default values:
		$forumPosition = 0;
		$forumPassword = 1;
		$forumUseHTML = FALSE;
		$forumUseYBB = TRUE;

		//$template->register($templateHandler, "forumCategory, forumid, forumDescription, forumName, forumPassword");
		$loop[0] = "stati4";
		$loop[1] = "categories4";
		$loop[2] = "position4";
		for ($i = 0; $i < sizeof($cfgStrOperator); $i++)
		{
			${$loop[0]}[$i]['type'] = $i + 1;
			${$loop[0]}[$i]['description'] = $cfgStrOperator[$i] . (($i < sizeof($cfgStrOperator) - 1)?" and up":" only");
			${$loop[0]}[$i]['selected'] = (($forumPassword == $i + 1)?" selected ":"");
		}
		$catRes = $categoryQuery->select("SELECT * FROM " . $cfgDatabase['category']);
		for ($i = 0; $i < $categoryQuery->rows; $i++)
		{
			${$loop[1]}[$i]['id'] = $catRes[$i]['id'];
			${$loop[1]}[$i]['description'] = htmlspecialchars(stripslashes($catRes[$i]['description']));
			${$loop[1]}[$i]['selected'] = (($catRes[$i]['id'] == $categoryid)?" selected ":"");
		}

		$tmp = 0;
		if ($categoryid > 0) $tmp = $categoryid;
		else if ($forumCategory > 0) $tmp = $forumCategory;
		if ($tmp > 0)
		{
			$forumQuery = new MySQL;
			$forRes = $forumQuery->select("SELECT COUNT(id) AS count FROM " . $cfgDatabase['forum'] . " WHERE category = $tmp");
			if ($forumQuery->rows != 1)
				sendError("pe: Get forum count error");
			for ($i = 0; $i <= $forRes[0]['count']; $i++) //allow for a lower position for the new forum
			{
				${$loop[2]}[$i]['id'] = $i;
				${$loop[2]}[$i]['value'] = $i;
				if ($i == 0)
					${$loop[2]}[$i]['value'] .= " (" . $lang['default'] . ")";
				${$loop[2]}[$i]['selected'] = (($i == $forumPosition)?" selected ":"");
			}
		}
		else
		{
			${$loop[2]}[0]['id'] = 0;
			${$loop[2]}[0]['value'] = "0  (" . $lang['default'] . ")";
			${$loop[2]}[0]['selected'] = " selected ";
		}

		$actionAddForum = TRUE;
	}
}
else if ($action == "delete_forum")
{
	$PAGE_BACK = "$PHP_SELF?action=get_forums&categoryid=$categoryid";
	$actionDeleteForum = TRUE;
	if (isset($forumid) && !empty($forumid))
	{
		if ($verify == 1)
		{
			$query = new MySQL;
//			echo "Locking all applicable topics<br>\n";
//			flush();
			$query->query("UPDATE " . $cfgDatabase['topic'] . " SET active = 0 WHERE forumid = $forumid");
//			echo "Waiting 10 seconds for connections to close...<p>\n";
//			flush();
			sleep(10);

			$res = $query->select("SELECT p.id FROM " . $cfgDatabase['post'] . " AS p, " . $cfgDatabase['forum'] . " AS f, " . $cfgDatabase['topic'] . " AS t WHERE p.topicid = t.id AND t.forumid = $forumid");
			$sql = "";
			for ($i = 0; $i < $query->rows; $i++)
				$sql .= $res[$i]['id'] . ", ";
			$sql = substr($sql, 0, -2);
			if ($sql != "") $query->query("DELETE FROM " . $cfgDatabase['post'] . " WHERE id IN ($sql)");

			$query->query("DELETE FROM " . $cfgDatabase['topic'] . " WHERE forumid = $forumid");
			$query->query("DELETE FROM " . $cfgDatabase['forum'] . " WHERE id = $forumid");

			header("Location: $PAGE_BACK");
			exit;
		}
		else
		{
			//show 'delete_category'-form
			$template->register($templateHandler, "forumid, categoryid");
		}
	}
	else
	{
		header("Location: $PAGE_BACK");
		exit;
	}
}
else if ($action == "get_topics")
{
	$PAGE_BACK = "$PHP_SELF?action=get_forums&categoryid=$categoryid";
	$actionGetTopics = TRUE;
	if ($forumid > 0)
	{
		$loop = "topics";
		$query = new MySQL;
		$res = $query->select("SELECT t.id, t.description FROM " . $cfgDatabase['topic'] . " AS t, " . $cfgDatabase['post'] . " AS p WHERE t.forumid = $forumid AND t.lastpostid = p.id ORDER BY p.date DESC");
		if ($begin < 1) $begin = 1;
		if ($begin > $query->rows) $begin = $query->rows;
		$end = $begin;
		$begin = 1;
		$count = $cfgThreadsPerPage;				//better check here
		if ($count <= 0 || $count > $query->rows) $count = $query->rows;
		while ($begin + $count <= $end)
		{
			$i++;
			$begin = $begin + $count;
			//$pageList .= "<a href=\"$PHP_SELF?action=get_topics&categoryid=$categoryid&forumid=$forumid&begin=$begin\">$i</a> | ";
		}
		//$pageList = substr($pageList, 0, -2);
		//if ($pageList != "") $pageList = "Pages [ $pageList ]";
		if ($begin == $end) $end .= $count;
///		if ($query->rows > 0) mysql_data_seek($query->query, $begin - 1);
		$u = 0;
		for ($i = $begin - 1; $i - $begin + 1 < $count && $i < $query->rows; $i++)
		{
			//echo $begin;
///			$query->a = mysql_fetch_array($query->query);
///			${$loop}[$u]['id'] = $query->a['id'];
///			${$loop}[$u]['description'] = htmlspecialchars(stripslashes($query->a['description']));
			${$loop}[$u]['id'] = $res[$i]['id'];
			${$loop}[$u]['description'] = htmlspecialchars(stripslashes($res[$i]['description']));
			$u++;
		}
		if ($begin - $count >= 1)
		{
			$prev = $begin - $count;
			$prevSetOfTopics = TRUE;
		}
		if ($begin + $count <= $query->rows)
		{
			$next = $begin + $count;
			$nextSetOfTopics = TRUE;
		}
		$template->register($templateHandler, "prev, next, categoryid, forumid, pageList");
	}
	else
	{
		header("Location: $PAGE_BACK");
		exit;
	}
}
else if ($action == "get_topic_properties")
{
	$actionGetTopicProperties = TRUE;
	$query = new MySQL;
	$res = $query->select("SELECT * FROM " . $cfgDatabase['topic'] . " WHERE id = $topicid");
	if ($query->rows != 1)
		sendError("Topic already doesn't exist anymore");
	$topicDescription = htmlspecialchars(stripslashes($res[0]['description']));
	$topicStartPost = $res[0]['postid'];
	$topicLastPost = $res[0]['lastpostid'];
	$topicActive = $res[0]['active'];
	$topicViews = $res[0]['views'];
	$topicForumID = $res[0]['forumid'];
	$template->register($templateHandler, "topicid, topicDescription, topicStartPost, topicLastPost, topicActive, topicViews");
	$loop = "forums3";
	$res = $query->select("SELECT id, name FROM " . $cfgDatabase['forum'] . " ORDER BY position");
	if ($query->rows < 1)
		sendError("No forums");
	for ($i = 0; $i < $query->rows; $i++)
	{
		${$loop}[$i]['id'] = $res[$i]['id'];
		${$loop}[$i]['name'] = $res[$i]['name'];
		${$loop}[$i]['selected'] = ($res[$i]['id'] == $topicForumID)?" selected ":"";
	}
	$PAGE_BACK = "$PHP_SELF?action=get_topics&forumid=$topicForumID";
}
else if ($action == "set_topic_properties")
{
	if ($topicid > 0)
	{
		$PAGE_BACK = "$PHP_SELF?action=get_topic_properties&topicid=$topicid";
		if (isset($topicDescription) && !empty($topicDescription) && ($topicActive == 0 || $topicActive == 1) && $topicForumID > 0)
		{
			$query = new MySQL;
			$query->query("UPDATE " . $cfgDatabase['topic'] . " SET description = '" . addslashes($topicDescription) . "', active = $topicActive, forumid = $topicForumID WHERE id = $topicid");
		}
//		else
//		{
			header("Location: $PAGE_BACK");
			exit;
//		}
	}
	else
	{
		header("Location: $PHP_SELF?action=get_topics&forumid=$topicForumID");
		exit;
	}
}
else if ($action == "delete_topic")
{
	$PAGE_BACK = "$PHP_SELF?action=get_topics&forumid=$forumid";
	$actionDeleteTopic = TRUE;
	if (isset($topicid) && !empty($topicid))
	{
		if ($verify == 1)
		{
			$query = new MySQL;
//			echo "Locking all applicable topics<br>\n";
//			flush();
			$query->query("UPDATE " . $cfgDatabase['topic'] . " SET active = 0 WHERE id = $topicid");
//			echo "Waiting 10 seconds for connections to close...<p>\n";
//			flush();
			sleep(10);

			$query->query("DELETE FROM " . $cfgDatabase['post'] . " WHERE topicid = $topicid");
			$query->query("DELETE FROM " . $cfgDatabase['topic'] . " WHERE id = $topicid");

			header("Location: $PAGE_BACK");
			exit;
		}
		else
		{
			//show 'delete_category'-form
			$template->register($templateHandler, "topicid");
		}
	}
	else
	{
		header("Location: $PAGE_BACK");
		exit;
	}
}
else if ($action == "purge_topics")
{
	$PAGE_BACK = "$PHP_SELF?";
	$actionPurgeTopics = TRUE;
	if ($verify == 1)
	{
		$query = new MySQL;
		$res = $query->select("SELECT id FROM " . $cfgDatabase['topic'] . " WHERE active = 0");
		$topicIDs = "";
		for ($i = 0; $i < $query->rows; $i++)
			$topicIDs .= $res[$i]['id'] . ", ";
		$topicIDs = substr($topicIDs, 0, -2);
		if ($topicIDs != "") $query->query("DELETE FROM " . $cfgDatabase['post'] . " WHERE topicid IN ($topicIDs)");
		$query->query("DELETE FROM " . $cfgDatabase['topic'] . " WHERE active = 0");

		header("Location: $PAGE_BACK");
		exit;
	}
	else
	{
		//nix
	}
}
else if ($action == "purge_users")
{
	$PAGE_BACK = "$PHP_SELF?";
	$actionPurgeUsers = TRUE;
	if ($verify == 1)
	{
		$query = new MySQL;
		$res = $query->select("SELECT id FROM " . $cfgDatabase['user'] . " WHERE activated = 0 AND registerdate < " . (time() - (15 * 24 * 60 * 60)));
		$query->query("DELETE FROM " . $cfgDatabase['user'] . " WHERE activated = 0 AND registerdate < " . (time() - (15 * 24 * 60 * 60)));

		$userIDs = "";
		for ($i = 0; $i < sizeof($res); $i++)
		{
			$res2 = $query->select("SELECT COUNT(*) AS count FROM " . $cfgDatabase['post'] . " WHERE posterid = " . $res[$i]['id']);
			if ($query->rows == 1)						// only include users that have not posted yet
				if ($res[0]['count'] > 0)
					$userIDs .= $res[$i]['id'] . ", ";
				else
					;
			else
				sendError("pe: Query error");
		}
		$userIDs = substr($userIDs, 0, -1);
		if ($userIDs != "") $query->query("UPDATE " . $cfgDatabase['post'] . " SET posterid = 0 WHERE posterid IN ($userIDs)");

		header("Location: $PAGE_BACK");
		exit;
	}
	else
	{
		//nix
	}
}
else if ($action == "get_moderators")
{
	$actionGetModerators = TRUE;
	$loop = "moderators";
	$query = new MySQL;
	$res = $query->select("SELECT f.name AS forumname, f.id AS forumid, u.nickname AS usernickname, u.id AS userid FROM " . $cfgDatabase['moderator'] . " AS m, " . $cfgDatabase['user'] . " AS u, " . $cfgDatabase['forum'] . " AS f WHERE m.forumid = f.id AND m.userid = u.id AND u.groupid >= 2 ORDER BY m.forumid");

	$i = 0;
	for ($i = 0; $i < $query->rows; $i++)
	{
		${$loop}[$i]['forumName'] = "<a href='" . $cfgBaseURL . "forumDisplay.php?forumID=" . $res[$i]['forumid'] . "' target='_blank'>" . htmlspecialchars(stripslashes($res[$i]['forumname'])) . "</a>";
		${$loop}[$i]['forumid'] = $res[$i]['forumid'];
		${$loop}[$i]['userNickname'] = "<a href='" . $cfgBaseURL . "viewProfile.php?userID=" . $res[$i]['userid'] . "' target='viewProfile'>" . htmlspecialchars(stripslashes($res[$i]['usernickname'])) . "</a>";
		${$loop}[$i]['userid'] = $res[$i]['userid'];
	}
}
else if ($action == "add_moderator")
{
	$PAGE_BACK = "$PHP_SELF?action=get_moderators";
	$query = new MySQL;
	$actionAddModerator = TRUE;
	if ($userid > 0 && $forumid > 0)
	{
		$res = $query->select("SELECT * FROM " . $cfgDatabase['moderator'] . " WHERE forumid = $forumid AND userid = $userid");
		$PREV_MSG = "";
		if ($query->rows == 0)
		{
			$res = $query->select("SELECT groupid FROM " . $cfgDatabase['user'] . " WHERE id = $userid");
			if ($query->rows != 1)
				sendError("pe: Error locating user");
			if ($res[0]['groupid'] < 2)
				$query->query("UPDATE " . $cfgDatabase['user'] . " SET groupid = 2 WHERE id = $userid");
/*			else if ($res[0]['groupid > 2)							//when admins can't be a moderator
				$PREV_MSG = "Administrators can't be moderator";
			else if ($res[0]['groupid == 2)
				;*/
			$query->query("INSERT INTO " . $cfgDatabase['moderator'] . " (forumid, userid) VALUES ($forumid, $userid)");

			if ($PREV_MSG == "")
			{
				header("Location: $PAGE_BACK");
				exit;
			}
		}
		else
		{
			$PREV_MSG = "This combination of forum moderator already exists.";
		}
	}
	//else
	//{
		$loop[0] = "usrs";
		$loop[1] = "fors";
		$res = $query->select("SELECT id, nickname FROM " . $cfgDatabase['user'] . (($onlyModerators == TRUE)?" WHERE groupid > 1":"") . " ORDER BY nickname ASC");
		for ($i = 0; $i < $query->rows; $i++)
		{
			${$loop[0]}[$i]['nickname'] = htmlspecialchars(stripslashes($res[$i]['nickname']));
			${$loop[0]}[$i]['id'] = $res[$i]['id'];
		}
		$res = $query->select("SELECT id, name FROM " . $cfgDatabase['forum'] . " ORDER BY name ASC");
		for ($i = 0; $i < $query->rows; $i++)
		{
			${$loop[1]}[$i]['name'] = htmlspecialchars(stripslashes($res[$i]['name']));
			${$loop[1]}[$i]['id'] = $res[$i]['id'];
		}
	//}
}
else if ($action == "delete_moderator")
{
	$PAGE_BACK = "$PHP_SELF?action=get_moderators";
	$actionDeleteModerator = TRUE;
	if ($userid > 0 && $forumid > 0)
	{
		if ($verify)
		{
			$query = new MySQL;
			$query->query("DELETE FROM " . $cfgDatabase['moderator'] . " WHERE forumid = $forumid AND userid = $userid");
			header("Location: $PAGE_BACK");
			exit;
		}
		else
		{
			$template->register($templateHandler, "userid, forumid");
		}
	}
	else
	{
		header("Location: $PAGE_BACK");
		exit;
	}
}
else if ($action == "update")
{
	$snoopy = new Snoopy();
	$UPDATE_AVAILABLE = FALSE;
	if ($snoopy->fetchtext(YAPBB_VERSION_URL))	// retrieve text
		if (ereg("200", $snoopy->response_code))			// check if succeeded and available
			$UPDATE_AVAILABLE = is_update_available(YAPBB_VERSION, $snoopy->results);// compare version
		else
			$snoopy->results = "";

	$actionUpdate = TRUE;
	$LOCAL_VERSION = htmlspecialchars(YAPBB_VERSION);
	$REMOTE_VERSION = htmlspecialchars($snoopy->results);
	$template->register($templateHandler, "LOCAL_VERSION, REMOTE_VERSION");
}
else if ($action == "update_search_index")
{
	if ($CAN_SET_TIME_LIMIT = function_exists("set_time_limit") && !get_cfg_var('safe_mode'))
		set_time_limit(0);

	if ($HTTP_POST_VARS['verify'])
	{
		$searcher = new Searcher();
		$query = new MySQL();
		$res = $query->select("SELECT text, id FROM " . $cfgDatabase['post']);
		for ($i = 0; $i < $query->rows; $i++)
			$searcher->update_post(stripslashes($res[$i]['text']), $res[$i]['id']);
		header("Location: $PHP_SELF");
	}
	$actionUpdateSearchIndex = TRUE;
}
else if ($action == "get_config_site")
{
	$actionGetConfigSite = TRUE;
	$siteTitle = htmlspecialchars($cfgSiteTitle);
	$siteHomeURL = htmlspecialchars($cfgSiteHomeURL);
	$template->register($templateHandler, "siteTitle, siteHomeURL");
}
else if ($action == "set_config_site")
{
	if ($cfgBoardDisabled)
	{
		if (isset($siteTitle) && !empty($siteTitle) && isset($siteHomeURL) && !empty($siteHomeURL))
		{
			updateConfig("siteTitle");
			updateConfig("siteHomeURL");
			header("Location: $PHP_SELF");
			exit;
		}
		else
		{
			header("Location: $PHP_SELF?action=get_config_site");
			exit;
		}
	}
	else
	{
		$errorBoardEnabled = TRUE;
	}
}


if (!$template->load_file($templateHandler, "$cfgTemplateDirectory$cfgTemplateName/controlPanel.ybt"))
	if (!$template->load_file($templateHandler, $cfgTemplateDirectory . "Default/controlPanel.ybt"))
		sendError("pe: Could not load template (controlPanel.ybt)!");

if (isset($loop) && !empty($loop))
{
	if (is_array($loop))
		for ($i = 0; $i < sizeof($loop); $i++)
			$template->parse_loop($templateHandler, $loop[$i]);
	else
		$template->parse_loop($templateHandler, $loop);
}
$PAGE_RELOAD = $HTTP_ENV_VARS["REQUEST_URI"];
if ($PAGE_RELOAD == "")
	$PAGE_RELOAD = getenv('REQUEST_URI');
if ($PAGE_RELOAD == "")
	$PAGE_RELOAD = $PHP_SELF . "?" . getenv('QUERY_STRING');
if ($PAGE_RELOAD == "" || $PAGE_RELOAD == $PHP_SELF . "?")
{
	$tmp = $HTTP_SERVER_VARS['argv'];
	$PAGE_RELOAD = $PHP_SELF . "?" . $tmp[0];
	unset($tmp);
}
/*$PAGE_BACK = $HTTP_ENV_VARS["HTTP_REFERER"];
$left = is_long(strpos($PAGE_BACK, "cpleft"));
$right = !is_long(strpos($PAGE_BACK, "targetWindow="));
$isBack = (!empty($PAGE_BACK) && (!$left XOR $right));*/
$isBack = (!empty($PAGE_BACK));
$template->register($templateHandler, "PAGE_RELOAD, PAGE_BACK, PREV_MSG");
$tmp = $template->pget($templateHandler);
echo $tmp;
if ($cfgUseCompression) gzdocout();

require($cfgIncludeDirectory . "cleanup.php");
?>
